/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LAInterpolator {
    public static final String ANNOT_LA = ":LA";
    Interpolator mInterpolator;

    public LAInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public static Term createLATerm(InterpolatorAffineTerm interpolatorAffineTerm, InfinitesimalNumber infinitesimalNumber, Term term) {
        Theory theory = term.getTheory();
        return theory.annotatedTerm(new Annotation[]{new Annotation(ANNOT_LA, (Object)new Object[]{interpolatorAffineTerm, infinitesimalNumber})}, term);
    }

    public static boolean isLATerm(Term term) {
        if (term instanceof AnnotatedTerm) {
            Annotation[] annotationArray = ((AnnotatedTerm)term).getAnnotations();
            return annotationArray.length == 1 && annotationArray[0].getKey().equals(ANNOT_LA);
        }
        return false;
    }

    public static InterpolatorAffineTerm getS(Term term) {
        assert (LAInterpolator.isLATerm(term));
        return (InterpolatorAffineTerm)((Object[])((AnnotatedTerm)term).getAnnotations()[0].getValue())[0];
    }

    public static InfinitesimalNumber getK(Term term) {
        assert (LAInterpolator.isLATerm(term));
        return (InfinitesimalNumber)((Object[])((AnnotatedTerm)term).getAnnotations()[0].getValue())[1];
    }

    public static Term getF(Term term) {
        assert (LAInterpolator.isLATerm(term));
        return ((AnnotatedTerm)term).getSubterm();
    }

    private HashMap<Term, Rational> getFarkasCoeffs(InterpolatorClauseInfo interpolatorClauseInfo) {
        HashMap<Term, Rational> hashMap = new HashMap<Term, Rational>();
        Term[] termArray = interpolatorClauseInfo.getLiterals();
        Object[] objectArray = (Object[])interpolatorClauseInfo.getLemmaAnnotation();
        int n = 0;
        while (n < objectArray.length) {
            Rational rational = SMTAffineTerm.convertConstant((ConstantTerm)objectArray[n]);
            hashMap.put(termArray[n], rational);
            ++n;
        }
        return hashMap;
    }

    public Term[] computeInterpolants(InterpolatorClauseInfo interpolatorClauseInfo) {
        Object object;
        Term term;
        InterpolatorAffineTerm[] interpolatorAffineTermArray = new InterpolatorAffineTerm[this.mInterpolator.mNumInterpolants + 1];
        int n = 0;
        while (n < interpolatorAffineTermArray.length) {
            interpolatorAffineTermArray[n] = new InterpolatorAffineTerm();
            ++n;
        }
        ArrayList[] arrayListArray = new ArrayList[this.mInterpolator.mNumInterpolants];
        for (Map.Entry<Term, Rational> termArray2 : this.getFarkasCoeffs(interpolatorClauseInfo).entrySet()) {
            term = this.mInterpolator.getAtom(termArray2.getKey());
            object = this.mInterpolator.getAtomTermInfo(term);
            boolean bl = term == termArray2.getKey();
            Rational rational = termArray2.getValue();
            assert (((InterpolatorAtomInfo)object).isBoundConstraint() || !bl && ((InterpolatorAtomInfo)object).isLAEquality());
            Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo(term);
            InterpolatorAffineTerm interpolatorAffineTerm = new InterpolatorAffineTerm(((InterpolatorAtomInfo)object).getAffineTerm());
            if (bl) {
                interpolatorAffineTerm.add(((InterpolatorAtomInfo)object).getEpsilon().negate());
            }
            int n2 = 0;
            while (n2 < interpolatorAffineTermArray.length) {
                if (litInfo.isMixed(n2)) {
                    assert (litInfo.mMixedVar != null);
                    interpolatorAffineTermArray[n2].add(rational, litInfo.getAPart(n2));
                    interpolatorAffineTermArray[n2].add(rational.negate(), (Term)litInfo.mMixedVar);
                    if (arrayListArray[n2] == null) {
                        arrayListArray[n2] = new ArrayList();
                    }
                    arrayListArray[n2].add(litInfo.mMixedVar);
                } else if (litInfo.isALocal(n2)) {
                    interpolatorAffineTermArray[n2].add(rational, interpolatorAffineTerm);
                }
                ++n2;
            }
        }
        assert (interpolatorAffineTermArray[interpolatorAffineTermArray.length - 1].isConstant() && interpolatorAffineTermArray[interpolatorAffineTermArray.length - 1].getConstant().signum() > 0);
        Term[] termArray = new Term[this.mInterpolator.mNumInterpolants];
        int n3 = 0;
        while (n3 < arrayListArray.length) {
            term = interpolatorAffineTermArray[n3].isConstant() ? Rational.ONE : interpolatorAffineTermArray[n3].getGcd().inverse().abs();
            interpolatorAffineTermArray[n3].mul((Rational)term);
            if (interpolatorAffineTermArray[n3].isInt()) {
                object = interpolatorAffineTermArray[n3].getConstant();
                interpolatorAffineTermArray[n3].add(((InfinitesimalNumber)object).ceil().sub((InfinitesimalNumber)object));
            }
            termArray[n3] = interpolatorAffineTermArray[n3].toLeq0(this.mInterpolator.mTheory);
            if (arrayListArray[n3] != null) {
                object = interpolatorAffineTermArray[n3].isInt() ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
                termArray[n3] = LAInterpolator.createLATerm(interpolatorAffineTermArray[n3], ((InfinitesimalNumber)object).negate(), termArray[n3]);
            }
            ++n3;
        }
        return termArray;
    }

    public Term[] computeTrichotomyInterpolants(InterpolatorClauseInfo interpolatorClauseInfo) {
        InterpolatorAtomInfo interpolatorAtomInfo;
        Term term;
        Term[] termArray;
        Interpolator.Occurrence occurrence = null;
        TermVariable termVariable = null;
        TermVariable termVariable2 = null;
        int[] nArray = new int[this.mInterpolator.mNumInterpolants];
        int[] nArray2 = new int[this.mInterpolator.mNumInterpolants];
        Term[] termArray2 = new Term[this.mInterpolator.mNumInterpolants];
        Term[] termArray3 = new Term[this.mInterpolator.mNumInterpolants];
        assert (interpolatorClauseInfo.getLiterals().length == 3);
        Term term2 = interpolatorClauseInfo.getLiterals();
        int n = ((Term[])term2).length;
        int n2 = 0;
        while (n2 < n) {
            termArray = term2[n2];
            term = this.mInterpolator.getAtom((Term)termArray);
            interpolatorAtomInfo = this.mInterpolator.getAtomTermInfo(term);
            Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo(term);
            boolean bl = term == termArray;
            int n3 = 0;
            while (n3 < this.mInterpolator.mNumInterpolants) {
                if (litInfo.isALocal(n3)) {
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + 1;
                    termArray2[n3] = termArray;
                } else if (litInfo.isBLocal(n3)) {
                    int n5 = n3;
                    nArray2[n5] = nArray2[n5] + 1;
                    termArray3[n3] = termArray;
                }
                ++n3;
            }
            if (interpolatorAtomInfo.isBoundConstraint()) {
                if (bl) {
                    termVariable2 = litInfo.getMixedVar();
                } else {
                    termVariable = litInfo.getMixedVar();
                }
            } else {
                assert (bl && interpolatorAtomInfo.isLAEquality());
                occurrence = litInfo;
            }
            ++n2;
        }
        termArray = new Term[this.mInterpolator.mNumInterpolants];
        n2 = 0;
        while (n2 < this.mInterpolator.mNumInterpolants) {
            if (occurrence.isMixed(n2)) {
                InterpolatorAffineTerm interpolatorAffineTerm = new InterpolatorAffineTerm();
                interpolatorAffineTerm.add(Rational.MONE, (Term)termVariable);
                interpolatorAffineTerm.add(Rational.ONE, (Term)termVariable2);
                term2 = this.mInterpolator.mTheory.term("<=", new Term[]{termVariable2, termVariable});
                term = this.mInterpolator.mTheory.term("<", new Term[]{termVariable2, termVariable});
                interpolatorAtomInfo = this.mInterpolator.mTheory.and(new Term[]{term2, this.mInterpolator.mTheory.or(new Term[]{term, this.mInterpolator.mTheory.term("@EQ", new Term[]{((Interpolator.LitInfo)occurrence).getMixedVar(), termVariable})})});
                termArray[n2] = LAInterpolator.createLATerm(interpolatorAffineTerm, InfinitesimalNumber.ZERO, (Term)interpolatorAtomInfo);
            } else {
                assert (nArray[n2] + nArray2[n2] <= 3);
                if (nArray[n2] == 0) {
                    termArray[n2] = this.mInterpolator.mTheory.mTrue;
                } else if (nArray2[n2] == 0) {
                    termArray[n2] = this.mInterpolator.mTheory.mFalse;
                } else if (nArray[n2] == 1) {
                    termArray[n2] = this.mInterpolator.mTheory.not(termArray2[n2]);
                } else {
                    assert (nArray2[n2] == 1);
                    termArray[n2] = termArray3[n2];
                }
            }
            ++n2;
        }
        return termArray;
    }
}

