/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AffineTerm
extends AbstractGeneralizedAffineTerm<Term> {
    public AffineTerm() {
    }

    public AffineTerm(Sort sort, Rational rational, Map<Term, Rational> map) {
        super(sort, rational, map);
    }

    protected AffineTerm constructNew(Sort sort, Rational rational, Map<Term, Rational> map) {
        return new AffineTerm(sort, rational, map);
    }

    @Override
    protected Term constructAbstractVar(Term term) {
        return term;
    }

    public static AffineTerm constructConstant(Sort sort, Rational rational) {
        return new AffineTerm(sort, rational, Collections.emptyMap());
    }

    public static AffineTerm constructConstant(Sort sort, BigInteger bigInteger) {
        return new AffineTerm(sort, Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), Collections.emptyMap());
    }

    public static AffineTerm constructConstant(Sort sort, long l) {
        return new AffineTerm(sort, Rational.valueOf((long)l, (long)1L), Collections.emptyMap());
    }

    public static AffineTerm constructVariable(Term term) {
        return new AffineTerm(term.getSort(), Rational.ZERO, Collections.singletonMap(term, Rational.ONE));
    }

    static AffineTerm sum(IPolynomialTerm ... iPolynomialTermArray) {
        PolynomialTermUtils.GeneralizedConstructor generalizedConstructor = AffineTerm::new;
        return PolynomialTermUtils.constructSum(iPolynomialTerm -> ((AffineTerm)iPolynomialTerm).getVariable2Coefficient(), generalizedConstructor, iPolynomialTermArray);
    }

    public static AffineTerm mul(IPolynomialTerm iPolynomialTerm2, Rational rational) {
        PolynomialTermUtils.GeneralizedConstructor generalizedConstructor = AffineTerm::new;
        return PolynomialTermUtils.constructMul(iPolynomialTerm -> ((AffineTerm)iPolynomialTerm).getVariable2Coefficient(), generalizedConstructor, iPolynomialTerm2, rational);
    }

    public static AffineTerm mulAffineTerms(IPolynomialTerm iPolynomialTerm, IPolynomialTerm iPolynomialTerm2) {
        if (iPolynomialTerm.isConstant()) {
            return AffineTerm.mul(iPolynomialTerm2, iPolynomialTerm.getConstant());
        }
        if (iPolynomialTerm2.isConstant()) {
            return AffineTerm.mul(iPolynomialTerm, iPolynomialTerm2.getConstant());
        }
        throw new UnsupportedOperationException("The outcome of this product is not affine!");
    }

    public Map<Term, Rational> getVariable2Coefficient() {
        return Collections.unmodifiableMap(this.mAbstractVariable2Coefficient);
    }

    @Override
    public Map<Monomial, Rational> getMonomial2Coefficient() {
        return this.mAbstractVariable2Coefficient.entrySet().stream().collect(Collectors.toMap(entry -> new Monomial((Term)entry.getKey(), Rational.ONE), Map.Entry::getValue));
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public boolean isVariable(Term term) {
        return this.mAbstractVariable2Coefficient.containsKey(term);
    }

    @Override
    protected Term abstractVariableToTerm(Script script, Term term) {
        return term;
    }

    @Override
    protected Collection<Term> getFreeVars(Term term) {
        return Arrays.asList(term.getFreeVars());
    }

    @Override
    protected Term abstractVariableTimesCoeffToTerm(Script script, Term term, Rational rational) {
        Term[] termArray = new Term[]{term, SmtUtils.rational2Term(script, rational, this.mSort)};
        return SmtUtils.mul(script, this.mSort, termArray);
    }

    @Override
    protected Pair<Rational, Rational> computeMinMax() {
        Rational rational = Rational.ZERO;
        Rational rational2 = Rational.ZERO;
        for (Map.Entry entry : this.mAbstractVariable2Coefficient.entrySet()) {
            Rational rational3 = this.checkForModTerm((Term)entry.getKey());
            if (rational3 == null) {
                return null;
            }
            if (((Rational)entry.getValue()).isNegative()) {
                rational2 = rational2.add(((Rational)entry.getValue()).mul(rational3.add(Rational.MONE)));
                continue;
            }
            rational = rational.add(((Rational)entry.getValue()).mul(rational3.add(Rational.MONE)));
        }
        rational = rational.add(this.getConstant());
        rational2 = rational2.add(this.getConstant());
        return new Pair((Object)rational2, (Object)rational);
    }

    @Override
    public AffineTerm add(Rational rational) {
        Rational rational2;
        if (SmtSortUtils.isRealSort(this.getSort())) {
            rational2 = this.getConstant().add(rational);
        } else if (SmtSortUtils.isIntSort(this.getSort())) {
            if (!rational.isIntegral()) {
                throw new UnsupportedOperationException("Cannot add non-integral summand if sort is " + String.valueOf(this.getSort()));
            }
            rational2 = this.getConstant().add(rational);
        } else if (SmtSortUtils.isBitvecSort(this.getSort())) {
            if (!rational.isIntegral()) {
                throw new UnsupportedOperationException("Cannot add non-integral summand if sort is " + String.valueOf(this.getSort()));
            }
            rational2 = PolynomialTermUtils.bringBitvectorValueInRange(this.getConstant().add(rational), this.getSort());
        } else {
            throw new AssertionError((Object)("unsupported Sort " + String.valueOf(this.getSort())));
        }
        return new AffineTerm(this.getSort(), rational2, this.getAbstractVariable2Coefficient());
    }

    @Override
    public AbstractGeneralizedAffineTerm<Term> removeAndNegate(Monomial monomial) {
        HashMap<Term, Rational> hashMap = new HashMap<Term, Rational>();
        for (Map.Entry rational2 : this.mAbstractVariable2Coefficient.entrySet()) {
            if (((Term)rational2.getKey()).equals(monomial.getSingleVariable())) continue;
            Rational rational = PolynomialTermUtils.bringValueInRange(((Rational)rational2.getValue()).negate(), this.getSort());
            hashMap.put((Term)rational2.getKey(), rational);
        }
        Rational rational = PolynomialTermUtils.bringValueInRange(this.getConstant().negate(), this.getSort());
        return new AffineTerm(this.getSort(), rational, (Map<Term, Rational>)hashMap);
    }

    @Override
    public AffineTerm divInvertible(Rational rational) {
        HashMap<Term, Rational> hashMap = new HashMap<Term, Rational>();
        for (Map.Entry rational22 : this.mAbstractVariable2Coefficient.entrySet()) {
            Rational rational2 = PolynomialTermUtils.divInvertible(this.getSort(), (Rational)rational22.getValue(), rational);
            if (rational2 == null) {
                return null;
            }
            hashMap.put((Term)rational22.getKey(), rational2);
        }
        Rational rational3 = PolynomialTermUtils.divInvertible(this.getSort(), this.getConstant(), rational);
        if (rational3 == null) {
            return null;
        }
        return new AffineTerm(this.getSort(), rational3, (Map<Term, Rational>)hashMap);
    }
}

