/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.results.SyntaxErrorResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.Activator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.generator.RtInconcistencyConditionGenerator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.ReqCheckSuccessResult;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.RequirementInconsistentErrorResult;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.RequirementTransformationErrorResult;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.RequirementTypeErrorResult;
import java.util.HashSet;
import java.util.Set;

public class PeaResultUtil {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private boolean mIsAborted;
    private final Set<String> mExprWithTypeErrors;

    public PeaResultUtil(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mIsAborted = false;
        this.mExprWithTypeErrors = new HashSet<String>();
    }

    public boolean isAlreadyAborted() {
        return this.mIsAborted;
    }

    public void transformationError(PatternType<?> patternType, String string) {
        assert (patternType != null);
        RequirementTransformationErrorResult requirementTransformationErrorResult = new RequirementTransformationErrorResult(patternType.getId(), string);
        this.mLogger.warn((Object)requirementTransformationErrorResult.getLongDescription());
        this.report((IResult)requirementTransformationErrorResult);
    }

    public void syntaxError(ILocation iLocation, String string) {
        this.errorAndAbort(iLocation, string, (IResult)new SyntaxErrorResult(Activator.PLUGIN_ID, iLocation, string));
    }

    public void typeError(PatternType<?> patternType, String string) {
        this.typeError(patternType.getId(), string);
    }

    public void typeError(String string, String string2) {
        this.errorAndAbort((IResult)new RequirementTypeErrorResult(string, string2));
    }

    public void typeError(String string, Expression expression) {
        if (this.mExprWithTypeErrors.add(expression.toString())) {
            this.errorAndAbort((IResult)new RequirementTypeErrorResult(expression.getLoc().getStartLine(), BoogiePrettyPrinter.print((Expression)expression) + " :" + string));
        }
    }

    public void intrinsicRtConsistencySuccess(IElement iElement) {
        String string = Activator.PLUGIN_ID;
        this.report((IResult)new ReqCheckSuccessResult<IElement>(iElement, string));
    }

    public void infeasibleInvariant(RtInconcistencyConditionGenerator.InvariantInfeasibleException invariantInfeasibleException) {
        this.errorAndAbort((IResult)new RequirementInconsistentErrorResult(invariantInfeasibleException));
    }

    private void errorAndAbort(IResult iResult) {
        this.mLogger.error((Object)iResult.getLongDescription());
        this.report(iResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
        this.mIsAborted = true;
    }

    private void errorAndAbort(ILocation iLocation, String string, IResult iResult) {
        this.mLogger.error((Object)(String.valueOf(iLocation) + ": " + string));
        this.report(iResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
        this.mIsAborted = true;
    }

    private void report(IResult iResult) {
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
    }
}

