/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.BoogiePreprocessorBacktranslator;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.NormalFormTransformer;

public class Simplifier
extends BaseObserver {
    private final BoogiePreprocessorBacktranslator mTranslator;
    private final NormalFormTransformer<Expression> mSimplifier;

    protected Simplifier(BoogiePreprocessorBacktranslator boogiePreprocessorBacktranslator) {
        this.mTranslator = boogiePreprocessorBacktranslator;
        this.mSimplifier = new NormalFormTransformer((INormalFormable)new BoogieExpressionTransformer());
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof Unit) {
            Unit unit = (Unit)iElement;
            this.processUnit(unit);
            return false;
        }
        return true;
    }

    private void processUnit(Unit unit) {
        BoogieStatementSimplifier boogieStatementSimplifier = new BoogieStatementSimplifier();
        Declaration[] declarationArray = unit.getDeclarations();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement[] statementArray;
            Procedure procedure;
            Body body;
            Declaration declaration = declarationArray[n2];
            if (declaration instanceof Procedure && (body = (procedure = (Procedure)declaration).getBody()) != null && (statementArray = body.getBlock()) != null && statementArray.length != 0) {
                boolean bl = false;
                Statement[] statementArray2 = new Statement[statementArray.length];
                int n3 = 0;
                Statement[] statementArray3 = statementArray;
                int n4 = statementArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Statement statement;
                    Statement statement2 = statementArray3[n5];
                    statementArray2[n3] = statement = statement2.accept((GeneratedBoogieAstTransformer)boogieStatementSimplifier);
                    ++n3;
                    bl |= statement != statement2;
                    ++n5;
                }
                if (bl) {
                    body.setBlock(statementArray2);
                }
            }
            ++n2;
        }
    }

    private final class BoogieStatementSimplifier
    extends GeneratedBoogieAstTransformer {
        private BoogieStatementSimplifier() {
        }

        public Statement transform(AssumeStatement assumeStatement) {
            Expression expression;
            Expression expression2 = assumeStatement.getFormula();
            if (expression2 == (expression = (Expression)Simplifier.this.mSimplifier.simplify((Object)expression2))) {
                return assumeStatement;
            }
            Simplifier.this.mTranslator.addMapping((BoogieASTNode)expression2, (BoogieASTNode)expression);
            return new AssumeStatement(assumeStatement.getLoc(), assumeStatement.getAttributes(), expression);
        }
    }
}

