/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.srparse;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.srparse.LiteralUtils;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Durations {
    private final Map<String, Rational> mKnownNumericConstants = new LinkedHashMap<String, Rational>();
    private final Set<Rational> mKnownNumericValues = new HashSet<Rational>();
    private final Consumer<String> mFunAddError;
    private final DirtyLazy<Rational> mEpsilon;
    private final DirtyLazy<Rational> mScalingFactor;

    public Durations(Consumer<String> consumer) {
        this.mFunAddError = consumer;
        this.mEpsilon = new DirtyLazy<Rational>(this::computeEpsilonInternal);
        this.mScalingFactor = new DirtyLazy<Rational>(this::computeScalingFactorInternal);
    }

    public Durations() {
        this(string -> {});
    }

    private Rational computeEpsilonInternal() {
        return this.mKnownNumericValues.isEmpty() ? Rational.ZERO : SmtUtils.gcd(this.mKnownNumericValues).div(Rational.TWO);
    }

    private Rational computeScalingFactorInternal() {
        if (this.mKnownNumericValues.isEmpty()) {
            return Rational.ONE;
        }
        List list = this.mKnownNumericValues.stream().filter(rational -> !rational.isIntegral()).collect(Collectors.toList());
        if (list.isEmpty()) {
            return Rational.ONE;
        }
        if (list.size() == 1) {
            return Rational.valueOf((BigInteger)((Rational)list.get(0)).denominator().abs(), (BigInteger)BigInteger.ONE);
        }
        Iterator iterator = list.stream().map(rational -> rational.denominator().abs()).iterator();
        BigInteger bigInteger = (BigInteger)iterator.next();
        BigInteger bigInteger2 = (BigInteger)iterator.next();
        BigInteger bigInteger3 = Rational.gcd((BigInteger)bigInteger, (BigInteger)bigInteger2);
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger2).abs().divide(bigInteger3);
        while (iterator.hasNext()) {
            BigInteger bigInteger5 = (BigInteger)iterator.next();
            bigInteger3 = Rational.gcd((BigInteger)bigInteger4, (BigInteger)bigInteger5);
            bigInteger4 = bigInteger4.multiply(bigInteger5).abs().divide(bigInteger3);
        }
        return Rational.valueOf((BigInteger)bigInteger4, (BigInteger)BigInteger.ONE);
    }

    public void addInitPattern(DeclarationPattern declarationPattern) {
        if (declarationPattern.getCategory() != DeclarationPattern.VariableCategory.CONST) {
            return;
        }
        BoogiePrimitiveType boogiePrimitiveType = BoogiePrimitiveType.toPrimitiveType((String)declarationPattern.getType());
        if (boogiePrimitiveType != BoogieType.TYPE_INT && boogiePrimitiveType != BoogieType.TYPE_REAL) {
            return;
        }
        Expression expression = declarationPattern.getExpression();
        Rational rational = this.tryParse(declarationPattern, expression);
        if (rational == null) {
            return;
        }
        this.mKnownNumericConstants.put(declarationPattern.getId(), rational);
    }

    public void addNonInitPattern(PatternType<?> patternType) {
        if (this.mKnownNumericValues.addAll(patternType.getDurations())) {
            this.mEpsilon.markDirty();
            this.mScalingFactor.markDirty();
        }
    }

    private Rational tryParse(DeclarationPattern declarationPattern, Expression expression) {
        Optional<Rational> optional = LiteralUtils.toRational(expression);
        if (optional.isEmpty()) {
            this.error(declarationPattern, "Cannot convert expression " + BoogiePrettyPrinter.print((Expression)expression) + " to Rational");
            return null;
        }
        return optional.get();
    }

    private void error(PatternType<?> patternType, String string) {
        String string2 = String.format("%s: %s", patternType.getId(), string);
        this.mFunAddError.accept(string2);
    }

    public Rational getConstantValue(String string) {
        return this.mKnownNumericConstants.get(string);
    }

    public Set<String> getConstNames() {
        return this.mKnownNumericConstants.keySet();
    }

    public Rational computeEpsilon() {
        return this.mEpsilon.get();
    }

    public Rational computeScalingFactor() {
        return this.mScalingFactor.get();
    }

    public Durations merge(Collection<Durations> collection) {
        Consumer consumer = collection.stream().map(durations -> durations.mFunAddError).reduce(this.mFunAddError, Consumer::andThen);
        Durations durations2 = new Durations(consumer);
        durations2.mKnownNumericConstants.putAll(this.mKnownNumericConstants);
        durations2.mKnownNumericValues.addAll(this.mKnownNumericValues);
        for (Durations durations3 : collection) {
            durations2.mKnownNumericConstants.putAll(durations3.mKnownNumericConstants);
            durations2.mKnownNumericValues.addAll(durations3.mKnownNumericValues);
        }
        return durations2;
    }

    private static final class DirtyLazy<V> {
        private Lazy<V> mValue;
        private final Supplier<V> mFun;

        public DirtyLazy(Supplier<V> supplier) {
            this.mValue = new Lazy(supplier);
            this.mFun = supplier;
        }

        public V get() {
            return (V)this.mValue.get();
        }

        public void markDirty() {
            this.mValue = new Lazy(this.mFun);
        }
    }
}

