/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OctagonDetector
extends NonRecursive {
    private final HashSet<Term> mCheckedTerms;
    private final HashSet<Term> mSubTerms;
    private final HashSet<TermVariable> mCurrentVars;
    private final boolean mOctagon;
    private boolean mIsOctTerm;
    private final ManagedScript mManagedScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;

    public OctagonDetector(ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mCheckedTerms = new HashSet();
        this.mSubTerms = new HashSet();
        this.mCurrentVars = new HashSet();
        this.mOctagon = true;
        this.mManagedScript = managedScript;
        this.mServices = iUltimateServiceProvider;
    }

    public Set<Term> getConjunctSubTerms(Term term) {
        Term term2 = SmtUtils.toCnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (Term)term);
        this.mCheckedTerms.clear();
        this.run(new ConjunctionWalker(term2));
        return this.mSubTerms;
    }

    private void addConjunctTerms(Term term) {
        this.mLogger.debug((Object)("Current Term:" + term.toString()));
        if (this.mCheckedTerms.contains(term)) {
            this.mLogger.debug((Object)"Already checked");
            return;
        }
        if (term instanceof ApplicationTerm) {
            this.mLogger.debug((Object)"ApplicationTerm");
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (applicationTerm.getFunction().getName().compareTo("and") == 0) {
                this.mCheckedTerms.add(term);
                this.mLogger.debug((Object)("> with function name = " + applicationTerm.getFunction().getName()));
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray[n2];
                    this.enqueueWalker(new ConjunctionWalker(term2));
                    ++n2;
                }
                return;
            }
        }
        this.mLogger.debug((Object)"Other Term or other Application Term");
        this.mSubTerms.add(term);
        this.mCheckedTerms.add(term);
    }

    public boolean isOctTerm(Term term) {
        this.mCheckedTerms.clear();
        this.mIsOctTerm = true;
        this.mCurrentVars.clear();
        this.run(new OctagonDetectionWalker(term));
        this.mLogger.debug((Object)(this.mIsOctTerm ? "Term is Oct" : "Term is NOT Oct"));
        return this.mIsOctTerm;
    }

    private void check(Term term) {
        if (!this.mIsOctTerm) {
            return;
        }
        this.mLogger.debug((Object)("Checking Term:" + term.toString()));
        if (term instanceof TermVariable) {
            this.mCurrentVars.add((TermVariable)term);
            if (this.mCurrentVars.size() > 2) {
                this.mIsOctTerm = false;
            }
        } else if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            List<String> list = Arrays.asList("<=", "<", ">", ">=", "=", "+");
            if (list.contains(string)) {
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray[n2];
                    this.enqueueWalker(new OctagonDetectionWalker(term2));
                    ++n2;
                }
            } else {
                this.mIsOctTerm = false;
            }
        } else if (!(term instanceof ConstantTerm)) {
            if (term instanceof AnnotatedTerm) {
                this.enqueueWalker(new OctagonDetectionWalker(((AnnotatedTerm)term).getSubterm()));
            } else {
                this.mIsOctTerm = false;
            }
        }
    }

    public void clearChecked() {
        this.mCheckedTerms.clear();
    }

    public Set<Term> getSubTerms() {
        return this.mSubTerms;
    }

    public boolean isOctagon() {
        return this.mOctagon;
    }

    private static class ConjunctionWalker
    implements NonRecursive.Walker {
        private final Term mTerm;

        public ConjunctionWalker(Term term) {
            this.mTerm = term;
        }

        public void walk(NonRecursive nonRecursive) {
            ((OctagonDetector)nonRecursive).addConjunctTerms(this.mTerm);
        }
    }

    private static class OctagonDetectionWalker
    implements NonRecursive.Walker {
        private final Term mTerm;

        OctagonDetectionWalker(Term term) {
            this.mTerm = term;
        }

        public void walk(NonRecursive nonRecursive) {
            ((OctagonDetector)nonRecursive).check(this.mTerm);
        }
    }
}

