/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.BitvectorTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.IFloatingPointHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;

public class BitvectorFloatingPointHandler
implements IFloatingPointHandler {
    private final BitvectorTranslation mTranslation;

    public BitvectorFloatingPointHandler(BitvectorTranslation bitvectorTranslation) {
        this.mTranslation = bitvectorTranslation;
    }

    @Override
    public Expression roundToIntegral(ILocation iLocation, Expression expression, CPrimitive cPrimitive, Expression expression2) {
        this.mTranslation.declareFloatingPointFunction(iLocation, "fp.roundToIntegral", false, true, cPrimitive, cPrimitive);
        return this.mTranslation.constructCallToSmtOperation(iLocation, "fp.roundToIntegral", cPrimitive, new Expression[]{expression2, expression});
    }

    @Override
    public Expression sqrt(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        this.mTranslation.declareFloatingPointFunction(iLocation, "fp.sqrt", false, true, cPrimitive, cPrimitive);
        return this.mTranslation.constructCallToSmtOperation(iLocation, "fp.sqrt", cPrimitive, new Expression[]{this.mTranslation.getCurrentRoundingMode(), expression});
    }

    @Override
    public Expression abs(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        this.mTranslation.declareFloatingPointFunction(iLocation, "fp.abs", false, false, cPrimitive, cPrimitive);
        return this.mTranslation.constructCallToSmtOperation(iLocation, "fp.abs", cPrimitive, new Expression[]{expression});
    }

    private Expression constructSmtFloatClassificationFunction(ILocation iLocation, String string, Expression expression, CPrimitive cPrimitive) {
        this.mTranslation.declareFloatingPointFunction(iLocation, string, true, false, new CPrimitive(CPrimitive.CPrimitives.BOOL), cPrimitive);
        return this.mTranslation.constructCallToSmtPredicate(iLocation, string, cPrimitive, new Expression[]{expression});
    }

    @Override
    public Expression isNan(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        return this.constructSmtFloatClassificationFunction(iLocation, "fp.isNaN", expression, cPrimitive);
    }

    @Override
    public Expression isInfinite(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        return this.constructSmtFloatClassificationFunction(iLocation, "fp.isInfinite", expression, cPrimitive);
    }

    @Override
    public Expression isNormal(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        return this.constructSmtFloatClassificationFunction(iLocation, "fp.isNormal", expression, cPrimitive);
    }

    @Override
    public Expression isZero(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        return this.constructSmtFloatClassificationFunction(iLocation, "fp.isZero", expression, cPrimitive);
    }

    @Override
    public Expression isSubnormal(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        return this.constructSmtFloatClassificationFunction(iLocation, "fp.isSubnormal", expression, cPrimitive);
    }

    @Override
    public Expression isPositive(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        return this.constructSmtFloatClassificationFunction(iLocation, "fp.isPositive", expression, cPrimitive);
    }

    private Expression delegateBinaryFloatOperationToSmt(ILocation iLocation, Expression expression, Expression expression2, String string, CPrimitive cPrimitive) {
        this.mTranslation.declareFloatingPointFunction(iLocation, string, false, false, cPrimitive, cPrimitive, cPrimitive);
        return this.mTranslation.constructCallToSmtOperation(iLocation, string, cPrimitive, new Expression[]{expression, expression2});
    }

    @Override
    public Expression min(ILocation iLocation, Expression expression, Expression expression2, CPrimitive cPrimitive) {
        return this.delegateBinaryFloatOperationToSmt(iLocation, expression, expression2, "fp.min", cPrimitive);
    }

    @Override
    public Expression max(ILocation iLocation, Expression expression, Expression expression2, CPrimitive cPrimitive) {
        return this.delegateBinaryFloatOperationToSmt(iLocation, expression, expression2, "fp.max", cPrimitive);
    }

    @Override
    public Expression remainder(ILocation iLocation, Expression expression, Expression expression2, CPrimitive cPrimitive) {
        return this.delegateBinaryFloatOperationToSmt(iLocation, expression, expression2, "fp.rem", cPrimitive);
    }

    @Override
    public Expression createNan(ILocation iLocation, CPrimitive cPrimitive) {
        return this.createConstant(iLocation, "NaN", cPrimitive);
    }

    @Override
    public Expression createInfinity(ILocation iLocation, CPrimitive cPrimitive) {
        return this.createConstant(iLocation, "+oo", cPrimitive);
    }

    @Override
    public Expression createMinusInfinity(ILocation iLocation, CPrimitive cPrimitive) {
        return this.createConstant(iLocation, "-oo", cPrimitive);
    }

    @Override
    public Expression createPlusZero(ILocation iLocation, CPrimitive cPrimitive) {
        return this.createConstant(iLocation, "+zero", cPrimitive);
    }

    private Expression createConstant(ILocation iLocation, String string, CPrimitive cPrimitive) {
        this.mTranslation.declareFloatConstant(iLocation, string, cPrimitive);
        return this.mTranslation.constructCallToSmtOperation(iLocation, string, cPrimitive, new Expression[0]);
    }
}

