/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.chctoboogie;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieUtils;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcPreMetaInfoProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornUtilConstants;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.chctoboogie.GenerateBoogieAstHelper;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GenerateGotoBoogieAst {
    private final Unit mResult;
    private final GenerateBoogieAstHelper mHelper;
    private final HcSymbolTable mHcSymbolTable;
    private final ChcPreMetaInfoProvider mChcInfo;
    private final NestedMap2<Integer, Sort, String> mIndexToSortToGotoProcArgId;
    private final List<Triple<Integer, Sort, String>> mIndexToSortToGotoProcArgIdList;
    private final String mGotoVarName;
    private final Set<HcPredicateSymbol> mPredicatesThatHaveANonTailCall;

    public GenerateGotoBoogieAst(ChcPreMetaInfoProvider chcPreMetaInfoProvider, GenerateBoogieAstHelper generateBoogieAstHelper, String string) {
        this.mHelper = generateBoogieAstHelper;
        this.mHcSymbolTable = generateBoogieAstHelper.getSymbolTable();
        this.mChcInfo = chcPreMetaInfoProvider;
        this.mGotoVarName = string;
        this.mPredicatesThatHaveANonTailCall = new HashSet<HcPredicateSymbol>();
        this.mPredicatesThatHaveANonTailCall.add(generateBoogieAstHelper.getBottomPredSym());
        this.mIndexToSortToGotoProcArgId = new NestedMap2();
        this.mIndexToSortToGotoProcArgIdList = new ArrayList<Triple<Integer, Sort, String>>();
        this.constructGotoProcArgIds();
        this.mResult = this.generateBoogieAstWithGotos();
    }

    public Unit getResult() {
        return this.mResult;
    }

    private Unit generateBoogieAstWithGotos() {
        Object object;
        Label label;
        Object object22;
        ILocation iLocation = this.mHelper.getLoc();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Statement> arrayList2 = new ArrayList<Statement>();
        LinkedHashMap<HcPredicateSymbol, Label> linkedHashMap = new LinkedHashMap<HcPredicateSymbol, Label>();
        LinkedHashMap<Label, Integer> linkedHashMap2 = new LinkedHashMap<Label, Integer>();
        int n = 0;
        for (Object object22 : this.mChcInfo.getAllReachablePredSymbols()) {
            label = BoogieUtils.constuctAuxiliaryLabel((ILocation)iLocation, (String)this.mHelper.predSymToMethodName((HcPredicateSymbol)object22));
            object = n;
            ++n;
            linkedHashMap.put((HcPredicateSymbol)object22, label);
            linkedHashMap2.put(label, (Integer)object);
        }
        ArrayDeque<HcPredicateSymbol> arrayDeque = new ArrayDeque<HcPredicateSymbol>();
        object22 = new HashSet();
        arrayDeque.push(this.mHelper.getBottomPredSym());
        object22.add(this.mHelper.getBottomPredSym());
        HashSet hashSet = new HashSet();
        while (!arrayDeque.isEmpty()) {
            label = (HcPredicateSymbol)arrayDeque.pop();
            object = this.mChcInfo.getHornClausesSorted().getImage((Object)label);
            List<Statement> list = this.generateNondetSwitchForPred(iLocation, linkedHashMap, linkedHashMap2, (Set<HornClause>)object, arrayDeque, (Set<HcPredicateSymbol>)object22, hashSet);
            assert (object.isEmpty() || !list.stream().anyMatch(Objects::isNull));
            arrayList2.add((Statement)linkedHashMap.get(label));
            if (object.isEmpty()) {
                arrayList2.add((Statement)new AssumeStatement(iLocation, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false)));
                arrayList2.add((Statement)new ReturnStatement(iLocation));
                continue;
            }
            arrayList2.addAll(list);
        }
        arrayList.add(this.constructGotoProc(iLocation, arrayList2, linkedHashMap, linkedHashMap2, hashSet));
        arrayList.add(this.constructMainEntryPointProcedure(iLocation, (Integer)linkedHashMap2.get(linkedHashMap.get(this.mHelper.getBottomPredSym()))));
        arrayList.addAll(this.mHelper.getAuxDeclarations());
        return new Unit(iLocation, arrayList.toArray(new Declaration[arrayList.size()]));
    }

    private Procedure constructGotoProc(ILocation iLocation, List<Statement> list, Map<HcPredicateSymbol, Label> map, Map<Label, Integer> map2, Set<HcVar> set) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        VariableDeclaration variableDeclaration = null;
        for (Map.Entry<HcPredicateSymbol, Label> object2 : map.entrySet()) {
            if (!this.mPredicatesThatHaveANonTailCall.contains(object2.getKey())) continue;
            HcPredicateSymbol hcPredicateSymbol2 = object2.getKey();
            Label label = object2.getValue();
            Integer n = map2.get(label);
            ArrayList<Statement> arrayList2 = new ArrayList<Statement>();
            Expression expression = new ArrayList();
            ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
            for (HcHeadVar hcHeadVar : this.mHcSymbolTable.getHcHeadVarsForPredSym(hcPredicateSymbol2, false)) {
                expression.add(this.constructLhsForHeadVar(hcHeadVar));
                arrayList3.add(this.getArgumentVarExp(hcHeadVar.getIndex(), hcHeadVar.getSort()));
            }
            if (expression.size() > 0) {
                HcHeadVar hcHeadVar;
                hcHeadVar = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])expression.toArray(new LeftHandSide[expression.size()]), (Expression[])arrayList3.toArray(new Expression[arrayList3.size()]));
                arrayList2.add((Statement)hcHeadVar);
            }
            arrayList2.add((Statement)new GotoStatement(iLocation, new String[]{object2.getValue().getName()}));
            expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)this.getGotoVarExp(), (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)n.toString()));
            variableDeclaration = this.mHelper.addIteBranch(iLocation, (List<Statement>)variableDeclaration, (List<Statement>)arrayList2, expression);
        }
        AssignmentStatement assignmentStatement = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)BoogieType.TYPE_INT, (String)this.getGotoVarName(), (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.getGotoProcName()))}, (Expression[])new Expression[]{ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)BoogieType.TYPE_INT, (String)this.getGotoVarInParamName(), (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, this.getGotoProcName()))});
        arrayList.add(assignmentStatement);
        arrayList.addAll((Collection<Object>)variableDeclaration);
        arrayList.addAll(list);
        ArrayList<VarList> arrayList4 = new ArrayList<VarList>();
        arrayList4.add(new VarList(iLocation, new String[]{this.getGotoVarName()}, (ASTType)new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_INT, "int")));
        ArrayList arrayList42 = new ArrayList();
        map.keySet().forEach(hcPredicateSymbol -> this.mHcSymbolTable.getHcHeadVarsForPredSym(hcPredicateSymbol, false).forEach(hcHeadVar -> {
            boolean bl = arrayList42.add(new VarList(iLocation, new String[]{hcHeadVar.getGloballyUniqueId()}, this.mHelper.getCorrespondingAstType(iLocation, hcHeadVar.getSort())));
        }));
        arrayList4.addAll(arrayList42);
        set.forEach(hcVar -> {
            boolean bl = arrayList4.add(new VarList(iLocation, new String[]{hcVar.getGloballyUniqueId()}, this.mHelper.getCorrespondingAstType(iLocation, hcVar.getSort())));
        });
        variableDeclaration = new VariableDeclaration(iLocation, new Attribute[0], arrayList4.toArray(new VarList[arrayList4.size()]));
        Procedure procedure = new Procedure(iLocation, new Attribute[0], this.getGotoProcName(), new String[0], this.generateGotoProcInParams(), new VarList[0], new Specification[0], new Body(iLocation, new VariableDeclaration[]{variableDeclaration}, arrayList.toArray(new Statement[arrayList.size()])));
        return procedure;
    }

    private VarList[] generateGotoProcInParams() {
        ILocation iLocation = this.mHelper.getLoc();
        ArrayList<VarList> arrayList = new ArrayList<VarList>();
        arrayList.add(new VarList(iLocation, new String[]{this.getGotoVarInParamName()}, (ASTType)new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_INT, "int")));
        for (Triple<Integer, Sort, String> triple : this.mIndexToSortToGotoProcArgIdList) {
            arrayList.add(new VarList(iLocation, new String[]{(String)triple.getThird()}, this.mHelper.getCorrespondingAstType(iLocation, (Sort)triple.getSecond())));
        }
        return arrayList.toArray(new VarList[arrayList.size()]);
    }

    private String getGotoVarInParamName() {
        return this.getGotoVarName() + "_in";
    }

    private Expression getGotoVarExp() {
        return ExpressionFactory.constructIdentifierExpression((ILocation)this.mHelper.getLoc(), (BoogieType)BoogieType.TYPE_INT, (String)this.getGotoVarName(), (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.getGotoProcName()));
    }

    private VariableLHS constructLhsForHeadVar(HcHeadVar hcHeadVar) {
        return ExpressionFactory.constructVariableLHS((ILocation)this.mHelper.getLoc(), (BoogieType)this.mHelper.getType(hcHeadVar.getSort()), (String)hcHeadVar.getGloballyUniqueId(), (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.getGotoProcName()));
    }

    private List<Statement> generateNondetSwitchForPred(ILocation iLocation, Map<HcPredicateSymbol, Label> map, Map<Label, Integer> map2, Set<HornClause> set, Deque<HcPredicateSymbol> deque, Set<HcPredicateSymbol> set2, Set<HcVar> set3) {
        assert (map == null == (map2 == null));
        List<Statement> list = null;
        for (HornClause hornClause : set) {
            if (SmtUtils.isFalseLiteral((Term)hornClause.getConstraintFormula())) continue;
            set3.addAll(hornClause.getBodyVariables());
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            AssumeStatement assumeStatement = new AssumeStatement(iLocation, this.mHelper.translate(hornClause.getConstraintFormula()));
            arrayList.add((Statement)assumeStatement);
            int n = 0;
            while (n < hornClause.getNoBodyPredicates()) {
                HcPredicateSymbol hcPredicateSymbol = (HcPredicateSymbol)hornClause.getBodyPredicates().get(n);
                List list2 = (List)hornClause.getBodyPredToArgs().get(n);
                if (!set2.contains(hcPredicateSymbol)) {
                    deque.push(hcPredicateSymbol);
                    set2.add(hcPredicateSymbol);
                }
                IntegerLiteral integerLiteral = ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)map2.get(map.get(hcPredicateSymbol)).toString());
                List<Expression> list3 = list2.stream().map(term -> this.mHelper.translate((Term)term)).collect(Collectors.toList());
                if (n == hornClause.getNoBodyPredicates() - 1) {
                    this.constructGotoReplacingTailCall(iLocation, arrayList, map.get(hcPredicateSymbol), hornClause, hcPredicateSymbol, integerLiteral, list3);
                } else {
                    this.mPredicatesThatHaveANonTailCall.add(hcPredicateSymbol);
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    arrayList2.add(integerLiteral);
                    int n2 = 0;
                    for (Triple<Integer, Sort, String> triple : this.mIndexToSortToGotoProcArgIdList) {
                        if (n2 < list2.size() && ((Term)list2.get(n2)).getSort().equals(triple.getSecond())) {
                            arrayList2.add(list3.get(n2));
                            ++n2;
                            continue;
                        }
                        arrayList2.add(this.getDummyArgForSort((Sort)triple.getSecond()));
                    }
                    CallStatement callStatement2 = new CallStatement(iLocation, false, new VariableLHS[0], this.getGotoProcName(), arrayList2.toArray(new Expression[list2.size()]));
                    arrayList.add((Statement)callStatement2);
                }
                ++n;
            }
            if (hornClause.getNoBodyPredicates() == 0) {
                arrayList.add((Statement)new ReturnStatement(iLocation));
            }
            list = this.mHelper.addIteBranch(iLocation, list, arrayList, ExpressionFactory.constructBooleanWildCardExpression((ILocation)iLocation));
        }
        return list;
    }

    private Expression getDummyArgForSort(Sort sort) {
        if ("Bool".equals(sort.getName())) {
            return ExpressionFactory.createBooleanLiteral((ILocation)this.mHelper.getLoc(), (boolean)false);
        }
        if ("Int".equals(sort.getName())) {
            return ExpressionFactory.createIntegerLiteral((ILocation)this.mHelper.getLoc(), (String)"0");
        }
        if ("Real".equals(sort.getName())) {
            return ExpressionFactory.createRealLiteral((ILocation)this.mHelper.getLoc(), (String)"0");
        }
        return this.mHelper.getDummyArgForArraySort(sort);
    }

    private Declaration constructMainEntryPointProcedure(ILocation iLocation, Integer n) {
        Statement[] statementArray = new ArrayList();
        statementArray.add(ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)n.toString()));
        for (Triple<Integer, Sort, String> callStatement2 : this.mIndexToSortToGotoProcArgIdList) {
            statementArray.add(this.getDummyArgForSort((Sort)callStatement2.getSecond()));
        }
        Expression[] expressionArray = statementArray.toArray(new Expression[statementArray.size()]);
        CallStatement callStatement = new CallStatement(iLocation, false, new VariableLHS[0], this.getGotoProcName(), expressionArray);
        AssertStatement assertStatement = new AssertStatement(iLocation, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false));
        Check check = new Check(Spec.CHC_SATISFIABILITY);
        check.annotate((IElement)assertStatement);
        statementArray = new Statement[]{callStatement, assertStatement};
        Body body = new Body(iLocation, new VariableDeclaration[0], statementArray);
        return new Procedure(iLocation, new Attribute[0], this.mHelper.getNameOfMainEntryPointProc(), new String[0], new VarList[0], new VarList[0], new Specification[0], body);
    }

    private void constructGotoProcArgIds() {
        for (HcHeadVar hcHeadVar : this.mChcInfo.getAllHeadHcVarsAsList()) {
            boolean bl = this.constructArgumentVarId(hcHeadVar.getIndex(), hcHeadVar.getSort());
            if (!bl) continue;
            this.mIndexToSortToGotoProcArgIdList.add((Triple<Integer, Sort, String>)new Triple((Object)hcHeadVar.getIndex(), (Object)hcHeadVar.getSort(), (Object)this.getArgumentVarId(hcHeadVar.getIndex(), hcHeadVar.getSort())));
        }
    }

    Expression getArgumentVarExp(int n, Sort sort) {
        return ExpressionFactory.constructIdentifierExpression((ILocation)this.mHelper.getLoc(), (BoogieType)this.mHelper.getType(sort), (String)this.getArgumentVarId(n, sort), (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, this.getGotoProcName()));
    }

    private boolean constructArgumentVarId(int n, Sort sort) {
        Object object = (String)this.mIndexToSortToGotoProcArgId.get((Object)n, (Object)sort);
        if (object == null) {
            object = "gpav_" + n + "_" + HornUtilConstants.sanitzeSortNameForBoogie((Sort)sort);
            this.mIndexToSortToGotoProcArgId.put((Object)n, (Object)sort, object);
            return true;
        }
        return false;
    }

    private String getArgumentVarId(int n, Sort sort) {
        String string = (String)this.mIndexToSortToGotoProcArgId.get((Object)n, (Object)sort);
        assert (string != null);
        return string;
    }

    VariableLHS getArgumentVarLhs(int n, Sort sort) {
        return ExpressionFactory.constructVariableLHS((ILocation)this.mHelper.getLoc(), (BoogieType)this.mHelper.getType(sort), (String)this.getArgumentVarId(n, sort), (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.getGotoProcName()));
    }

    public String getGotoProcName() {
        return "gotoProc";
    }

    private VariableLHS getGotoVarLhs() {
        return ExpressionFactory.constructVariableLHS((ILocation)this.mHelper.getLoc(), (BoogieType)BoogieType.TYPE_INT, (String)this.mGotoVarName, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.getGotoProcName()));
    }

    private String getGotoVarName() {
        return this.mGotoVarName;
    }

    private void constructGotoReplacingTailCall(ILocation iLocation, List<Statement> list, Label label, HornClause hornClause, HcPredicateSymbol hcPredicateSymbol, IntegerLiteral integerLiteral, List<Expression> list2) {
        if (list2.size() > 0) {
            AssignmentStatement assignmentStatement = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])this.mHelper.toVariableLhss(this.mHcSymbolTable.getHcHeadVarsForPredSym(hcPredicateSymbol, false), new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.getGotoProcName())), (Expression[])list2.toArray(new Expression[list2.size()]));
            list.add((Statement)assignmentStatement);
        }
        if (hornClause.getBodyVariables().size() > 0) {
            list.add((Statement)new HavocStatement(iLocation, this.mHelper.toVariableLhss(hornClause.getBodyVariables(), new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.getGotoProcName()))));
        }
        list.add((Statement)new GotoStatement(iLocation, new String[]{label.getName().toString()}));
    }
}

