/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class FunctionApplication
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(FunctionApplication.class);
    String identifier;
    Expression[] arguments;

    public FunctionApplication(String string, Expression[] expressionArray) {
        this.identifier = string;
        this.arguments = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid FunctionApplication: " + String.valueOf(this);
    }

    public FunctionApplication(ACSLType aCSLType, String string, Expression[] expressionArray) {
        super(aCSLType);
        this.identifier = string;
        this.arguments = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid FunctionApplication: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FunctionApplication").append('[');
        stringBuffer.append(this.identifier);
        stringBuffer.append(',');
        if (this.arguments == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.arguments.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.arguments[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.arguments != null) {
            list.addAll(Arrays.asList(this.arguments));
        }
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.arguments != null) {
                Expression[] expressionArray = this.arguments;
                int n = this.arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression expression = expressionArray[n2];
                    expression.accept(aCSLVisitor);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        ACSLNode aCSLNode;
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        boolean bl = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.arguments != null) {
            Expression[] expressionArray = this.arguments;
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                aCSLNode = expressionArray[n2];
                Expression expression2 = ((Expression)aCSLNode).accept(aCSLTransformer);
                bl = bl || expression2 != aCSLNode;
                arrayList.add(expression2);
                ++n2;
            }
        }
        aCSLNode = null;
        if (this.type != null) {
            aCSLNode = this.type.accept(aCSLTransformer);
        }
        if (bl || this.type != aCSLNode) {
            return new FunctionApplication((ACSLType)aCSLNode, this.identifier, arrayList.toArray(new Expression[0]));
        }
        return this;
    }
}

