/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateBisimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateXsimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.InteractiveMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedTransitivityGeneratorPair;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IPartition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

public class MinimizeNwaPmaxSatDirect<LETTER, STATE>
extends MinimizeNwaMaxSat2<LETTER, STATE, Pair<STATE, STATE>> {
    private static final PreprocessingMode PREPROCESSING_STANDALONE = PreprocessingMode.PAIRS;
    private static final boolean USE_FULL_PREPROCESSING = false;
    private static final Pair[] EMPTY_LITERALS = new Pair[0];
    private STATE mEmptyStackState;
    private final int mNumberOfInitialPairs;

    public MinimizeNwaPmaxSatDirect(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, MinimizeNwaPmaxSatDirect.createAtsInitialPairs(automataLibraryServices, iDoubleDeckerAutomaton), new MinimizeNwaMaxSat2.Settings().setLibraryMode(false));
    }

    public MinimizeNwaPmaxSatDirect(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, Iterable<Pair<STATE, STATE>> iterable, MinimizeNwaMaxSat2.Settings<STATE> settings) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, MinimizeNwaPmaxSatDirect.createNestedMapWithInitialPairs(iterable), settings);
    }

    public MinimizeNwaPmaxSatDirect(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, NestedMap2<STATE, STATE, Pair<STATE, STATE>> nestedMap2, MinimizeNwaMaxSat2.Settings<STATE> settings) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, settings.setSolverModeGeneral(), MinimizeNwaPmaxSatDirect.removeReflexivePairs(nestedMap2), null);
        this.mEmptyStackState = this.mOperand.getEmptyStackState();
        int n = 0;
        Iterator iterator = nestedMap2.entrySet().iterator();
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        this.mNumberOfInitialPairs = n;
        this.printStartMessage();
        this.run();
        this.printExitMessage();
    }

    @Override
    public void addStatistics(AutomataOperationStatistics automataOperationStatistics) {
        super.addStatistics(automataOperationStatistics);
        automataOperationStatistics.addKeyValuePair(this.mSettings.getLibraryMode() ? StatisticsType.NUMBER_INITIAL_PAIRS_PMAXSAT : StatisticsType.NUMBER_INITIAL_PAIRS, this.mNumberOfInitialPairs);
    }

    private static <LETTER, STATE> Iterable<Pair<STATE, STATE>> createAtsInitialPairs(AutomataLibraryServices automataLibraryServices, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) throws AutomataOperationCanceledException {
        switch (PREPROCESSING_STANDALONE) {
            case PARTITION: {
                return MinimizeNwaPmaxSatDirect.createPairsWithInitialPartition(((PartitionBackedSetOfPairs)new NwaApproximateBisimulation<LETTER, STATE>(automataLibraryServices, iDoubleDeckerAutomaton, NwaApproximateXsimulation.SimulationType.DIRECT, false).getResult()).getRelation());
            }
            case PAIRS: {
                return new NwaApproximateSimulation<LETTER, STATE>(automataLibraryServices, iDoubleDeckerAutomaton, NwaApproximateXsimulation.SimulationType.DIRECT, false).getResult();
            }
            case NONE: {
                return MinimizeNwaPmaxSatDirect.createPairs(iDoubleDeckerAutomaton.getStates());
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + String.valueOf((Object)PREPROCESSING_STANDALONE));
    }

    private static <STATE> NestedMap2<STATE, STATE, Pair<STATE, STATE>> createNestedMapWithInitialPairs(Iterable<Pair<STATE, STATE>> iterable) {
        NestedMap2 nestedMap2 = new NestedMap2();
        for (Pair<STATE, STATE> pair : iterable) {
            if (pair.getFirst().equals(pair.getSecond())) continue;
            nestedMap2.put(pair.getFirst(), pair.getSecond(), pair);
        }
        return nestedMap2;
    }

    private static <STATE> NestedMap2<STATE, STATE, Pair<STATE, STATE>> removeReflexivePairs(NestedMap2<STATE, STATE, Pair<STATE, STATE>> nestedMap2) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Triple triple : nestedMap2.entrySet()) {
            if (!triple.getFirst().equals(triple.getSecond())) continue;
            arrayList.add(new Pair(triple.getFirst(), triple.getSecond()));
        }
        for (Pair pair : arrayList) {
            nestedMap2.remove(pair.getFirst(), pair.getSecond());
        }
        return nestedMap2;
    }

    private static <STATE> Iterable<Pair<STATE, STATE>> createPairsWithInitialPartition(Collection<Set<STATE>> collection) {
        ArrayList<Pair<STATE, STATE>> arrayList = new ArrayList<Pair<STATE, STATE>>();
        for (Set<STATE> set : collection) {
            ArrayList<STATE> arrayList2 = new ArrayList<STATE>(set);
            int n = 0;
            while (n < arrayList2.size()) {
                STATE STATE = arrayList2.get(n);
                int n2 = n + 1;
                while (n2 < arrayList2.size()) {
                    STATE STATE2 = arrayList2.get(n2);
                    arrayList.add(new Pair(STATE, STATE2));
                    arrayList.add(new Pair(STATE2, STATE));
                    ++n2;
                }
                ++n;
            }
        }
        return arrayList;
    }

    @Override
    protected AbstractMaxSatSolver<Pair<STATE, STATE>> createTransitivitySolver() {
        this.mTransitivityGenerator = new ScopedTransitivityGeneratorPair(this.mSettings.isUsePathCompression());
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.mTransitivityGenerator);
        return new InteractiveMaxSatSolver<Pair<STATE, STATE>>(this.mServices, arrayList);
    }

    @Override
    protected void generateVariablesAndAcceptingConstraints() throws AutomataOperationCanceledException {
        BiPredicate biPredicate = this.mSettings.getFinalNonfinalConstraintPredicate();
        for (Triple triple : this.mStatePair2Var.entrySet()) {
            this.checkTimeout("generating variables");
            Pair pair = (Pair)triple.getThird();
            Object object = triple.getFirst();
            Object object2 = triple.getSecond();
            this.addStateToTransitivityGeneratorIfNotPresent(object);
            this.addStateToTransitivityGeneratorIfNotPresent(object2);
            this.mSolver.addVariable(pair);
            if (!this.mOperand.isFinal(object) || this.mOperand.isFinal(object2) || !biPredicate.test(object, object2)) continue;
            this.setStatesDifferent(pair);
        }
    }

    private void addStateToTransitivityGeneratorIfNotPresent(STATE STATE) {
        if (this.mTransitivityGenerator != null) {
            this.mTransitivityGenerator.addContentIfNotPresent(STATE);
        }
    }

    @Override
    protected void generateTransitionAndTransitivityConstraints(boolean bl) throws AutomataOperationCanceledException {
        for (Object object : this.mStatePair2Var.entrySet()) {
            this.checkTimeout("adding transition constraints");
            Pair pair = (Pair)object.getThird();
            this.generateTransitionConstraintsHelper(object.getFirst(), object.getSecond(), pair);
            if (!bl) continue;
            this.generateTransitivityConstraints(pair);
        }
        for (Object object : this.mOperand.getStates()) {
            this.checkTimeout("adding transition constraints");
            this.generateTransitionConstraintsHelperReturnSameLinPred(object, this.getDownStatesArray(object));
        }
    }

    @Override
    protected boolean testOutgoingSymbols(Set<LETTER> set, Set<LETTER> set2) {
        return set2.containsAll(set);
    }

    @Override
    protected void generateTransitionConstraintGeneralInternalCallHelper(Pair<STATE, STATE> pair, Set<STATE> set, Set<STATE> set2) {
        this.generateTransitionConstraintGeneralInternalCallHelperOneSide(pair, set, set2, null);
    }

    @Override
    protected void generateTransitionConstraintGeneralReturnHelper(Pair<STATE, STATE> pair, Pair<STATE, STATE> pair2, Set<STATE> set, Set<STATE> set2) {
        this.generateTransitionConstraintGeneralReturnHelperOneSide(pair, pair2, set, set2, null);
    }

    private void generateTransitivityConstraints(Pair<STATE, STATE> pair) {
        Map map = this.mStatePair2Var.get(pair.getSecond());
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Pair pair2 = (Pair)entry.getValue();
            Pair pair3 = (Pair)this.mStatePair2Var.get(pair.getFirst(), k);
            if (pair3 == null) continue;
            this.addTransitivityClausesToSolver(pair, pair2, pair3);
        }
    }

    @Override
    protected IPartition<STATE> constructResultEquivalenceClasses() throws AssertionError {
        HashMap<Object, HashSet<Object>> hashMap = new HashMap<Object, HashSet<Object>>();
        UnionFind unionFind = new UnionFind();
        for (Object object : this.mOperand.getStates()) {
            unionFind.makeEquivalenceClass(object);
        }
        for (Map.Entry entry : this.mSolver.getValues().entrySet()) {
            Set<Object> set;
            if (entry.getValue() == null) {
                throw new AssertionError((Object)("value not determined " + String.valueOf(entry.getKey())));
            }
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            Object object = ((Pair)entry.getKey()).getFirst();
            Object object2 = ((Pair)entry.getKey()).getSecond();
            Set set2 = (Set)hashMap.get(object2);
            if (set2 != null && set2.remove(object)) {
                set = unionFind.findAndConstructEquivalenceClassIfNeeded(object);
                Object object3 = unionFind.findAndConstructEquivalenceClassIfNeeded(object2);
                unionFind.union((Object)set, object3);
                continue;
            }
            if (!this.isInitialPair(object2, object)) continue;
            set = (Set)hashMap.get(object);
            if (set == null) {
                set = new HashSet<Object>();
                hashMap.put(object, (HashSet<Object>)set);
            }
            set.add(object2);
        }
        return unionFind;
    }

    @Override
    protected String createTaskDescription() {
        return "minimizing NWA with " + this.mOperand.size() + " states";
    }

    protected Pair<STATE, STATE>[] getEmptyVariableArray() {
        return EMPTY_LITERALS;
    }

    private static <STATE> Iterable<Pair<STATE, STATE>> createPairs(Set<STATE> set) {
        ArrayList<Pair<STATE, STATE>> arrayList = new ArrayList<Pair<STATE, STATE>>(set.size() * set.size());
        for (STATE STATE : set) {
            for (STATE STATE2 : set) {
                arrayList.add(new Pair(STATE, STATE2));
            }
        }
        return arrayList;
    }

    @Override
    protected boolean isInitialPair(STATE STATE, STATE STATE2) {
        if (STATE.equals(this.mEmptyStackState) || STATE2.equals(this.mEmptyStackState)) {
            return false;
        }
        Map map = this.mStatePair2Var.get(STATE);
        if (map == null) {
            return false;
        }
        return map.containsKey(STATE2);
    }

    @Override
    protected boolean isInitialPair(Pair<STATE, STATE> pair) {
        return this.isInitialPair(pair.getFirst(), pair.getSecond());
    }

    public static enum PreprocessingMode {
        PARTITION,
        PAIRS,
        NONE;

    }
}

