/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParallelComposition
extends CodeBlock
implements IIcfgInternalTransition<IcfgLocation> {
    private static final long serialVersionUID = -221110423926589618L;
    private final List<CodeBlock> mCodeBlocks;
    private String mPrettyPrinted;
    private final Map<TermVariable, CodeBlock> mBranchIndicator2CodeBlock = new HashMap<TermVariable, CodeBlock>();
    private final IUltimateServiceProvider mServices;

    ParallelComposition(int n, BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, List<CodeBlock> list) {
        super(n, boogieIcfgLocation, boogieIcfgLocation2, iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID));
        this.mServices = iUltimateServiceProvider;
        Script script = managedScript.getScript();
        this.mCodeBlocks = list;
        this.mPrettyPrinted = null;
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = new UnmodifiableTransFormula[list.size()];
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray2 = new UnmodifiableTransFormula[list.size()];
        TermVariable[] termVariableArray = new TermVariable[list.size()];
        int n2 = 0;
        while (n2 < list.size()) {
            TermVariable termVariable;
            CodeBlock codeBlock = list.get(n2);
            if (!(codeBlock instanceof StatementSequence || codeBlock instanceof SequentialComposition || codeBlock instanceof ParallelComposition || codeBlock instanceof GotoEdge)) {
                throw new IllegalArgumentException("Only StatementSequence, SequentialComposition, ParallelComposition, and GotoEdge supported, but got " + ((Object)((Object)codeBlock)).getClass().getSimpleName());
            }
            if (codeBlock.getNumberOfOpenCalls() != 0) {
                throw new IllegalArgumentException("No open calls allowed");
            }
            codeBlock.disconnectSource();
            codeBlock.disconnectTarget();
            unmodifiableTransFormulaArray[n2] = codeBlock.getTransformula();
            unmodifiableTransFormulaArray2[n2] = codeBlock.getTransitionFormulaWithBranchEncoders();
            assert (TransFormulaUtils.hasInternalNormalForm((TransFormula)unmodifiableTransFormulaArray[n2])) : "Cannot parallely compose: not in internal normal form";
            assert (TransFormulaUtils.hasInternalNormalForm((TransFormula)unmodifiableTransFormulaArray2[n2])) : "Cannot parallely compose: not in internal normal form";
            String string = "LBE" + codeBlock.getSerialNumber();
            Sort sort = SmtSortUtils.getBoolSort((Script)script);
            termVariableArray[n2] = termVariable = script.variable(string, sort);
            this.mBranchIndicator2CodeBlock.put(termVariableArray[n2], codeBlock);
            ModelUtils.copyAnnotations((IElement)codeBlock, (IElement)this);
            ++n2;
        }
        n2 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Convert code blocks to CNF") ? 1 : 0;
        this.mTransitionFormula = TransFormulaUtils.parallelComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)managedScript, null, n2 != 0, (boolean)true, (UnmodifiableTransFormula[])unmodifiableTransFormulaArray);
        this.mTransitionFormulaWithBranchEncoders = TransFormulaUtils.parallelComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)managedScript, (TermVariable[])termVariableArray, n2 != 0, (boolean)true, (UnmodifiableTransFormula[])unmodifiableTransFormulaArray2);
        assert (TransFormulaUtils.hasInternalNormalForm((TransFormula)this.mTransitionFormula)) : "Expected TF in internal normal form";
        assert (TransFormulaUtils.hasInternalNormalForm((TransFormula)this.mTransitionFormulaWithBranchEncoders)) : "Expected TF in internal normal form";
    }

    @Override
    public String getPrettyPrintedStatements() {
        if (this.mPrettyPrinted == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("BeginParallelComposition{");
            int n = 0;
            while (n < this.mCodeBlocks.size()) {
                stringBuilder.append("ParallelCodeBlock" + n + ": ");
                stringBuilder.append((Object)this.mCodeBlocks.get(n));
                ++n;
            }
            stringBuilder.append("}EndParallelComposition");
            this.mPrettyPrinted = stringBuilder.toString();
        }
        return this.mPrettyPrinted;
    }

    public Map<TermVariable, CodeBlock> getBranchIndicator2CodeBlock() {
        return this.mBranchIndicator2CodeBlock;
    }

    @Override
    public void setTransitionFormula(UnmodifiableTransFormula unmodifiableTransFormula) {
        throw new UnsupportedOperationException("transition formula is computed in constructor");
    }

    @Override
    public String toString() {
        return this.getPrettyPrintedStatements();
    }

    @Visualizable
    public List<CodeBlock> getCodeBlocks() {
        return Collections.unmodifiableList(this.mCodeBlocks);
    }
}

