/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.cdt.decorator.ASTDecorator;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.MainTranslator;
import de.uni_freiburg.informatik.ultimate.core.lib.models.WrapperNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.ACSLObjectContainerObserver;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.GraphMLCorrectnessWitnessExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedCorrectnessWitness;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.YamlCorrectnessWitnessExtractor;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessGraphAnnotation;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class CACSL2BoogieTranslatorObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final ACSLObjectContainerObserver mAdditionalAnnotationObserver;
    private final GraphMLCorrectnessWitnessExtractor mGraphMLWitnessExtractor;
    private final YamlCorrectnessWitnessExtractor mYamlWitnessExtractor;
    private WrapperNode mRootNode;
    private ASTDecorator mInputDecorator;
    private boolean mLastModel;
    private IExtractedCorrectnessWitness mWitness;

    public CACSL2BoogieTranslatorObserver(IUltimateServiceProvider iUltimateServiceProvider, ACSLObjectContainerObserver aCSLObjectContainerObserver) {
        assert (iUltimateServiceProvider != null);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mGraphMLWitnessExtractor = new GraphMLCorrectnessWitnessExtractor(this.mServices);
        this.mYamlWitnessExtractor = new YamlCorrectnessWitnessExtractor(this.mServices);
        this.mAdditionalAnnotationObserver = aCSLObjectContainerObserver;
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof WitnessNode) {
            this.extractWitnessInformation((WitnessNode)iElement);
            return false;
        }
        if (iElement instanceof Witness) {
            this.extractWitnessInformation((Witness)iElement);
            return false;
        }
        if (iElement instanceof WrapperNode && ((WrapperNode)iElement).getBacking() instanceof ASTDecorator) {
            this.mInputDecorator = (ASTDecorator)((WrapperNode)iElement).getBacking();
            if (this.mInputDecorator.countUnits() == 1) {
                IASTTranslationUnit iASTTranslationUnit = this.mInputDecorator.getUnit(0).getSourceTranslationUnit();
                this.mGraphMLWitnessExtractor.setAST(iASTTranslationUnit);
                this.mYamlWitnessExtractor.setAST(iASTTranslationUnit);
            } else {
                this.mLogger.info("Witness extractor is disabled for %d files", new Object[]{this.mInputDecorator.countUnits()});
            }
            return false;
        }
        if (iElement instanceof Unit) {
            throw new UnsupportedOperationException("Your input file is a Boogie program. This plugin takes as input a C program.");
        }
        return false;
    }

    private void extractWitnessInformation(Witness witness) {
        if (witness.isCorrectnessWitness()) {
            this.mYamlWitnessExtractor.setWitness(witness);
        }
    }

    private void extractWitnessInformation(WitnessNode witnessNode) {
        WitnessGraphAnnotation witnessGraphAnnotation = WitnessGraphAnnotation.getAnnotation((IElement)witnessNode);
        switch (witnessGraphAnnotation.getWitnessType()) {
            case VIOLATION_WITNESS: {
                break;
            }
            case CORRECTNESS_WITNESS: {
                this.mGraphMLWitnessExtractor.setWitness(witnessNode);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown witness type " + String.valueOf(witnessGraphAnnotation.getWitnessType()));
            }
        }
    }

    public void finish() {
        if (this.mGraphMLWitnessExtractor.isReady()) {
            this.mWitness = this.mGraphMLWitnessExtractor.getWitness();
        }
        if (this.mYamlWitnessExtractor.isReady()) {
            this.mWitness = this.mYamlWitnessExtractor.getWitness();
        }
        if (this.mLastModel) {
            if (this.mInputDecorator == null) {
                throw new IllegalArgumentException("There is no C AST present. Did you parse a C file?");
            }
            this.mRootNode = new MainTranslator(this.mServices, this.mLogger, this.mWitness, this.mInputDecorator.getUnits(), this.mInputDecorator.getSymbolTable(), this.mAdditionalAnnotationObserver.getAnnotation()).getResult();
        }
    }

    public void init(ModelType modelType, int n, int n2) {
        if (n == n2 - 1) {
            this.mLastModel = true;
        }
    }

    public boolean performedChanges() {
        return false;
    }

    public IElement getRoot() {
        return this.mRootNode;
    }
}

