/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.scripts;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;

public class LinearArithmeticChecker
extends NoopScript {
    FormulaUnLet mUnletter = new FormulaUnLet();
    LinearChecker mChecker = new LinearChecker();
    long mNumProblems = 0L;
    String mEchoString = "";

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mChecker.transform(this.mUnletter.transform(term));
        return super.assertTerm(term);
    }

    public QuotedObject echo(QuotedObject quotedObject) {
        this.mEchoString = quotedObject.getValue();
        return super.echo(quotedObject);
    }

    public void reset() {
        if (this.mNumProblems > 0L) {
            System.err.println("Found " + this.mNumProblems + " problems.");
            System.out.println(this.mEchoString);
            this.mNumProblems = 0L;
        }
        super.reset();
    }

    public void exit() {
        if (this.mNumProblems > 0L) {
            System.err.println("Found " + this.mNumProblems + " problems.");
            System.exit(1);
        }
        super.exit();
    }

    class LinearChecker
    extends TermTransformer {
        LinearChecker() {
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            block17: {
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                if (!functionSymbol.isIntern()) break block17;
                switch (functionSymbol.getName()) {
                    case "abs": 
                    case "div": 
                    case "mod": {
                        System.err.println("Non-linear function " + functionSymbol.getName() + " in benchmark");
                        ++LinearArithmeticChecker.this.mNumProblems;
                        break;
                    }
                    case "*": {
                        Term term = SMTAffineTerm.parseConstant(termArray[0]);
                        Term term2 = SMTAffineTerm.parseConstant(termArray[1]);
                        if (termArray.length == 2 && (term instanceof ConstantTerm || term2 instanceof ConstantTerm)) break;
                        System.err.println("Non-linear term " + String.valueOf(applicationTerm));
                        ++LinearArithmeticChecker.this.mNumProblems;
                        break;
                    }
                    case "/": {
                        Term term = SMTAffineTerm.parseConstant((Term)applicationTerm);
                        if (term instanceof ConstantTerm) break;
                        System.err.println("Non-constant division: " + String.valueOf(applicationTerm));
                        ++LinearArithmeticChecker.this.mNumProblems;
                        break;
                    }
                }
            }
            super.convertApplicationTerm(applicationTerm, termArray);
        }
    }
}

