/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ParameterPartition;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfScout;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class QuantifierPushUtilsForSubsetPush {
    public static Term sequentialSubsetPush(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask eliminationTask, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator) {
        List<Term> list = Arrays.asList(QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm()));
        if (list.size() <= 1) {
            throw new AssertionError((Object)"No dual finite junction");
        }
        if (!QuantifierPushUtils.isFlattened(eliminationTask.getQuantifier(), list)) {
            throw new AssertionError((Object)"Not flattened");
        }
        Object object = new ParameterPartition(managedScript.getScript(), eliminationTask);
        if (!((ParameterPartition)object).isIsPartitionTrivial()) {
            throw new AssertionError((Object)"Is partitionable!");
        }
        object = new ArrayList<TermVariable>(eliminationTask.getEliminatees());
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        List<TermVariable> list2 = QuantifierPushUtilsForSubsetPush.findSuitableEliminatees((List<TermVariable>)object, arrayList, list, eliminationTask.getQuantifier());
        int n = 0;
        int n2 = 0;
        while (!list2.isEmpty()) {
            Term term;
            Object object2;
            QuantifiedFormula quantifiedFormula;
            PartitionByEliminateeOccurrence partitionByEliminateeOccurrence;
            List<TermVariable> list3;
            ILogger iLogger;
            if (n > 20 + eliminationTask.getEliminatees().size()) {
                iLogger = iUltimateServiceProvider.getLoggingService().getLogger(QuantifierPushUtilsForSubsetPush.class);
                iLogger.info((Object)String.format("Initially %s eliminatees, after %s iterations we have %s eliminatees. Is this in finite loop?", eliminationTask.getEliminatees().size(), n, object.size()));
            }
            if (!(list3 = QuantifierPusher.determineMinionEliminatees((Collection<TermVariable>)object, (partitionByEliminateeOccurrence = new PartitionByEliminateeOccurrence(list, (TermVariable)(iLogger = XnfScout.selectBestEliminatee(managedScript.getScript(), eliminationTask.getQuantifier(), list2, list)))).getFiniteDualJunctsWithoutEliminatee())).contains(iLogger)) {
                throw new AssertionError((Object)("Missing minion " + String.valueOf(iLogger)));
            }
            Term term2 = QuantifierPushUtilsForSubsetPush.pushMinionEliminatees(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, eliminationTask, iQuantifierEliminator, list3, partitionByEliminateeOccurrence, (List<TermVariable>)object);
            ++n;
            if (term2 == null) {
                arrayList.add((TermVariable)iLogger);
                list2 = QuantifierPushUtilsForSubsetPush.findSuitableEliminatees((List<TermVariable>)object, arrayList, list, eliminationTask.getQuantifier());
                continue;
            }
            LinkedList linkedList = new LinkedList();
            if (term2 instanceof QuantifiedFormula) {
                quantifiedFormula = (QuantifiedFormula)term2;
                object2 = new HashSet<TermVariable>(list3);
                for (TermVariable termVariable : Arrays.asList(quantifiedFormula.getVariables())) {
                    if (list3.contains(termVariable)) {
                        object2.remove(termVariable);
                        if (termVariable != iLogger) continue;
                        arrayList.add((TermVariable)iLogger);
                        continue;
                    }
                    linkedList.add(termVariable);
                }
                term = quantifiedFormula.getSubformula();
            } else {
                object2 = new HashSet<TermVariable>(list3);
                term = term2;
            }
            if (!object2.isEmpty()) {
                ++n2;
            }
            object.removeAll((Collection<?>)object2);
            object.addAll(linkedList);
            list = new ArrayList<Term>(partitionByEliminateeOccurrence.getFiniteDualJunctsWithoutEliminatee());
            list.add(term);
            term2 = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), eliminationTask.getQuantifier(), list);
            object2 = new EliminationTask(eliminationTask.getQuantifier(), new HashSet<TermVariable>((Collection<TermVariable>)object), term2, eliminationTask.getContext());
            linkedList = QuantifierPushUtils.preprocessDualFiniteJunction(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, (EliminationTask)object2, iQuantifierEliminator, false, true);
            if (!((Boolean)linkedList.getFirst()).booleanValue()) {
                return (Term)linkedList.getSecond();
            }
            quantifiedFormula = (QuantifiedFormula)linkedList.getSecond();
            object = new ArrayList<TermVariable>(Arrays.asList(quantifiedFormula.getVariables()));
            arrayList.retainAll((Collection<?>)object);
            list = Arrays.asList(QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), quantifiedFormula.getSubformula()));
            list2 = QuantifierPushUtilsForSubsetPush.findSuitableEliminatees(object, arrayList, list, eliminationTask.getQuantifier());
        }
        if (n2 == 0) {
            return null;
        }
        return SmtUtils.quantifier(managedScript.getScript(), eliminationTask.getQuantifier(), (Collection<TermVariable>)object, QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), eliminationTask.getQuantifier(), list));
    }

    private static Term pushMinionEliminatees(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, EliminationTask eliminationTask, QuantifierUtils.IQuantifierEliminator iQuantifierEliminator, List<TermVariable> list, PartitionByEliminateeOccurrence partitionByEliminateeOccurrence, List<TermVariable> list2) {
        Term term;
        Term term2 = QuantifierUtils.applyDualFiniteConnective(managedScript.getScript(), eliminationTask.getQuantifier(), partitionByEliminateeOccurrence.getFiniteDualJunctsWithEliminatee());
        Term term3 = SmtUtils.quantifier(managedScript.getScript(), eliminationTask.getQuantifier(), new HashSet<TermVariable>(list), term2);
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>(list2);
        arrayList.removeAll(new HashSet<TermVariable>(list));
        Context context = eliminationTask.getContext();
        Context context2 = context.constructChildContextForQuantifiedFormula(managedScript.getScript(), arrayList);
        context2 = context2.constructChildContextForConDis(iUltimateServiceProvider, managedScript, ((ApplicationTerm)eliminationTask.getTerm()).getFunction(), partitionByEliminateeOccurrence.getFiniteDualJunctsWithoutEliminatee());
        Term term4 = iQuantifierEliminator.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, context2, term3);
        Object object = term4 == term3 ? null : ((term = QuantifierPushUtils.flattenQuantifiedFormulas(managedScript, eliminationTask.getQuantifier(), term4)) == null ? term4 : (term == term3 ? null : term));
        return object;
    }

    private static List<TermVariable> findSuitableEliminatees(List<TermVariable> list, List<TermVariable> list2, List<Term> list3, int n) {
        return list.stream().filter(termVariable -> !list2.contains(termVariable) && list3.stream().anyMatch(term -> !Arrays.asList(term.getFreeVars()).contains(termVariable)) && list3.stream().anyMatch(term -> Arrays.asList(term.getFreeVars()).contains(termVariable) && QuantifierPusher.classify(n, term) == QuantifierPusher.FormulaClassification.CORRESPONDING_FINITE_CONNECTIVE)).collect(Collectors.toList());
    }

    private static class PartitionByEliminateeOccurrence {
        private final List<Term> mFiniteDualJunctsWithEliminatee;
        private final List<Term> mFiniteDualJunctsWithoutEliminatee;

        public PartitionByEliminateeOccurrence(List<Term> list, TermVariable termVariable) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            for (Term term : list) {
                if (Arrays.asList(term.getFreeVars()).contains(termVariable)) {
                    arrayList.add(term);
                    continue;
                }
                arrayList2.add(term);
            }
            if (arrayList.isEmpty()) {
                throw new AssertionError((Object)"Eliminatee must occur in at least one dualfiniteJunct");
            }
            if (arrayList2.isEmpty()) {
                throw new AssertionError((Object)"Eliminatee must not occur all dualfiniteJuncts");
            }
            this.mFiniteDualJunctsWithEliminatee = arrayList;
            this.mFiniteDualJunctsWithoutEliminatee = arrayList2;
        }

        public List<Term> getFiniteDualJunctsWithEliminatee() {
            return this.mFiniteDualJunctsWithEliminatee;
        }

        public List<Term> getFiniteDualJunctsWithoutEliminatee() {
            return this.mFiniteDualJunctsWithoutEliminatee;
        }
    }
}

