/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class FairDirectGameGraph<LETTER, STATE>
extends FairGameGraph<LETTER, STATE> {
    private final Set<SpoilerVertex<LETTER, STATE>> mDirectSimulations;
    private final HashSet<Pair<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>>> mEdgesToBeChangedForTransformation;
    private boolean mIsCurrentlyDirectGameGraph;

    public FairDirectGameGraph(AutomataLibraryServices automataLibraryServices, IMergeStateFactory<STATE> iMergeStateFactory, IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMergeStateFactory, iProgressAwareTimer, iLogger, iNestedWordAutomaton);
        INestedWordAutomaton iNestedWordAutomaton2 = this.getAutomaton();
        this.verifyAutomatonValidity(iNestedWordAutomaton2);
        this.mIsCurrentlyDirectGameGraph = false;
        this.mDirectSimulations = new HashSet<SpoilerVertex<LETTER, STATE>>();
        this.mEdgesToBeChangedForTransformation = new HashSet();
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> generateAutomatonFromGraph() throws AutomataOperationCanceledException {
        if (this.mIsCurrentlyDirectGameGraph) {
            return null;
        }
        return super.generateAutomatonFromGraph();
    }

    @Override
    public void generateGameGraphFromAutomaton() throws AutomataOperationCanceledException {
        super.generateGameGraphFromAutomaton();
        this.calculateTransformationChanges();
    }

    @Override
    public int getGlobalInfinity() {
        if (this.mIsCurrentlyDirectGameGraph) {
            return 1;
        }
        return super.getGlobalInfinity();
    }

    @Override
    public int getPriority(Vertex<LETTER, STATE> vertex) {
        if (this.mIsCurrentlyDirectGameGraph) {
            return 0;
        }
        return vertex.getPriority();
    }

    public boolean isDirectSimulating(SpoilerVertex<LETTER, STATE> spoilerVertex) {
        return this.mDirectSimulations.contains(spoilerVertex) || spoilerVertex.getQ0().equals(spoilerVertex.getQ1());
    }

    private void calculateTransformationChanges() {
        for (Vertex vertex : this.getVertices()) {
            if (vertex.getPriority() != 1) continue;
            if (this.hasSuccessors(vertex)) {
                for (Vertex vertex2 : this.getSuccessors(vertex)) {
                    this.mEdgesToBeChangedForTransformation.add(new Pair(vertex, vertex2));
                }
            }
            if (!this.hasPredecessors(vertex)) continue;
            for (Vertex vertex2 : this.getPredecessors(vertex)) {
                this.mEdgesToBeChangedForTransformation.add(new Pair(vertex2, vertex));
            }
        }
    }

    protected boolean isCurrentlyDirectGameGraph() {
        return this.mIsCurrentlyDirectGameGraph;
    }

    protected void rememberAndClearDirectSimulationResults() {
        SpoilerVertex spoilerVertex2;
        Set set = this.getSpoilerVertices();
        for (SpoilerVertex spoilerVertex2 : set) {
            if (spoilerVertex2.getPM(null, this.getGlobalInfinity()) < this.getGlobalInfinity()) {
                if (spoilerVertex2.getQ0().equals(spoilerVertex2.getQ1())) continue;
                this.mDirectSimulations.add(spoilerVertex2);
            }
            spoilerVertex2.setPM(0);
            spoilerVertex2.setBEff(0);
            spoilerVertex2.setC(0);
        }
        spoilerVertex2 = this.getDuplicatorVertices();
        Iterator iterator = spoilerVertex2.iterator();
        while (iterator.hasNext()) {
            DuplicatorVertex duplicatorVertex = iterator.next();
            duplicatorVertex.setPM(0);
            duplicatorVertex.setBEff(0);
            duplicatorVertex.setC(0);
        }
    }

    protected void transformToDirectGameGraph() {
        if (this.mIsCurrentlyDirectGameGraph) {
            return;
        }
        for (Pair<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>> pair : this.mEdgesToBeChangedForTransformation) {
            this.removeEdge((Vertex)pair.getFirst(), (Vertex)pair.getSecond());
        }
        this.mIsCurrentlyDirectGameGraph = true;
    }

    protected void transformToFairGameGraph() {
        if (!this.mIsCurrentlyDirectGameGraph) {
            return;
        }
        for (Pair<Vertex<LETTER, STATE>, Vertex<LETTER, STATE>> pair : this.mEdgesToBeChangedForTransformation) {
            this.addEdge((Vertex)pair.getFirst(), (Vertex)pair.getSecond());
        }
        this.mIsCurrentlyDirectGameGraph = false;
    }
}

