/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CcAuxData<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final CongruenceClosure<ELEM> mCongruenceClosure;
    private final HashRelation<ELEM, ELEM> mAfCcPars;
    private final HashRelation<ELEM, ELEM> mArgCcPars;
    private final Map<ELEM, HashRelation<ELEM, ELEM>> mCcChildren;
    private final boolean mOmitRepresentativeChecks;

    CcAuxData(CongruenceClosure<ELEM> congruenceClosure) {
        this.mCongruenceClosure = congruenceClosure;
        this.mAfCcPars = new HashRelation();
        this.mArgCcPars = new HashRelation();
        this.mCcChildren = new HashMap<ELEM, HashRelation<ELEM, ELEM>>();
        this.mOmitRepresentativeChecks = false;
    }

    public CcAuxData(CongruenceClosure<ELEM> congruenceClosure, CcAuxData<ELEM> ccAuxData, boolean bl) {
        this.mCongruenceClosure = congruenceClosure;
        this.mAfCcPars = new HashRelation(ccAuxData.mAfCcPars);
        this.mArgCcPars = new HashRelation(ccAuxData.mArgCcPars);
        this.mCcChildren = new HashMap<ELEM, HashRelation<ELEM, ELEM>>();
        for (Map.Entry<ELEM, HashRelation<ELEM, ELEM>> entry : ccAuxData.mCcChildren.entrySet()) {
            this.mCcChildren.put((ICongruenceClosureElement)entry.getKey(), new HashRelation((AbstractRelation)entry.getValue()));
        }
        this.mOmitRepresentativeChecks = bl;
    }

    CcAuxData(CongruenceClosure<ELEM> congruenceClosure, CcAuxData<ELEM> ccAuxData) {
        this(congruenceClosure, ccAuxData, false);
    }

    Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> updateAndGetPropagationsOnMerge(ELEM ELEM, ELEM ELEM2, ELEM ELEM3, ELEM ELEM4, Set<ELEM> set, Set<ELEM> set2) {
        Object object;
        HashRelation<ELEM, ELEM> hashRelation;
        Object object2;
        ICongruenceClosureElement iCongruenceClosureElement = (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(ELEM);
        assert (this.mCongruenceClosure.mElementTVER.getRepresentative(ELEM2) == iCongruenceClosureElement) : "we merged before calling this method, right?";
        HashRelation hashRelation2 = new HashRelation();
        HashRelation hashRelation3 = new HashRelation();
        Set set3 = this.mAfCcPars.getImage(ELEM3);
        Set set4 = this.mAfCcPars.getImage(ELEM4);
        Set set5 = this.mArgCcPars.getImage(ELEM3);
        Set set6 = this.mArgCcPars.getImage(ELEM4);
        this.collectCcParBasedPropagations(set3, set4, hashRelation2, hashRelation3);
        this.collectCcParBasedPropagations(set5, set6, hashRelation2, hashRelation3);
        assert (this.hasOnlyPairsOfSameType(hashRelation2));
        assert (this.hasOnlyPairsOfSameType(hashRelation3));
        this.collectPropagationsForImplicitlyAddedDisequalities(set, ELEM4, hashRelation3);
        this.collectPropagationsForImplicitlyAddedDisequalities(set2, ELEM3, hashRelation3);
        assert (this.hasOnlyPairsOfSameType(hashRelation3));
        if (iCongruenceClosureElement == ELEM3) {
            object2 = this.mAfCcPars.removeDomainElement(ELEM4);
            if (object2 != null) {
                hashRelation = object2.iterator();
                while (hashRelation.hasNext()) {
                    object = (ICongruenceClosureElement)hashRelation.next();
                    assert (object.isFunctionApplication());
                    this.mAfCcPars.addPair(iCongruenceClosureElement, object);
                }
            }
            if ((object = this.mArgCcPars.removeDomainElement(ELEM4)) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    hashRelation = (ICongruenceClosureElement)iterator.next();
                    assert (hashRelation.isFunctionApplication());
                    this.mArgCcPars.addPair(iCongruenceClosureElement, hashRelation);
                }
            }
        } else {
            assert (iCongruenceClosureElement == ELEM4);
            object2 = this.mAfCcPars.removeDomainElement(ELEM3);
            if (object2 != null) {
                hashRelation = object2.iterator();
                while (hashRelation.hasNext()) {
                    object = (ICongruenceClosureElement)hashRelation.next();
                    assert (object.isFunctionApplication());
                    this.mAfCcPars.addPair(iCongruenceClosureElement, object);
                }
            }
            if ((object = this.mArgCcPars.removeDomainElement(ELEM3)) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    hashRelation = (ICongruenceClosureElement)iterator.next();
                    assert (hashRelation.isFunctionApplication());
                    this.mArgCcPars.addPair(iCongruenceClosureElement, hashRelation);
                }
            }
        }
        object2 = new HashRelation();
        object = this.mCcChildren.remove(ELEM3);
        if (object != null) {
            ((AbstractRelation)object2).addAll(object);
        }
        if ((hashRelation = this.mCcChildren.remove(ELEM4)) != null) {
            ((AbstractRelation)object2).addAll(hashRelation);
        }
        this.mCcChildren.put((ELEM)iCongruenceClosureElement, (HashRelation<ELEM, ELEM>)object2);
        assert (this.hasOnlyPairsOfSameType(hashRelation2));
        assert (this.hasOnlyPairsOfSameType(hashRelation3));
        return new Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>>(hashRelation2, hashRelation3);
    }

    private boolean hasOnlyPairsOfSameType(HashRelation<ELEM, ELEM> hashRelation) {
        for (Map.Entry entry : hashRelation) {
            assert (((ICongruenceClosureElement)entry.getKey()).hasSameTypeAs((ICongruenceClosureElement)entry.getValue())) : "relation should only have pairs of same typebut does not";
        }
        return true;
    }

    private void collectCcParBasedPropagations(Set<ELEM> set, Set<ELEM> set2, HashRelation<ELEM, ELEM> hashRelation, HashRelation<ELEM, ELEM> hashRelation2) {
        if (set == null || set2 == null || set.isEmpty() || set2.isEmpty()) {
            return;
        }
        for (List list : CrossProducts.crossProductOfSets(Arrays.asList(set, set2))) {
            ICongruenceClosureElement iCongruenceClosureElement = (ICongruenceClosureElement)list.get(0);
            ICongruenceClosureElement iCongruenceClosureElement2 = (ICongruenceClosureElement)list.get(1);
            if (this.mCongruenceClosure.hasElements(new ICongruenceClosureElement[]{iCongruenceClosureElement.getAppliedFunction(), iCongruenceClosureElement.getArgument(), iCongruenceClosureElement2.getAppliedFunction(), iCongruenceClosureElement2.getArgument()}) && this.mCongruenceClosure.getEqualityStatus(iCongruenceClosureElement.getAppliedFunction(), iCongruenceClosureElement2.getAppliedFunction()) == EqualityStatus.EQUAL && this.mCongruenceClosure.getEqualityStatus(iCongruenceClosureElement.getArgument(), iCongruenceClosureElement2.getArgument()) == EqualityStatus.EQUAL) {
                hashRelation.addPair(iCongruenceClosureElement, iCongruenceClosureElement2);
                continue;
            }
            if (this.mCongruenceClosure.getEqualityStatus(iCongruenceClosureElement, iCongruenceClosureElement2) != EqualityStatus.NOT_EQUAL) continue;
            this.addPropIfOneIsEqualOneIsUnconstrained(iCongruenceClosureElement.getAppliedFunction(), iCongruenceClosureElement.getArgument(), iCongruenceClosureElement2.getAppliedFunction(), iCongruenceClosureElement2.getArgument(), hashRelation2);
        }
    }

    private void collectPropagationsForImplicitlyAddedDisequalities(Set<ELEM> set, ELEM ELEM, HashRelation<ELEM, ELEM> hashRelation) {
        for (ICongruenceClosureElement iCongruenceClosureElement : set) {
            HashRelation<ELEM, ELEM> hashRelation2 = this.mCcChildren.get(iCongruenceClosureElement);
            if (hashRelation2 == null) continue;
            for (Map.Entry entry : hashRelation2) {
                HashRelation<ELEM, ELEM> hashRelation3 = this.mCcChildren.get(ELEM);
                if (hashRelation3 == null) continue;
                for (Map.Entry entry2 : hashRelation3) {
                    this.addPropIfOneIsEqualOneIsUnconstrained((ICongruenceClosureElement)entry2.getKey(), (ICongruenceClosureElement)entry2.getValue(), (ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue(), hashRelation);
                }
            }
        }
    }

    public void removeElement(ELEM ELEM, boolean bl, ELEM ELEM2) {
        if (bl) {
            Object object = this.mAfCcPars.removeDomainElement(ELEM);
            if (ELEM2 != null && object != null) {
                object.forEach(iCongruenceClosureElement2 -> {
                    boolean bl = this.mAfCcPars.addPair(ELEM2, iCongruenceClosureElement2);
                });
            }
            Iterator<Object> iterator = this.mArgCcPars.removeDomainElement(ELEM);
            if (ELEM2 != null && iterator != null) {
                iterator.forEach(iCongruenceClosureElement2 -> {
                    boolean bl = this.mArgCcPars.addPair(ELEM2, iCongruenceClosureElement2);
                });
            }
            HashRelation<ELEM, ELEM> hashRelation = this.mCcChildren.remove(ELEM);
            if (ELEM2 != null && hashRelation != null) {
                this.mCcChildren.put(ELEM2, hashRelation);
            }
        }
        if (ELEM2 != null) {
            for (Object object : new ArrayList(this.mAfCcPars.getImage(ELEM2))) {
                if (!object.getAppliedFunction().equals(ELEM)) continue;
                this.mAfCcPars.removePair(ELEM2, object);
            }
            for (Object object : new ArrayList(this.mArgCcPars.getImage(ELEM2))) {
                if (!object.getArgument().equals(ELEM)) continue;
                this.mArgCcPars.removePair(ELEM2, object);
            }
        }
        this.mAfCcPars.removeRangeElement(ELEM);
        this.mArgCcPars.removeRangeElement(ELEM);
        if (ELEM2 == null) {
            assert (bl);
        } else if (ELEM.isFunctionApplication() && this.mCcChildren.get(ELEM2) != null) {
            this.mCcChildren.get(ELEM2).removePair(ELEM.getAppliedFunction(), ELEM.getArgument());
        }
    }

    HashRelation<ELEM, ELEM> registerNewElement(ELEM ELEM) {
        Object object;
        assert (ELEM.isFunctionApplication()) : "right?..";
        Object ELEM2 = this.mCongruenceClosure.hasElement(ELEM.getAppliedFunction()) ? (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(ELEM.getAppliedFunction()) : ELEM.getAppliedFunction();
        Object ELEM3 = this.mCongruenceClosure.hasElement(ELEM.getArgument()) ? (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(ELEM.getArgument()) : ELEM.getArgument();
        HashRelation<ELEM, ICongruenceClosureElement> hashRelation = new HashRelation<ELEM, ICongruenceClosureElement>();
        if (!this.mCongruenceClosure.isInconsistent()) {
            object = this.mAfCcPars.getImage(ELEM2);
            Set set = object.stream().filter(iCongruenceClosureElement2 -> this.mCongruenceClosure.hasElement((ICongruenceClosureElement)ELEM3) && this.mCongruenceClosure.hasElement(iCongruenceClosureElement2.getArgument()) && this.mCongruenceClosure.getEqualityStatus((ICongruenceClosureElement)ELEM3, (ICongruenceClosureElement)iCongruenceClosureElement2.getArgument()) == EqualityStatus.EQUAL).collect(Collectors.toSet());
            for (ICongruenceClosureElement iCongruenceClosureElement : set) {
                assert (iCongruenceClosureElement.isFunctionApplication());
                hashRelation.addPair(ELEM, iCongruenceClosureElement);
            }
        }
        this.mAfCcPars.addPair(ELEM2, ELEM);
        this.mArgCcPars.addPair(ELEM3, ELEM);
        object = (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(ELEM);
        this.updateCcChild(object, ELEM.getAppliedFunction(), ELEM.getArgument());
        return hashRelation;
    }

    private void updateCcChild(ELEM ELEM, ELEM ELEM2, ELEM ELEM3) {
        HashRelation<Object, Object> hashRelation = this.mCcChildren.get(ELEM);
        if (hashRelation == null) {
            hashRelation = new HashRelation();
            this.mCcChildren.put(ELEM, hashRelation);
        }
        hashRelation.addPair(ELEM2, ELEM3);
    }

    public HashRelation<ELEM, ELEM> getPropagationsOnReportDisequality(ELEM ELEM, ELEM ELEM2) {
        HashRelation hashRelation = new HashRelation();
        ICongruenceClosureElement iCongruenceClosureElement = (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(ELEM);
        ICongruenceClosureElement iCongruenceClosureElement2 = (ICongruenceClosureElement)this.mCongruenceClosure.mElementTVER.getRepresentative(ELEM2);
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> hashRelation2 = this.getCcChildren(iCongruenceClosureElement);
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> hashRelation3 = this.getCcChildren(iCongruenceClosureElement2);
        for (Map.Entry entry : hashRelation2.getSetOfPairs()) {
            for (Map.Entry entry2 : hashRelation3.getSetOfPairs()) {
                this.addPropIfOneIsEqualOneIsUnconstrained((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue(), (ICongruenceClosureElement)entry2.getKey(), (ICongruenceClosureElement)entry2.getValue(), hashRelation);
            }
        }
        return hashRelation;
    }

    public HashRelation<ELEM, ELEM> getCcChildren(ELEM ELEM) {
        assert (this.mOmitRepresentativeChecks || this.mCongruenceClosure.isRepresentative(ELEM));
        HashRelation<Object, Object> hashRelation = this.mCcChildren.get(ELEM);
        if (hashRelation == null) {
            hashRelation = new HashRelation();
            this.mCcChildren.put(ELEM, hashRelation);
        }
        return hashRelation;
    }

    private void addPropIfOneIsEqualOneIsUnconstrained(ELEM ELEM, ELEM ELEM2, ELEM ELEM3, ELEM ELEM4, HashRelation<ELEM, ELEM> hashRelation) {
        if (!(this.mCongruenceClosure.hasElement(ELEM) && this.mCongruenceClosure.hasElement(ELEM3) && this.mCongruenceClosure.hasElement(ELEM2) && this.mCongruenceClosure.hasElement(ELEM4))) {
            return;
        }
        EqualityStatus equalityStatus = this.mCongruenceClosure.getEqualityStatus(ELEM, ELEM3);
        EqualityStatus equalityStatus2 = this.mCongruenceClosure.getEqualityStatus(ELEM2, ELEM4);
        if (equalityStatus == EqualityStatus.EQUAL && equalityStatus2 == EqualityStatus.UNKNOWN && ELEM2.hasSameTypeAs(ELEM4)) {
            hashRelation.addPair(ELEM2, ELEM4);
        }
        if (equalityStatus == EqualityStatus.UNKNOWN && equalityStatus2 == EqualityStatus.EQUAL && ELEM.hasSameTypeAs(ELEM3)) {
            hashRelation.addPair(ELEM, ELEM3);
        }
    }

    public Collection<ELEM> getAfCcPars(ELEM ELEM) {
        assert (this.mOmitRepresentativeChecks || this.mCongruenceClosure.isRepresentative(ELEM));
        return this.mAfCcPars.getImage(ELEM);
    }

    public Collection<ELEM> getArgCcPars(ELEM ELEM) {
        assert (this.mOmitRepresentativeChecks || this.mCongruenceClosure.isRepresentative(ELEM));
        return this.mArgCcPars.getImage(ELEM);
    }

    public void transformElements(Function<ELEM, ELEM> function) {
        this.mAfCcPars.transformElements(function, function);
        this.mArgCcPars.transformElements(function, function);
        for (Map.Entry<ELEM, HashRelation<ELEM, ELEM>> entry : new HashMap<ELEM, HashRelation<ELEM, ELEM>>(this.mCcChildren).entrySet()) {
            this.mCcChildren.remove(entry.getKey());
            assert (entry.getValue().isEmpty() || !this.mCcChildren.containsValue(entry.getValue())) : "just to make sure there's no overlap in the map's image values";
            entry.getValue().transformElements(function, function);
            this.mCcChildren.put((ICongruenceClosureElement)function.apply((ICongruenceClosureElement)entry.getKey()), entry.getValue());
        }
    }
}

