/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.BitVectorInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.math.BigInteger;
import java.util.HashSet;

public class ModelEvaluator
extends TermTransformer {
    private final Model mModel;
    private final ScopedHashMap<TermVariable, Term> mLetMap = new ScopedHashMap(false);

    private static boolean isBooleanValue(Term term) {
        Theory theory = term.getTheory();
        return term == theory.mTrue || term == theory.mFalse;
    }

    public void convert(Term term) {
        while (term instanceof AnnotatedTerm) {
            term = ((AnnotatedTerm)term).getSubterm();
        }
        if (term instanceof ConstantTerm) {
            if (term.getSort().isNumericSort()) {
                Term term2 = SMTAffineTerm.convertConstant((ConstantTerm)term).toTerm(term.getSort());
                this.setResult(term2);
                return;
            }
            if (term.getSort().isBitVecSort()) {
                Object object = ((ConstantTerm)term).getValue();
                if (object instanceof String) {
                    BigInteger bigInteger;
                    String string = (String)object;
                    if (string.startsWith("#b")) {
                        bigInteger = new BigInteger(string.substring(2), 2);
                    } else {
                        assert (string.startsWith("#x"));
                        bigInteger = new BigInteger(string.substring(2), 16);
                    }
                    this.setResult(this.createBitvectorTerm(bigInteger, term.getSort()));
                } else {
                    assert (object instanceof BigInteger);
                    this.setResult(term);
                }
                return;
            }
            throw new InternalError("Don't know how to evaluate this: " + String.valueOf(term));
        }
        if (term instanceof TermVariable) {
            if (this.mLetMap.containsKey((Object)term)) {
                this.setResult((Term)this.mLetMap.get((Object)term));
                return;
            }
            throw new SMTLIBException("Terms to evaluate must be closed");
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (applicationTerm.getFunction().isIntern() && applicationTerm.getFunction().getName() == "ite") {
                this.enqueueWalker(new ITESelector(applicationTerm));
                this.pushTerm(applicationTerm.getParameters()[0]);
                return;
            }
        } else {
            if (term instanceof QuantifiedFormula) {
                throw new SMTLIBException("Quantifiers not supported in model evaluation");
            }
            if (term instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)term;
                this.enqueueWalker(new MatchSelector(matchTerm));
                this.pushTerm(matchTerm.getDataTerm());
                return;
            }
        }
        super.convert(term);
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        if (functionSymbol.isIntern() || functionSymbol.isModelValue()) {
            this.setResult(this.interpret(functionSymbol, termArray));
        } else if (functionSymbol.getDefinition() != null) {
            this.pushTerm(applicationTerm.getTheory().let(functionSymbol.getDefinitionVars(), termArray, functionSymbol.getDefinition()));
        } else {
            this.setResult(this.lookupFunction(functionSymbol, termArray));
        }
    }

    public void preConvertLet(LetTerm letTerm, Term[] termArray) {
        this.mLetMap.beginScope();
        TermVariable[] termVariableArray = letTerm.getVariables();
        int n = 0;
        while (n < termVariableArray.length) {
            this.mLetMap.put((Object)termVariableArray[n], (Object)termArray[n]);
            ++n;
        }
        super.preConvertLet(letTerm, termArray);
    }

    public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
        this.setResult(term);
        this.mLetMap.endScope();
    }

    public ModelEvaluator(Model model) {
        this.mModel = model;
    }

    public Term evaluate(Term term) {
        return this.transform(term);
    }

    private Term lookupFunction(FunctionSymbol functionSymbol, Term[] termArray) {
        FunctionValue functionValue = this.mModel.getFunctionValue(functionSymbol);
        if (functionValue == null) {
            Sort sort = functionSymbol.getReturnSort();
            return this.mModel.getSomeValue(sort);
        }
        Term term = functionValue.values().get(new FunctionValue.Index(termArray));
        return term == null ? functionValue.getDefault() : term;
    }

    private Term interpret(FunctionSymbol functionSymbol, Term[] termArray) {
        if (functionSymbol.isModelValue()) {
            int n = Integer.parseInt(functionSymbol.getName().substring(1));
            return this.mModel.getModelValue(n, functionSymbol.getReturnSort());
        }
        Theory theory = this.mModel.getTheory();
        switch (functionSymbol.getName()) {
            case "true": {
                return theory.mTrue;
            }
            case "false": {
                return theory.mFalse;
            }
            case "and": {
                Term[] termArray2 = termArray;
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray2[n2];
                    if (term == theory.mFalse) {
                        return term;
                    }
                    assert (term == theory.mTrue);
                    ++n2;
                }
                return theory.mTrue;
            }
            case "or": {
                Term[] termArray3 = termArray;
                int n = termArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Term term = termArray3[n3];
                    assert (ModelEvaluator.isBooleanValue(term));
                    if (term == theory.mTrue) {
                        return term;
                    }
                    assert (term == theory.mFalse);
                    ++n3;
                }
                return theory.mFalse;
            }
            case "=>": {
                int n = 0;
                while (n < termArray.length - 1) {
                    Term term = termArray[n];
                    assert (ModelEvaluator.isBooleanValue(term));
                    if (term == theory.mFalse) {
                        return theory.mTrue;
                    }
                    assert (term == theory.mTrue);
                    ++n;
                }
                return termArray[termArray.length - 1];
            }
            case "not": {
                assert (ModelEvaluator.isBooleanValue(termArray[0]));
                return termArray[0] == theory.mTrue ? theory.mFalse : theory.mTrue;
            }
            case "xor": {
                boolean bl = false;
                Term[] termArray4 = termArray;
                int n = termArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Term term = termArray4[n4];
                    assert (ModelEvaluator.isBooleanValue(term));
                    bl ^= term == theory.mTrue;
                    ++n4;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "=": {
                int n = 1;
                while (n < termArray.length) {
                    if (termArray[n] != termArray[0]) {
                        return theory.mFalse;
                    }
                    ++n;
                }
                return theory.mTrue;
            }
            case "distinct": {
                HashSet<Term> hashSet = new HashSet<Term>();
                Term[] termArray5 = termArray;
                int n = termArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Term term = termArray5[n5];
                    if (!hashSet.add(term)) {
                        return theory.mFalse;
                    }
                    ++n5;
                }
                return theory.mTrue;
            }
            case "ite": {
                return termArray[0] == theory.mTrue ? termArray[1] : termArray[2];
            }
            case "+": {
                Rational rational = this.rationalValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    rational = rational.add(this.rationalValue(termArray[n]));
                    ++n;
                }
                return rational.toTerm(functionSymbol.getReturnSort());
            }
            case "-": {
                Rational rational = this.rationalValue(termArray[0]);
                if (termArray.length == 1) {
                    rational = rational.negate();
                } else {
                    int n = 1;
                    while (n < termArray.length) {
                        rational = rational.sub(this.rationalValue(termArray[n]));
                        ++n;
                    }
                }
                return rational.toTerm(functionSymbol.getReturnSort());
            }
            case "*": {
                Rational rational = this.rationalValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    rational = rational.mul(this.rationalValue(termArray[n]));
                    ++n;
                }
                return rational.toTerm(functionSymbol.getReturnSort());
            }
            case "/": {
                Rational rational = this.rationalValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    Rational rational2 = this.rationalValue(termArray[n]);
                    rational = rational2.equals((Object)Rational.ZERO) ? this.rationalValue(this.lookupFunction(functionSymbol, new Term[]{rational.toTerm(termArray[0].getSort()), termArray[n]})) : rational.div(rational2);
                    ++n;
                }
                return rational.toTerm(functionSymbol.getReturnSort());
            }
            case "<=": {
                int n = 1;
                while (n < termArray.length) {
                    Rational rational;
                    Rational rational3 = this.rationalValue(termArray[n - 1]);
                    if (rational3.compareTo(rational = this.rationalValue(termArray[n])) > 0) {
                        return theory.mFalse;
                    }
                    ++n;
                }
                return theory.mTrue;
            }
            case "<": {
                int n = 1;
                while (n < termArray.length) {
                    Rational rational;
                    Rational rational4 = this.rationalValue(termArray[n - 1]);
                    if (rational4.compareTo(rational = this.rationalValue(termArray[n])) >= 0) {
                        return theory.mFalse;
                    }
                    ++n;
                }
                return theory.mTrue;
            }
            case ">=": {
                int n = 1;
                while (n < termArray.length) {
                    Rational rational;
                    Rational rational5 = this.rationalValue(termArray[n - 1]);
                    if (rational5.compareTo(rational = this.rationalValue(termArray[n])) < 0) {
                        return theory.mFalse;
                    }
                    ++n;
                }
                return theory.mTrue;
            }
            case ">": {
                int n = 1;
                while (n < termArray.length) {
                    Rational rational;
                    Rational rational6 = this.rationalValue(termArray[n - 1]);
                    if (rational6.compareTo(rational = this.rationalValue(termArray[n])) <= 0) {
                        return theory.mFalse;
                    }
                    ++n;
                }
                return theory.mTrue;
            }
            case "div": {
                Rational rational = this.rationalValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    Rational rational7 = this.rationalValue(termArray[n]);
                    if (rational7.equals((Object)Rational.ZERO)) {
                        rational = this.rationalValue(this.lookupFunction(functionSymbol, new Term[]{rational.toTerm(termArray[0].getSort()), termArray[n]}));
                    } else {
                        Rational rational8 = rational.div(rational7);
                        rational = rational7.isNegative() ? rational8.ceil() : rational8.floor();
                    }
                    ++n;
                }
                return rational.toTerm(functionSymbol.getReturnSort());
            }
            case "mod": {
                assert (termArray.length == 2);
                Rational rational = this.rationalValue(termArray[1]);
                if (rational.equals((Object)Rational.ZERO)) {
                    return this.lookupFunction(functionSymbol, termArray);
                }
                Rational rational9 = this.rationalValue(termArray[0]);
                Rational rational10 = rational9.div(rational);
                rational10 = rational.isNegative() ? rational10.ceil() : rational10.floor();
                return rational9.sub(rational10.mul(rational)).toTerm(functionSymbol.getReturnSort());
            }
            case "abs": {
                assert (termArray.length == 1);
                Rational rational = this.rationalValue(termArray[0]);
                return rational.abs().toTerm(functionSymbol.getReturnSort());
            }
            case "divisible": {
                BigInteger bigInteger;
                assert (termArray.length == 1);
                Rational rational = this.rationalValue(termArray[0]);
                String[] stringArray = functionSymbol.getIndices();
                assert (stringArray.length == 1);
                try {
                    bigInteger = new BigInteger(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SMTLIBException("index of divisible must be numeral", (Throwable)numberFormatException);
                }
                Rational rational11 = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
                return rational.div(rational11).isIntegral() ? theory.mTrue : theory.mFalse;
            }
            case "to_int": {
                assert (termArray.length == 1);
                Rational rational = this.rationalValue(termArray[0]);
                return rational.floor().toTerm(functionSymbol.getReturnSort());
            }
            case "to_real": {
                assert (termArray.length == 1);
                Rational rational = this.rationalValue(termArray[0]);
                return rational.toTerm(functionSymbol.getReturnSort());
            }
            case "is_int": {
                assert (termArray.length == 1);
                Rational rational = this.rationalValue(termArray[0]);
                return rational.isIntegral() ? theory.mTrue : theory.mFalse;
            }
            case "store": {
                ArraySortInterpretation arraySortInterpretation = (ArraySortInterpretation)this.mModel.provideSortInterpretation(functionSymbol.getParameterSorts()[0]);
                return arraySortInterpretation.normalizeStoreTerm(theory.term(functionSymbol, termArray));
            }
            case "const": {
                return theory.term(functionSymbol, new Term[]{termArray[0]});
            }
            case "select": {
                ApplicationTerm applicationTerm = (ApplicationTerm)termArray[0];
                Term term = termArray[1];
                FunctionSymbol functionSymbol2 = applicationTerm.getFunction();
                while (functionSymbol2.getName() == "store") {
                    if (applicationTerm.getParameters()[1] == term) {
                        return applicationTerm.getParameters()[2];
                    }
                    applicationTerm = (ApplicationTerm)applicationTerm.getParameters()[0];
                    functionSymbol2 = applicationTerm.getFunction();
                }
                assert (functionSymbol2.getName() == "const");
                return applicationTerm.getParameters()[0];
            }
            case "@diff": {
                ArraySortInterpretation arraySortInterpretation = (ArraySortInterpretation)this.mModel.provideSortInterpretation(functionSymbol.getParameterSorts()[0]);
                return arraySortInterpretation.computeDiff(termArray[0], termArray[1], functionSymbol.getReturnSort());
            }
            case "nat2bv": {
                assert (termArray.length == 1);
                Rational rational = this.rationalValue(termArray[0]);
                assert (rational.isIntegral());
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort()).subtract(BigInteger.ONE);
                return this.createBitvectorTerm(rational.numerator().and(bigInteger), functionSymbol.getReturnSort());
            }
            case "bv2nat": {
                assert (termArray.length == 1);
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                return Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE).toTerm(functionSymbol.getReturnSort());
            }
            case "bvadd": {
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort()).subtract(BigInteger.ONE);
                BigInteger bigInteger2 = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    bigInteger2 = bigInteger2.add(this.bitvectorValue(termArray[n]));
                    ++n;
                }
                bigInteger2 = bigInteger2.and(bigInteger);
                return this.createBitvectorTerm(bigInteger2, functionSymbol.getReturnSort());
            }
            case "bvsub": {
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort()).subtract(BigInteger.ONE);
                BigInteger bigInteger3 = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    bigInteger3 = bigInteger3.add(this.bitvectorValue(termArray[n]).negate());
                    ++n;
                }
                bigInteger3 = bigInteger3.and(bigInteger);
                return this.createBitvectorTerm(bigInteger3, functionSymbol.getReturnSort());
            }
            case "bvmul": {
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort()).subtract(BigInteger.ONE);
                BigInteger bigInteger4 = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    bigInteger4 = bigInteger4.multiply(this.bitvectorValue(termArray[n]));
                    bigInteger4 = bigInteger4.and(bigInteger);
                    ++n;
                }
                return this.createBitvectorTerm(bigInteger4, functionSymbol.getReturnSort());
            }
            case "bvudiv": {
                assert (termArray.length == 2);
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger5 = this.bitvectorValue(termArray[0]);
                BigInteger bigInteger6 = this.bitvectorValue(termArray[1]);
                bigInteger5 = bigInteger6.signum() == 0 ? bigInteger.subtract(BigInteger.ONE) : bigInteger5.divide(bigInteger6);
                return this.createBitvectorTerm(bigInteger5, functionSymbol.getReturnSort());
            }
            case "bvurem": {
                assert (termArray.length == 2);
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                BigInteger bigInteger7 = this.bitvectorValue(termArray[1]);
                bigInteger = bigInteger7.signum() == 0 ? bigInteger : bigInteger.mod(bigInteger7);
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "bvsdiv": {
                BigInteger bigInteger;
                assert (termArray.length == 2);
                int n = this.getBitVecSize(functionSymbol.getReturnSort()) - 1;
                BigInteger bigInteger8 = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger9 = this.bitvectorValue(termArray[0]);
                boolean bl = bigInteger9.testBit(n);
                if (bl) {
                    bigInteger9 = bigInteger8.subtract(bigInteger9);
                }
                if ((bigInteger = this.bitvectorValue(termArray[1])).testBit(n)) {
                    bigInteger = bigInteger8.subtract(bigInteger);
                    bl = !bl;
                }
                BigInteger bigInteger10 = bigInteger9 = bigInteger.signum() == 0 ? bigInteger8.subtract(BigInteger.ONE) : bigInteger9.divide(bigInteger);
                if (bl && bigInteger9.signum() != 0) {
                    bigInteger9 = bigInteger8.subtract(bigInteger9);
                }
                return this.createBitvectorTerm(bigInteger9, functionSymbol.getReturnSort());
            }
            case "bvsrem": {
                BigInteger bigInteger;
                assert (termArray.length == 2);
                int n = this.getBitVecSize(functionSymbol.getReturnSort()) - 1;
                BigInteger bigInteger11 = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger12 = this.bitvectorValue(termArray[0]);
                boolean bl = bigInteger12.testBit(n);
                if (bl) {
                    bigInteger12 = bigInteger11.subtract(bigInteger12);
                }
                if ((bigInteger = this.bitvectorValue(termArray[1])).testBit(n)) {
                    bigInteger = bigInteger11.subtract(bigInteger);
                }
                BigInteger bigInteger13 = bigInteger12 = bigInteger.signum() == 0 ? bigInteger12 : bigInteger12.mod(bigInteger);
                if (bl && bigInteger12.signum() != 0) {
                    bigInteger12 = bigInteger11.subtract(bigInteger12);
                }
                return this.createBitvectorTerm(bigInteger12, functionSymbol.getReturnSort());
            }
            case "bvsmod": {
                BigInteger bigInteger;
                boolean bl;
                assert (termArray.length == 2);
                int n = this.getBitVecSize(functionSymbol.getReturnSort()) - 1;
                BigInteger bigInteger14 = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger15 = this.bitvectorValue(termArray[0]);
                BigInteger bigInteger16 = bigInteger15;
                if (bigInteger16.testBit(n)) {
                    bigInteger16 = bigInteger16.subtract(bigInteger14);
                }
                if (bl = (bigInteger = this.bitvectorValue(termArray[1])).testBit(n)) {
                    bigInteger = bigInteger14.subtract(bigInteger);
                }
                BigInteger bigInteger17 = bigInteger16 = bigInteger.signum() == 0 ? bigInteger15 : bigInteger16.mod(bigInteger);
                if (bl && bigInteger16.signum() != 0) {
                    bigInteger16 = bigInteger16.add(bigInteger14).subtract(bigInteger);
                }
                return this.createBitvectorTerm(bigInteger16, functionSymbol.getReturnSort());
            }
            case "bvnot": {
                assert (termArray.length == 1);
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger18 = this.bitvectorValue(termArray[0]).xor(bigInteger.subtract(BigInteger.ONE));
                return this.createBitvectorTerm(bigInteger18, functionSymbol.getReturnSort());
            }
            case "bvneg": {
                assert (termArray.length == 1);
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger19 = this.bitvectorValue(termArray[0]);
                if (bigInteger19.signum() != 0) {
                    bigInteger19 = bigInteger.subtract(bigInteger19);
                }
                return this.createBitvectorTerm(bigInteger19, functionSymbol.getReturnSort());
            }
            case "bvand": {
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger20 = this.bitvectorValue(termArray[n]);
                    bigInteger = bigInteger.and(bigInteger20);
                    ++n;
                }
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "bvor": {
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger21 = this.bitvectorValue(termArray[n]);
                    bigInteger = bigInteger.or(bigInteger21);
                    ++n;
                }
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "bvxor": {
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger22 = this.bitvectorValue(termArray[n]);
                    bigInteger = bigInteger.xor(bigInteger22);
                    ++n;
                }
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "bvnand": {
                assert (termArray.length == 2);
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger23 = bigInteger.subtract(BigInteger.ONE).subtract(this.bitvectorValue(termArray[0]).and(this.bitvectorValue(termArray[1])));
                return this.createBitvectorTerm(bigInteger23, functionSymbol.getReturnSort());
            }
            case "bvnor": {
                assert (termArray.length == 2);
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger24 = bigInteger.subtract(BigInteger.ONE).subtract(this.bitvectorValue(termArray[0]).or(this.bitvectorValue(termArray[1])));
                return this.createBitvectorTerm(bigInteger24, functionSymbol.getReturnSort());
            }
            case "bvxnor": {
                assert (termArray.length == 2);
                BigInteger bigInteger = this.getBVModulo(functionSymbol.getReturnSort());
                BigInteger bigInteger25 = bigInteger.subtract(BigInteger.ONE).subtract(this.bitvectorValue(termArray[0]).xor(this.bitvectorValue(termArray[1])));
                return this.createBitvectorTerm(bigInteger25, functionSymbol.getReturnSort());
            }
            case "bvcomp": {
                assert (termArray.length == 2);
                BigInteger bigInteger = this.bitvectorValue(termArray[0]).equals(this.bitvectorValue(termArray[1])) ? BigInteger.ONE : BigInteger.ZERO;
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "bvule": {
                assert (termArray.length >= 2);
                boolean bl = true;
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger26 = this.bitvectorValue(termArray[n]);
                    bl &= bigInteger.compareTo(bigInteger26) <= 0;
                    bigInteger = bigInteger26;
                    ++n;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "bvult": {
                assert (termArray.length >= 2);
                boolean bl = true;
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger27 = this.bitvectorValue(termArray[n]);
                    bl &= bigInteger.compareTo(bigInteger27) < 0;
                    bigInteger = bigInteger27;
                    ++n;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "bvuge": {
                assert (termArray.length >= 2);
                boolean bl = true;
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger28 = this.bitvectorValue(termArray[n]);
                    bl &= bigInteger.compareTo(bigInteger28) >= 0;
                    bigInteger = bigInteger28;
                    ++n;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "bvugt": {
                assert (termArray.length >= 2);
                boolean bl = true;
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger29 = this.bitvectorValue(termArray[n]);
                    bl &= bigInteger.compareTo(bigInteger29) > 0;
                    bigInteger = bigInteger29;
                    ++n;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "bvsle": {
                assert (termArray.length >= 2);
                boolean bl = true;
                BigInteger bigInteger = BigInteger.ONE.shiftLeft(this.getBitVecSize(termArray[0].getSort()) - 1);
                BigInteger bigInteger30 = this.bitvectorValue(termArray[0]).xor(bigInteger);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger31 = this.bitvectorValue(termArray[n]).xor(bigInteger);
                    bl &= bigInteger30.compareTo(bigInteger31) <= 0;
                    bigInteger30 = bigInteger31;
                    ++n;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "bvslt": {
                assert (termArray.length >= 2);
                boolean bl = true;
                BigInteger bigInteger = BigInteger.ONE.shiftLeft(this.getBitVecSize(termArray[0].getSort()) - 1);
                BigInteger bigInteger32 = this.bitvectorValue(termArray[0]).xor(bigInteger);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger33 = this.bitvectorValue(termArray[n]).xor(bigInteger);
                    bl &= bigInteger32.compareTo(bigInteger33) < 0;
                    bigInteger32 = bigInteger33;
                    ++n;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "bvsge": {
                assert (termArray.length >= 2);
                boolean bl = true;
                BigInteger bigInteger = BigInteger.ONE.shiftLeft(this.getBitVecSize(termArray[0].getSort()) - 1);
                BigInteger bigInteger34 = this.bitvectorValue(termArray[0]).xor(bigInteger);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger35 = this.bitvectorValue(termArray[n]).xor(bigInteger);
                    bl &= bigInteger34.compareTo(bigInteger35) >= 0;
                    bigInteger34 = bigInteger35;
                    ++n;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "bvsgt": {
                assert (termArray.length >= 2);
                boolean bl = true;
                BigInteger bigInteger = BigInteger.ONE.shiftLeft(this.getBitVecSize(termArray[0].getSort()) - 1);
                BigInteger bigInteger36 = this.bitvectorValue(termArray[0]).xor(bigInteger);
                int n = 1;
                while (n < termArray.length) {
                    BigInteger bigInteger37 = this.bitvectorValue(termArray[n]).xor(bigInteger);
                    bl &= bigInteger36.compareTo(bigInteger37) > 0;
                    bigInteger36 = bigInteger37;
                    ++n;
                }
                return bl ? theory.mTrue : theory.mFalse;
            }
            case "bvshl": {
                BigInteger bigInteger;
                int n = this.getBitVecSize(functionSymbol.getReturnSort());
                assert (termArray.length == 2);
                BigInteger bigInteger38 = this.bitvectorValue(termArray[1]);
                if (bigInteger38.compareTo(BigInteger.valueOf(n)) < 0) {
                    BigInteger bigInteger39 = BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
                    bigInteger = this.bitvectorValue(termArray[0]).shiftLeft(bigInteger38.intValueExact()).and(bigInteger39);
                } else {
                    bigInteger = BigInteger.ZERO;
                }
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "bvlshr": {
                int n = this.getBitVecSize(functionSymbol.getReturnSort());
                assert (termArray.length == 2);
                BigInteger bigInteger = this.bitvectorValue(termArray[1]);
                BigInteger bigInteger40 = bigInteger.compareTo(BigInteger.valueOf(n)) < 0 ? this.bitvectorValue(termArray[0]).shiftRight(bigInteger.intValueExact()) : BigInteger.ZERO;
                return this.createBitvectorTerm(bigInteger40, functionSymbol.getReturnSort());
            }
            case "bvashr": {
                int n = this.getBitVecSize(functionSymbol.getReturnSort());
                assert (termArray.length == 2);
                BigInteger bigInteger = this.bitvectorValue(termArray[1]);
                BigInteger bigInteger41 = this.bitvectorValue(termArray[0]);
                if (bigInteger.compareTo(BigInteger.valueOf(n)) < 0) {
                    int n6 = bigInteger.intValueExact();
                    BigInteger bigInteger42 = bigInteger41.testBit(n - 1) ? BigInteger.ONE.shiftLeft(n - n6).subtract(BigInteger.ONE).shiftLeft(n6) : BigInteger.ZERO;
                    bigInteger41 = bigInteger41.shiftRight(n6).or(bigInteger42);
                } else {
                    bigInteger41 = bigInteger41.testBit(n - 1) ? BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE) : BigInteger.ZERO;
                }
                return this.createBitvectorTerm(bigInteger41, functionSymbol.getReturnSort());
            }
            case "concat": {
                assert (termArray.length == 2);
                int n = this.getBitVecSize(termArray[1].getSort());
                BigInteger bigInteger = this.bitvectorValue(termArray[0]).shiftLeft(n).or(this.bitvectorValue(termArray[1]));
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "repeat": {
                assert (termArray.length == 1);
                int n = this.getBitVecSize(termArray[0].getSort());
                int n7 = Integer.parseInt(functionSymbol.getIndices()[0]);
                BigInteger bigInteger = BigInteger.ONE.shiftLeft(n * n7).subtract(BigInteger.ONE).divide(BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE));
                BigInteger bigInteger43 = this.bitvectorValue(termArray[0]).multiply(bigInteger);
                return this.createBitvectorTerm(bigInteger43, functionSymbol.getReturnSort());
            }
            case "extract": {
                assert (termArray.length == 1);
                int n = Integer.parseInt(functionSymbol.getIndices()[0]);
                int n8 = Integer.parseInt(functionSymbol.getIndices()[1]);
                BigInteger bigInteger = this.bitvectorValue(termArray[0]).shiftRight(n8).and(BigInteger.ONE.shiftLeft(n - n8 + 1).subtract(BigInteger.ONE));
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "zero_extend": {
                return this.createBitvectorTerm(this.bitvectorValue(termArray[0]), functionSymbol.getReturnSort());
            }
            case "sign_extend": {
                assert (termArray.length == 1);
                int n = this.getBitVecSize(termArray[0].getSort());
                BigInteger bigInteger = this.bitvectorValue(termArray[0]);
                if (bigInteger.testBit(n - 1)) {
                    int n9 = this.getBitVecSize(functionSymbol.getReturnSort());
                    bigInteger = bigInteger.add(BigInteger.ONE.shiftLeft(n9).subtract(BigInteger.ONE.shiftLeft(n)));
                }
                return this.createBitvectorTerm(bigInteger, functionSymbol.getReturnSort());
            }
            case "rotate_left": 
            case "rotate_right": {
                assert (termArray.length == 1);
                int n = this.getBitVecSize(functionSymbol.getReturnSort());
                int n10 = Integer.parseInt(functionSymbol.getIndices()[0]);
                if (functionSymbol.getName().equals("rotate_right")) {
                    n10 = n - n10;
                }
                BigInteger bigInteger = BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
                BigInteger bigInteger44 = this.bitvectorValue(termArray[0]);
                bigInteger44 = bigInteger44.shiftLeft(n10).or(bigInteger44.shiftRight(n - n10)).and(bigInteger);
                return this.createBitvectorTerm(bigInteger44, functionSymbol.getReturnSort());
            }
            case "@EQ": {
                return this.lookupFunction(functionSymbol, termArray);
            }
        }
        if (functionSymbol.isConstructor()) {
            return theory.term(functionSymbol, termArray);
        }
        if (functionSymbol.isSelector()) {
            ApplicationTerm applicationTerm = (ApplicationTerm)termArray[0];
            DataType dataType = (DataType)applicationTerm.getSort().getSortSymbol();
            assert (applicationTerm.getFunction().isConstructor());
            DataType.Constructor constructor = dataType.getConstructor(applicationTerm.getFunction().getName());
            String[] stringArray = constructor.getSelectors();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(functionSymbol.getName())) {
                    return applicationTerm.getParameters()[n];
                }
                ++n;
            }
            return this.lookupFunction(functionSymbol, termArray);
        }
        if (functionSymbol.getName().equals("is")) {
            ApplicationTerm applicationTerm = (ApplicationTerm)termArray[0];
            assert (applicationTerm.getFunction().isConstructor());
            return applicationTerm.getFunction().getName().equals(functionSymbol.getIndices()[0]) ? theory.mTrue : theory.mFalse;
        }
        throw new AssertionError((Object)("Unknown internal function " + functionSymbol.getName()));
    }

    private Rational rationalValue(Term term) {
        return (Rational)((ConstantTerm)term).getValue();
    }

    private BigInteger bitvectorValue(Term term) {
        return (BigInteger)((ConstantTerm)term).getValue();
    }

    private Term createBitvectorTerm(BigInteger bigInteger, Sort sort) {
        return BitVectorInterpretation.BV(bigInteger, sort);
    }

    private int getBitVecSize(Sort sort) {
        assert (sort.isBitVecSort());
        return Integer.parseInt(sort.getIndices()[0]);
    }

    private BigInteger getBVModulo(Sort sort) {
        return BigInteger.ONE.shiftLeft(this.getBitVecSize(sort));
    }

    private static class ITESelector
    implements NonRecursive.Walker {
        private final ApplicationTerm mIte;

        public ITESelector(ApplicationTerm applicationTerm) {
            this.mIte = applicationTerm;
        }

        public void walk(NonRecursive nonRecursive) {
            ModelEvaluator modelEvaluator = (ModelEvaluator)nonRecursive;
            ApplicationTerm applicationTerm = (ApplicationTerm)modelEvaluator.getConverted();
            assert (ModelEvaluator.isBooleanValue((Term)applicationTerm)) : "condition must be 'true' or 'false'";
            modelEvaluator.pushTerm(this.mIte.getParameters()[applicationTerm.getFunction().getName() == "true" ? 1 : 2]);
        }
    }

    private static class MatchSelector
    implements NonRecursive.Walker {
        private final MatchTerm mMatch;

        public MatchSelector(MatchTerm matchTerm) {
            this.mMatch = matchTerm;
        }

        public void walk(NonRecursive nonRecursive) {
            Theory theory = this.mMatch.getTheory();
            ModelEvaluator modelEvaluator = (ModelEvaluator)nonRecursive;
            ApplicationTerm applicationTerm = (ApplicationTerm)modelEvaluator.getConverted();
            int n = 0;
            while (n < this.mMatch.getConstructors().length) {
                DataType.Constructor constructor = this.mMatch.getConstructors()[n];
                if (constructor == null) {
                    modelEvaluator.pushTerm(theory.let(this.mMatch.getVariables()[n][0], (Term)applicationTerm, this.mMatch.getCases()[n]));
                    return;
                }
                if (applicationTerm.getFunction().getName() == constructor.getName()) {
                    modelEvaluator.pushTerm(theory.let(this.mMatch.getVariables()[n], applicationTerm.getParameters(), this.mMatch.getCases()[n]));
                    return;
                }
                ++n;
            }
            throw new InternalError("Match term not total or data term not evaluated");
        }
    }
}

