/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransFormulaUnification {
    private final ManagedScript mMgdScript;
    private final UnmodifiableTransFormula[] mTransFormulas;
    private final Term[] mUnifiedFormulas;
    private final Map<IProgramVar, TermVariable> mInVars = new HashMap<IProgramVar, TermVariable>();
    private final Map<IProgramVar, TermVariable> mOutVars = new HashMap<IProgramVar, TermVariable>();
    private final Set<IProgramVar> mAssignedVars = new HashSet<IProgramVar>();
    private final List<Map<TermVariable, TermVariable>> mSubstitutions = new ArrayList<Map<TermVariable, TermVariable>>();
    private final Set<TermVariable> mAuxVars = new HashSet<TermVariable>();
    private final Set<IProgramConst> mNonTheoryConsts = new HashSet<IProgramConst>();

    public TransFormulaUnification(ManagedScript managedScript, UnmodifiableTransFormula ... unmodifiableTransFormulaArray) {
        this.mMgdScript = managedScript;
        this.mTransFormulas = unmodifiableTransFormulaArray;
        this.mUnifiedFormulas = new Term[unmodifiableTransFormulaArray.length];
        this.computeJointInOutVars();
        this.collectNonTheoryConsts();
        this.computeSubstitutions();
        this.computeUnifiedFormulas();
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public Set<TermVariable> getAuxVars() {
        return this.mAuxVars;
    }

    public Set<IProgramConst> getNonTheoryConsts() {
        return this.mNonTheoryConsts;
    }

    public Term getUnifiedFormula(int n) {
        return this.mUnifiedFormulas[n];
    }

    public Term getUnifiedFormula(UnmodifiableTransFormula unmodifiableTransFormula) {
        return this.getUnifiedFormula(Arrays.asList(this.mTransFormulas).indexOf(unmodifiableTransFormula));
    }

    private void computeJointInOutVars() {
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = this.mTransFormulas;
        int n = this.mTransFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            UnmodifiableTransFormula serializable = unmodifiableTransFormulaArray[n2];
            for (IProgramVar iProgramVar : serializable.getInVars().keySet()) {
                if (this.mInVars.containsKey(iProgramVar)) continue;
                this.addFreshTermVariable(this.mInVars, iProgramVar, "In");
            }
            for (Map.Entry entry : serializable.getOutVars().entrySet()) {
                IProgramVar iProgramVar = (IProgramVar)entry.getKey();
                if (!this.mInVars.containsKey(iProgramVar) && !this.assignedInAll(iProgramVar)) {
                    this.addFreshTermVariable(this.mInVars, iProgramVar, "In");
                }
                this.mOutVars.put(iProgramVar, this.mInVars.get(iProgramVar));
            }
            this.mAssignedVars.addAll(serializable.getAssignedVars());
            ++n2;
        }
        for (IProgramVar iProgramVar : this.mAssignedVars) {
            this.addFreshTermVariable(this.mOutVars, iProgramVar, "Out");
        }
    }

    private void collectNonTheoryConsts() {
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = this.mTransFormulas;
        int n = this.mTransFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            UnmodifiableTransFormula unmodifiableTransFormula = unmodifiableTransFormulaArray[n2];
            this.mNonTheoryConsts.addAll(unmodifiableTransFormula.getNonTheoryConsts());
            ++n2;
        }
    }

    private void addFreshTermVariable(Map<IProgramVar, TermVariable> map, IProgramVar iProgramVar, String string) {
        String string2 = iProgramVar.getGloballyUniqueId() + "_" + string;
        TermVariable termVariable = this.mMgdScript.constructFreshTermVariable(string2, iProgramVar.getSort());
        map.put(iProgramVar, termVariable);
    }

    private void computeSubstitutions() {
        this.computeJointInOutVars();
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = this.mTransFormulas;
        int n = this.mTransFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            UnmodifiableTransFormula unmodifiableTransFormula = unmodifiableTransFormulaArray[n2];
            this.mSubstitutions.add(this.computeSubstitution(unmodifiableTransFormula));
            ++n2;
        }
    }

    private Map<TermVariable, TermVariable> computeSubstitution(UnmodifiableTransFormula unmodifiableTransFormula) {
        IProgramVar iProgramVar;
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> termVariable : unmodifiableTransFormula.getInVars().entrySet()) {
            iProgramVar = hashMap.put(termVariable.getValue(), this.mInVars.get(termVariable.getKey()));
            assert (iProgramVar == null) : "duplicate in-variable substitution: " + String.valueOf(termVariable.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : unmodifiableTransFormula.getOutVars().entrySet()) {
            boolean bl;
            iProgramVar = entry.getKey();
            TermVariable termVariable = entry.getValue();
            boolean bl2 = bl = unmodifiableTransFormula.getInVars().get(iProgramVar) != termVariable;
            if (bl) {
                TermVariable termVariable2 = hashMap.put(termVariable, this.mOutVars.get(iProgramVar));
                assert (termVariable2 == null) : "duplicate in/out-variable substitution: " + String.valueOf(termVariable);
                continue;
            }
            assert (hashMap.get(termVariable) == this.mInVars.get(iProgramVar));
        }
        for (TermVariable termVariable : unmodifiableTransFormula.getAuxVars()) {
            iProgramVar = this.mMgdScript.constructFreshCopy(termVariable);
            hashMap.put(termVariable, (TermVariable)iProgramVar);
            this.mAuxVars.add((TermVariable)iProgramVar);
        }
        return hashMap;
    }

    private void computeUnifiedFormulas() {
        int n = 0;
        while (n < this.mTransFormulas.length) {
            this.mUnifiedFormulas[n] = this.computeUnifiedFormula(this.mTransFormulas[n], this.mSubstitutions.get(n));
            ++n;
        }
    }

    private Term computeUnifiedFormula(UnmodifiableTransFormula unmodifiableTransFormula, Map<TermVariable, TermVariable> map) {
        Term term = Substitution.apply((ManagedScript)this.mMgdScript, map, (Term)unmodifiableTransFormula.getFormula());
        Term term2 = this.generateExplicitEqualities(unmodifiableTransFormula);
        return SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{term, term2});
    }

    private Term generateExplicitEqualities(UnmodifiableTransFormula unmodifiableTransFormula) {
        Set<IProgramVar> set = unmodifiableTransFormula.getAssignedVars();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramVar iProgramVar : this.mAssignedVars) {
            if (set.contains(iProgramVar)) continue;
            TermVariable termVariable = this.mInVars.get(iProgramVar);
            assert (termVariable != null);
            TermVariable termVariable2 = this.mOutVars.get(iProgramVar);
            assert (termVariable2 != null);
            assert (termVariable != termVariable2) : "assigned variable needs different in/out-vars";
            arrayList.add(SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)termVariable, (Term)termVariable2));
        }
        return SmtUtils.and((Script)this.mMgdScript.getScript(), arrayList);
    }

    private boolean assignedInAll(IProgramVar iProgramVar) {
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = this.mTransFormulas;
        int n = this.mTransFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            UnmodifiableTransFormula unmodifiableTransFormula = unmodifiableTransFormulaArray[n2];
            if (!unmodifiableTransFormula.getAssignedVars().contains(iProgramVar)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

