/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieProgramExecution;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.models.Multigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.models.MultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.WitnessInvariant;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Term2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ForkThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.JoinThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IcfgBacktranslator
extends DefaultTranslator<IIcfgTransition<IcfgLocation>, BoogieASTNode, Term, Expression, IcfgLocation, String, ILocation> {
    private final ILogger mLogger;
    private Term2Expression mTerm2Expression;
    private final Map<Statement, BoogieASTNode[]> mCodeBlock2Statement = new HashMap<Statement, BoogieASTNode[]>();

    public IcfgBacktranslator(ILogger iLogger) {
        super(IcfgEdge.class, BoogieASTNode.class, Term.class, Expression.class);
        this.mLogger = iLogger;
    }

    public void setTerm2Expression(Term2Expression term2Expression) {
        this.mTerm2Expression = term2Expression;
    }

    public BoogieASTNode[] putAux(Statement statement, BoogieASTNode[] boogieASTNodeArray) {
        return this.mCodeBlock2Statement.put(statement, boogieASTNodeArray);
    }

    public List<BoogieASTNode> translateTrace(List<IIcfgTransition<IcfgLocation>> list) {
        List<IIcfgTransition<IcfgLocation>> list2 = list;
        ArrayList<AtomicTraceElement<BoogieASTNode>> arrayList2 = new ArrayList<AtomicTraceElement<BoogieASTNode>>();
        for (IIcfgTransition<IcfgLocation> iIcfgTransition : list2) {
            if (!(iIcfgTransition instanceof CodeBlock)) {
                throw new AssertionError((Object)"unknown icfg element");
            }
            this.addCodeBlock(iIcfgTransition, null, null, null, null, arrayList2, null);
        }
        ArrayList<BoogieASTNode> arrayList = new ArrayList<BoogieASTNode>();
        for (AtomicTraceElement atomicTraceElement : arrayList2) {
            arrayList.add((BoogieASTNode)atomicTraceElement.getTraceElement());
        }
        return arrayList;
    }

    private void addCodeBlock(AtomicTraceElement<IIcfgTransition<IcfgLocation>> atomicTraceElement, List<AtomicTraceElement<BoogieASTNode>> list, Map<TermVariable, Boolean> map) {
        IIcfgTransition iIcfgTransition = (IIcfgTransition)atomicTraceElement.getTraceElement();
        IRelevanceInformation iRelevanceInformation = atomicTraceElement.getRelevanceInformation();
        Integer n = atomicTraceElement.getStepInfo().contains(AtomicTraceElement.StepInfo.FORK) ? Integer.valueOf(atomicTraceElement.getForkedThreadId()) : null;
        Integer n2 = atomicTraceElement.getStepInfo().contains(AtomicTraceElement.StepInfo.JOIN) ? Integer.valueOf(atomicTraceElement.getJoinedThreadId()) : null;
        this.addCodeBlock((IIcfgTransition<IcfgLocation>)iIcfgTransition, iRelevanceInformation, atomicTraceElement.hasThreadId() ? Integer.valueOf(atomicTraceElement.getThreadId()) : null, n, n2, list, map);
    }

    private void addCodeBlock(IIcfgTransition<IcfgLocation> iIcfgTransition, IRelevanceInformation iRelevanceInformation, Integer n, Integer n2, Integer n3, List<AtomicTraceElement<BoogieASTNode>> list, Map<TermVariable, Boolean> map) {
        AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
        atomicTraceElementBuilder.setRelevanceInformation(iRelevanceInformation);
        atomicTraceElementBuilder.setToStringFunc(BoogiePrettyPrinter.getBoogieToStringProvider());
        if (n != null) {
            atomicTraceElementBuilder.setThreadId(n.intValue());
        }
        if (n2 != null) {
            atomicTraceElementBuilder.setForkedThreadId(n2.intValue());
        }
        if (n3 != null) {
            atomicTraceElementBuilder.setJoinedThreadId(n3.intValue());
        }
        atomicTraceElementBuilder.setProcedures(iIcfgTransition.getPrecedingProcedure(), iIcfgTransition.getSucceedingProcedure());
        if (iIcfgTransition instanceof Call) {
            CallStatement callStatement = ((Call)iIcfgTransition).getCallStatement();
            atomicTraceElementBuilder.setStepAndElement((Object)callStatement);
            atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_CALL});
        } else if (iIcfgTransition instanceof Return) {
            CallStatement callStatement = ((Return)iIcfgTransition).getCallStatement();
            atomicTraceElementBuilder.setStepAndElement((Object)callStatement);
            atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_RETURN});
        } else if (iIcfgTransition instanceof ForkThreadCurrent) {
            ForkStatement forkStatement = ((ForkThreadCurrent)iIcfgTransition).getForkStatement();
            atomicTraceElementBuilder.setStepAndElement((Object)forkStatement);
            atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FORK});
        } else if (iIcfgTransition instanceof JoinThreadCurrent) {
            JoinStatement joinStatement = ((JoinThreadCurrent)iIcfgTransition).getJoinStatement();
            atomicTraceElementBuilder.setStepAndElement((Object)joinStatement);
            atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.JOIN});
        } else if (iIcfgTransition instanceof Summary) {
            CallStatement callStatement = ((Summary)iIcfgTransition).getCallStatement();
            atomicTraceElementBuilder.setStepAndElement((Object)callStatement);
        } else {
            if (iIcfgTransition instanceof StatementSequence) {
                StatementSequence statementSequence = (StatementSequence)iIcfgTransition;
                for (Statement statement : statementSequence.getStatements()) {
                    BoogieASTNode[] boogieASTNodeArray = this.mCodeBlock2Statement.get(statement);
                    if (boogieASTNodeArray != null) {
                        assert (boogieASTNodeArray.length == 1 || boogieASTNodeArray.length == 2 && boogieASTNodeArray[0] instanceof CallStatement && boogieASTNodeArray[1] instanceof RequiresSpecification);
                        BoogieASTNode[] boogieASTNodeArray2 = boogieASTNodeArray;
                        int n4 = boogieASTNodeArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            BoogieASTNode boogieASTNode = boogieASTNodeArray2[n5];
                            if ((boogieASTNode instanceof WhileStatement || boogieASTNode instanceof IfStatement) && statement instanceof AssumeStatement) {
                                Expression expression;
                                if (boogieASTNode instanceof WhileStatement) {
                                    expression = ((WhileStatement)boogieASTNode).getCondition();
                                } else if (boogieASTNode instanceof IfStatement) {
                                    expression = ((IfStatement)boogieASTNode).getCondition();
                                } else {
                                    throw new AssertionError();
                                }
                                AtomicTraceElement.StepInfo stepInfo = this.getStepInfoFromCondition(((AssumeStatement)statement).getFormula(), expression);
                                atomicTraceElementBuilder.setElement((Object)boogieASTNode);
                                atomicTraceElementBuilder.setStep((Object)expression);
                                atomicTraceElementBuilder.setStepInfo(EnumSet.of(stepInfo));
                                AtomicTraceElement atomicTraceElement = atomicTraceElementBuilder.build();
                                list.add((AtomicTraceElement<BoogieASTNode>)atomicTraceElement);
                                atomicTraceElementBuilder = AtomicTraceElement.AtomicTraceElementBuilder.from((AtomicTraceElement)atomicTraceElement).setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.NONE});
                            } else if (!(boogieASTNode instanceof Label)) {
                                atomicTraceElementBuilder.setStepAndElement((Object)boogieASTNode);
                                list.add((AtomicTraceElement<BoogieASTNode>)atomicTraceElementBuilder.build());
                            }
                            ++n5;
                        }
                        continue;
                    }
                    atomicTraceElementBuilder.setStepAndElement((Object)statement);
                    list.add((AtomicTraceElement<BoogieASTNode>)atomicTraceElementBuilder.build());
                }
                return;
            }
            if (iIcfgTransition instanceof SequentialComposition) {
                SequentialComposition sequentialComposition = (SequentialComposition)iIcfgTransition;
                for (CodeBlock codeBlock : sequentialComposition.getCodeBlocks()) {
                    this.addCodeBlock((IIcfgTransition<IcfgLocation>)codeBlock, iRelevanceInformation, n, n2, n3, list, map);
                }
                return;
            }
            if (iIcfgTransition instanceof ParallelComposition) {
                ParallelComposition parallelComposition = (ParallelComposition)iIcfgTransition;
                Map map2 = parallelComposition.getBranchIndicator2CodeBlock();
                if (map == null) {
                    CodeBlock codeBlock = (CodeBlock)map2.entrySet().iterator().next().getValue();
                    this.addCodeBlock((IIcfgTransition<IcfgLocation>)codeBlock, iRelevanceInformation, n, n2, n3, list, map);
                    ILocation iLocation = ILocation.getAnnotation((IElement)iIcfgTransition.getSource());
                    this.mLogger.warn((Object)"You are using large block encoding together with an algorithm for which the backtranslation into program statements is not yet implemented.");
                    if (iLocation == null) {
                        this.mLogger.error((Object)"unable to determine which branch was taken, unable to determine the location");
                    } else {
                        this.mLogger.warn((Object)("unable to determine which branch was taken at " + String.valueOf(iLocation)));
                    }
                    return;
                }
                for (Map.Entry entry : map2.entrySet()) {
                    boolean bl = map.get(entry.getKey());
                    if (!bl) continue;
                    this.addCodeBlock((IIcfgTransition<IcfgLocation>)((IIcfgTransition)entry.getValue()), iRelevanceInformation, n, n2, n3, list, map);
                    return;
                }
                throw new AssertionError((Object)"no branch was taken");
            }
            if (iIcfgTransition instanceof GotoEdge) {
                return;
            }
            throw new UnsupportedOperationException("Unsupported CodeBlock: " + iIcfgTransition.getClass().getCanonicalName());
        }
        list.add((AtomicTraceElement<BoogieASTNode>)atomicTraceElementBuilder.build());
    }

    public IProgramExecution<BoogieASTNode, Expression> translateProgramExecution(IProgramExecution<IIcfgTransition<IcfgLocation>, Term> iProgramExecution) {
        if (!(iProgramExecution instanceof IcfgProgramExecution)) {
            throw new IllegalArgumentException("Unsupported type of execution " + iProgramExecution.getClass().getSimpleName());
        }
        IcfgProgramExecution icfgProgramExecution = (IcfgProgramExecution)iProgramExecution;
        assert (this.checkCallStackSourceProgramExecution(this.mLogger, iProgramExecution)) : "callstack of initial program execution already broken";
        ArrayList<AtomicTraceElement<BoogieASTNode>> arrayList = new ArrayList<AtomicTraceElement<BoogieASTNode>>();
        HashMap<Integer, IProgramExecution.ProgramState> hashMap = new HashMap<Integer, IProgramExecution.ProgramState>();
        if (icfgProgramExecution.getInitialProgramState() != null) {
            hashMap.put(-1, this.translateProgramState(icfgProgramExecution.getInitialProgramState()));
        }
        int n = 0;
        while (n < icfgProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = icfgProgramExecution.getTraceElement(n);
            Map[] mapArray = icfgProgramExecution.getBranchEncoders();
            if (mapArray == null || n >= mapArray.length) {
                this.addCodeBlock((AtomicTraceElement<IIcfgTransition<IcfgLocation>>)atomicTraceElement, arrayList, null);
            } else {
                this.addCodeBlock((AtomicTraceElement<IIcfgTransition<IcfgLocation>>)atomicTraceElement, arrayList, mapArray[n]);
            }
            int n2 = arrayList.size() - 1;
            IProgramExecution.ProgramState programState = icfgProgramExecution.getProgramState(n);
            hashMap.put(n2, this.translateProgramState(programState));
            ++n;
        }
        assert (this.checkCallStackTarget(this.mLogger, arrayList));
        return new BoogieProgramExecution(hashMap, arrayList, iProgramExecution.isConcurrent());
    }

    public IBacktranslatedCFG<String, BoogieASTNode> translateCFG(IBacktranslatedCFG<IcfgLocation, IIcfgTransition<IcfgLocation>> iBacktranslatedCFG) {
        return this.translateCFG(iBacktranslatedCFG, (map, iMultigraphEdge, multigraph) -> this.translateCFGEdge((Map<IExplicitEdgesMultigraph<?, ?, IcfgLocation, ? extends IIcfgTransition<IcfgLocation>, ?>, Multigraph<String, BoogieASTNode>>)map, (IIcfgTransition<IcfgLocation>)((IIcfgTransition)iMultigraphEdge), (Multigraph<String, BoogieASTNode>)multigraph));
    }

    private Multigraph<String, BoogieASTNode> translateCFGEdge(Map<IExplicitEdgesMultigraph<?, ?, IcfgLocation, ? extends IIcfgTransition<IcfgLocation>, ?>, Multigraph<String, BoogieASTNode>> map, IIcfgTransition<IcfgLocation> iIcfgTransition, Multigraph<String, BoogieASTNode> multigraph) {
        Multigraph<String, BoogieASTNode> multigraph2;
        IcfgLocation icfgLocation = iIcfgTransition.getTarget();
        if (icfgLocation != null) {
            multigraph2 = map.get(icfgLocation);
            if (multigraph2 == null) {
                multigraph2 = IcfgBacktranslator.createWitnessNode(icfgLocation);
                map.put((IExplicitEdgesMultigraph<?, ?, IcfgLocation, IIcfgTransition<IcfgLocation>, ?>)icfgLocation, multigraph2);
            }
        } else {
            multigraph2 = this.createUnlabeledWitnessNode(null);
        }
        if (iIcfgTransition instanceof Call) {
            CallStatement callStatement = ((Call)iIcfgTransition).getCallStatement();
            IcfgBacktranslator.createNewEdge(multigraph, multigraph2, (BoogieASTNode)callStatement);
        } else if (iIcfgTransition instanceof Return) {
            CallStatement callStatement = ((Return)iIcfgTransition).getCallStatement();
            IcfgBacktranslator.createNewEdge(multigraph, multigraph2, (BoogieASTNode)callStatement);
        } else if (iIcfgTransition instanceof Summary) {
            CallStatement callStatement = ((Summary)iIcfgTransition).getCallStatement();
            IcfgBacktranslator.createNewEdge(multigraph, multigraph2, (BoogieASTNode)callStatement);
        } else if (iIcfgTransition instanceof StatementSequence) {
            StatementSequence statementSequence = (StatementSequence)iIcfgTransition;
            this.translateEdgeStatementSequence(multigraph, multigraph2, statementSequence);
        } else if (iIcfgTransition instanceof SequentialComposition) {
            SequentialComposition sequentialComposition = (SequentialComposition)iIcfgTransition;
            Multigraph<String, BoogieASTNode> multigraph3 = multigraph;
            for (CodeBlock codeBlock : sequentialComposition.getCodeBlocks()) {
                multigraph3 = this.translateCFGEdge(map, (IIcfgTransition<IcfgLocation>)codeBlock, multigraph3);
            }
            IcfgBacktranslator.createNewEdge(multigraph3, multigraph2, null);
        } else if (iIcfgTransition instanceof ParallelComposition) {
            ParallelComposition parallelComposition = (ParallelComposition)iIcfgTransition;
            Map map2 = parallelComposition.getBranchIndicator2CodeBlock();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                CodeBlock codeBlock = (CodeBlock)iterator.next().getValue();
                Multigraph<String, BoogieASTNode> multigraph4 = this.translateCFGEdge(map, (IIcfgTransition<IcfgLocation>)codeBlock, multigraph);
                IcfgBacktranslator.createNewEdge(multigraph4, multigraph2, null);
            }
        } else if (iIcfgTransition instanceof GotoEdge) {
            IcfgBacktranslator.createNewEdge(multigraph, multigraph2, null);
        } else {
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)iIcfgTransition.getTarget();
            if (!boogieIcfgLocation.getProcedure().equals("ULTIMATE.start")) {
                this.mLogger.info((Object)("Ignoring RootEdge to procedure " + boogieIcfgLocation.getProcedure()));
                return null;
            }
            IcfgBacktranslator.createNewEdge(multigraph, multigraph2, null);
        }
        return multigraph2;
    }

    private void translateEdgeStatementSequence(Multigraph<String, BoogieASTNode> multigraph, Multigraph<String, BoogieASTNode> multigraph2, StatementSequence statementSequence) {
        int n = 0;
        int n2 = statementSequence.getStatements().size() - 1;
        Object object = multigraph;
        for (Statement statement : statementSequence.getStatements()) {
            Multigraph multigraph3 = object;
            object = n == n2 ? multigraph2 : this.createUnlabeledWitnessNode(null);
            IcfgBacktranslator.createNewEdge((Multigraph<String, BoogieASTNode>)multigraph3, (Multigraph<String, BoogieASTNode>)object, (BoogieASTNode)statement);
            ++n;
        }
    }

    private static void createNewEdge(Multigraph<String, BoogieASTNode> multigraph, Multigraph<String, BoogieASTNode> multigraph2, BoogieASTNode boogieASTNode) {
        new MultigraphEdge(multigraph, (Object)boogieASTNode, multigraph2);
    }

    private static Multigraph<String, BoogieASTNode> createWitnessNode(IcfgLocation icfgLocation) {
        WitnessInvariant witnessInvariant = WitnessInvariant.getAnnotation((IElement)icfgLocation);
        Multigraph multigraph = new Multigraph(witnessInvariant == null ? null : witnessInvariant.getInvariant().toString());
        ModelUtils.copyAnnotations((IElement)icfgLocation, (IElement)multigraph);
        return multigraph;
    }

    public Expression translateExpression(Term term) {
        return this.mTerm2Expression.translate(term);
    }

    private AtomicTraceElement.StepInfo getStepInfoFromCondition(Expression expression, Expression expression2) {
        if (!(expression instanceof UnaryExpression)) {
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE;
        }
        UnaryExpression unaryExpression = (UnaryExpression)expression;
        if (unaryExpression.getOperator() != UnaryExpression.Operator.LOGICNEG) {
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE;
        }
        if (!(expression2 instanceof UnaryExpression)) {
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE;
        }
        UnaryExpression unaryExpression2 = (UnaryExpression)expression2;
        if (unaryExpression.getOperator() != UnaryExpression.Operator.LOGICNEG) {
            return AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE;
        }
        return this.getStepInfoFromCondition(unaryExpression.getExpr(), unaryExpression2.getExpr());
    }
}

