/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqtotest.req;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScopeAfter;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScopeGlobally;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.AbsencePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.InvarianceBoundL2Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.InvariancePattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseBoundL12Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseBoundL1Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseDelayBoundL2Pattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.ResponseDelayPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.UniversalityPattern;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.CddToSmt;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.AuxVarGen;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.Req2TestReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.ReqGuardGraph;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.TimedLabel;
import java.util.ArrayList;
import java.util.List;

public class ReqToGraph {
    private final ILogger mLogger;
    private final CddToSmt mCddToSmt;
    private final Req2TestReqSymbolTable mReqSymbolTable;
    private final AuxVarGen mThreeValuedAuxVarGen;
    private final Script mScript;
    private final Term mSmtTrue;
    private final boolean UNIVERSALITY_IS_DEFINITNG = false;

    public ReqToGraph(ILogger iLogger, AuxVarGen auxVarGen, Script script, CddToSmt cddToSmt, Req2TestReqSymbolTable req2TestReqSymbolTable) {
        this.mLogger = iLogger;
        this.mThreeValuedAuxVarGen = auxVarGen;
        this.mCddToSmt = cddToSmt;
        this.mScript = script;
        this.mReqSymbolTable = req2TestReqSymbolTable;
        this.mSmtTrue = this.mScript.term("true", new Term[0]);
    }

    public List<ReqGuardGraph> patternListToBuechi(List<PatternType<?>> list) {
        ArrayList<ReqGuardGraph> arrayList = new ArrayList<ReqGuardGraph>();
        for (PatternType<?> patternType : list) {
            ReqGuardGraph reqGuardGraph;
            if (patternType instanceof DeclarationPattern || (reqGuardGraph = this.patternToTestAutomaton(patternType)) == null) continue;
            arrayList.add(reqGuardGraph);
        }
        return arrayList;
    }

    private Term getDurationTerm(Rational rational) {
        return rational.toTerm(SmtSortUtils.getIntSort((Script)this.mScript));
    }

    public ReqGuardGraph patternToTestAutomaton(PatternType<?> patternType) {
        if (patternType instanceof InvariancePattern) {
            return this.getInvariantPattern(patternType);
        }
        if (patternType instanceof ResponseDelayPattern) {
            return this.getBndResponsePatternUTPattern(patternType);
        }
        if (patternType instanceof InvarianceBoundL2Pattern) {
            return this.getBndInvariance(patternType);
        }
        if (patternType instanceof ResponseBoundL12Pattern) {
            return this.getBndResponsePatternTTPattern(patternType);
        }
        if (patternType instanceof UniversalityPattern) {
            return this.getUniversalityPattern(patternType);
        }
        if (patternType instanceof ResponseDelayBoundL2Pattern) {
            return this.getBndDelayedResponsePatternUT(patternType);
        }
        if (patternType instanceof AbsencePattern) {
            return this.getInstAbsPattern(patternType);
        }
        if (patternType instanceof ResponseBoundL1Pattern) {
            return this.getBndResponsePatternTUPattern(patternType);
        }
        throw new UnsupportedOperationException("Pattern type is not supported at:" + patternType.toString());
    }

    private ReqGuardGraph getBndResponsePatternTTPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph2 = new ReqGuardGraph(1, string);
            ReqGuardGraph reqGuardGraph3 = new ReqGuardGraph(2, string);
            ReqGuardGraph reqGuardGraph4 = new ReqGuardGraph(-1, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term2);
            Rational rational = (Rational)patternType.getDurations().get(0);
            Rational rational2 = (Rational)patternType.getDurations().get(1);
            TermVariable termVariable = this.mThreeValuedAuxVarGen.generateClockIdent(reqGuardGraph);
            Term term3 = SmtUtils.less((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term4 = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term5 = SmtUtils.less((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational2));
            Term term6 = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational2));
            Term term7 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term8 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term9 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term10 = SmtUtils.not((Script)this.mScript, (Term)term9);
            Term term11 = SmtUtils.not((Script)this.mScript, (Term)term);
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term9, term11}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term, term8}), this.mSmtTrue, termVariable));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term, term8}), term3));
            reqGuardGraph2.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term}), term4, termVariable));
            reqGuardGraph3.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term2}), term5, true));
            reqGuardGraph3.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term2}), term6, true));
            reqGuardGraph.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term10, term8}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term10, term8}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{term9, term11, term8}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term, term8}), this.mSmtTrue, termVariable));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getBndDelayedResponsePatternUT(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph2 = new ReqGuardGraph(1, string);
            ReqGuardGraph reqGuardGraph3 = new ReqGuardGraph(2, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term2);
            Rational rational = (Rational)patternType.getDurations().get(0);
            Rational rational2 = (Rational)patternType.getDurations().get(1);
            TermVariable termVariable = this.mThreeValuedAuxVarGen.generateClockIdent(reqGuardGraph);
            Term term3 = SmtUtils.less((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term4 = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term5 = SmtUtils.less((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational2));
            Term term6 = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational2));
            Term term7 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term8 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term9 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term10 = SmtUtils.not((Script)this.mScript, (Term)term9);
            Term term11 = SmtUtils.not((Script)this.mScript, (Term)term);
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term9, term11}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term10}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term, term8}), this.mSmtTrue, termVariable));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term, term8}), term3));
            reqGuardGraph2.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term}), term4, termVariable));
            reqGuardGraph3.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term2}), term5, true));
            reqGuardGraph3.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term2}), term6, true));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getBndResponsePatternTUPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph2 = new ReqGuardGraph(1, string);
            ReqGuardGraph reqGuardGraph3 = new ReqGuardGraph(2, string);
            ReqGuardGraph reqGuardGraph4 = new ReqGuardGraph(-1, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term2);
            Rational rational = (Rational)patternType.getDurations().get(0);
            TermVariable termVariable = this.mThreeValuedAuxVarGen.generateClockIdent(reqGuardGraph);
            Term term3 = SmtUtils.less((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term4 = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term5 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term6 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term7 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term8 = SmtUtils.not((Script)this.mScript, (Term)term7);
            Term term9 = SmtUtils.not((Script)this.mScript, (Term)term);
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term6, term7, term9}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term, term6}), this.mSmtTrue, termVariable));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term, term6}), term3));
            reqGuardGraph2.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term, term6}), term4));
            reqGuardGraph2.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term7, term6}), term3));
            reqGuardGraph3.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term, term5, term2}), this.mSmtTrue, true));
            reqGuardGraph3.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term7, term2, term5}), this.mSmtTrue, true));
            reqGuardGraph.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term6}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term6}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term6}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term9, term6}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term, term6}), (Term)termVariable));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getBndInvariance(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph2 = new ReqGuardGraph(1, string);
            ReqGuardGraph reqGuardGraph3 = new ReqGuardGraph(-1, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term2);
            Rational rational = (Rational)patternType.getDurations().get(0);
            TermVariable termVariable = this.mThreeValuedAuxVarGen.generateClockIdent(reqGuardGraph);
            Term term3 = SmtUtils.leq((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term4 = SmtUtils.greater((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term5 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term6 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term7 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term8 = SmtUtils.not((Script)this.mScript, (Term)term7);
            Term term9 = SmtUtils.not((Script)this.mScript, (Term)term);
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term9, term6}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term, term5, term2}), this.mSmtTrue, termVariable, true));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term3, term2, term5, term7, term9}), this.mSmtTrue, true));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term3, term2, term5, term7, term}), this.mSmtTrue, termVariable, true));
            reqGuardGraph2.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term4, term7, term9, term6}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term6}), this.mSmtTrue));
            reqGuardGraph3.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term6}), this.mSmtTrue));
            reqGuardGraph3.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term9, term6}), this.mSmtTrue));
            reqGuardGraph3.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term, term5, term2}), this.mSmtTrue, termVariable, true));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getBndResponsePatternUTPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph2 = new ReqGuardGraph(1, string);
            ReqGuardGraph reqGuardGraph3 = new ReqGuardGraph(2, string);
            ReqGuardGraph reqGuardGraph4 = new ReqGuardGraph(-1, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term2);
            Rational rational = (Rational)patternType.getDurations().get(0);
            TermVariable termVariable = this.mThreeValuedAuxVarGen.generateClockIdent(reqGuardGraph);
            Term term3 = SmtUtils.less((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term4 = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term5 = SmtUtils.geq((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term6 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term7 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term8 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term9 = SmtUtils.not((Script)this.mScript, (Term)term8);
            Term term10 = this.mThreeValuedAuxVarGen.getUseGuard(term2);
            Term term11 = SmtUtils.not((Script)this.mScript, (Term)term);
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term8, term11}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term10, term2}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term, term7}), this.mSmtTrue, termVariable));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, term8, term7}), term3));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term11, term8, term7}), term5));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, term8, term2, term6}), term5, true));
            reqGuardGraph2.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term8, term11}), term3));
            reqGuardGraph2.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term9}), term3));
            reqGuardGraph3.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7}), term3));
            reqGuardGraph3.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term2, term6}), term4, true));
            reqGuardGraph.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term7}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term7}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term11, term7}), SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term10, term2, term7})}), this.mSmtTrue));
            reqGuardGraph4.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term, term7}), this.mSmtTrue, termVariable));
            return reqGuardGraph;
        }
        if (patternType.getScope() instanceof SrParseScopeAfter) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term12 = this.mCddToSmt.toSmt((CDD)list.get(0));
            Term term13 = this.mCddToSmt.toSmt(patternType.getScope().getCdd1());
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph5 = new ReqGuardGraph(1, string);
            ReqGuardGraph reqGuardGraph6 = new ReqGuardGraph(2, string);
            ReqGuardGraph reqGuardGraph7 = new ReqGuardGraph(3, string);
            ReqGuardGraph reqGuardGraph8 = new ReqGuardGraph(-1, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph5, term12);
            Rational rational = (Rational)patternType.getDurations().get(0);
            TermVariable termVariable = this.mThreeValuedAuxVarGen.generateClockIdent(reqGuardGraph);
            Term term14 = SmtUtils.less((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term15 = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term16 = SmtUtils.geq((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term17 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph5);
            Term term18 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph5);
            Term term19 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term20 = SmtUtils.not((Script)this.mScript, (Term)term19);
            Term term21 = this.mThreeValuedAuxVarGen.getUseGuard(term12);
            Term term22 = SmtUtils.not((Script)this.mScript, (Term)term);
            Term term23 = SmtUtils.not((Script)this.mScript, (Term)term13);
            Term term24 = this.mThreeValuedAuxVarGen.getUseGuard(term13);
            Term term25 = SmtUtils.not((Script)this.mScript, (Term)term13);
            reqGuardGraph.connectOutgoing(reqGuardGraph5, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term18, term24, term13}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph6, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term18, term24, term13, term, term19}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term18, SmtUtils.or((Script)this.mScript, (Term[])new Term[]{term23, term25})}), this.mSmtTrue));
            reqGuardGraph5.connectOutgoing(reqGuardGraph5, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term18, term19, term22}), this.mSmtTrue));
            reqGuardGraph5.connectOutgoing(reqGuardGraph5, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term18, term21, term12}), this.mSmtTrue));
            reqGuardGraph5.connectOutgoing(reqGuardGraph6, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term19, term, term18}), this.mSmtTrue, termVariable));
            reqGuardGraph6.connectOutgoing(reqGuardGraph6, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, term19, term18}), term14));
            reqGuardGraph6.connectOutgoing(reqGuardGraph6, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term22, term19, term18}), term16));
            reqGuardGraph6.connectOutgoing(reqGuardGraph6, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, term19, term12, term17}), term16, true));
            reqGuardGraph6.connectOutgoing(reqGuardGraph5, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term18, term19, term22}), term14));
            reqGuardGraph6.connectOutgoing(reqGuardGraph7, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term18, term20}), term14));
            reqGuardGraph7.connectOutgoing(reqGuardGraph7, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term18}), term14));
            reqGuardGraph7.connectOutgoing(reqGuardGraph5, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term12, term17}), term15, true));
            reqGuardGraph5.connectOutgoing(reqGuardGraph8, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term20, term18}), this.mSmtTrue));
            reqGuardGraph8.connectOutgoing(reqGuardGraph8, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term20, term18}), this.mSmtTrue));
            reqGuardGraph8.connectOutgoing(reqGuardGraph5, new TimedLabel(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term19, term22, term18}), SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term21, term12, term18})}), this.mSmtTrue));
            reqGuardGraph8.connectOutgoing(reqGuardGraph6, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term19, term, term18}), this.mSmtTrue, termVariable));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getInvariantPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term2);
            Term term3 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term4 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term5 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term6 = SmtUtils.not((Script)this.mScript, (Term)term5);
            Term term7 = this.mThreeValuedAuxVarGen.getUseGuard(term2);
            Term term8 = SmtUtils.not((Script)this.mScript, (Term)term);
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term6, term4}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term8, term4}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term2, term7, term4}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term, term3, term2}), this.mSmtTrue, true));
            return reqGuardGraph;
        }
        if (patternType.getScope() instanceof SrParseScopeAfter) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term9 = this.mCddToSmt.toSmt((CDD)list.get(0));
            Term term10 = this.mCddToSmt.toSmt(patternType.getScope().getCdd1());
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph2 = new ReqGuardGraph(1, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term9);
            Term term11 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term12 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term13 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term14 = SmtUtils.not((Script)this.mScript, (Term)term13);
            Term term15 = this.mThreeValuedAuxVarGen.getUseGuard(term9);
            Term term16 = SmtUtils.not((Script)this.mScript, (Term)term);
            Term term17 = this.mThreeValuedAuxVarGen.getUseGuard(term10);
            Term term18 = SmtUtils.not((Script)this.mScript, (Term)term17);
            Term term19 = SmtUtils.not((Script)this.mScript, (Term)term10);
            reqGuardGraph.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term17, term10}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{term18, SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term17, term19})}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term14, term12}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term13, term16, term12}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term9, term15, term12}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term13, term, term11, term9}), this.mSmtTrue, true));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getUniversalityPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(0));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(term, this.mSmtTrue));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getInstAbsPattern(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(0));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term);
            Term term2 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term3 = SmtUtils.not((Script)this.mScript, (Term)term);
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term3, term2}), this.mSmtTrue, true));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getImmediateResponsePatternToAutomaton(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            String string = patternType.getId();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(0));
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph2 = new ReqGuardGraph(1, string);
            ReqGuardGraph reqGuardGraph3 = new ReqGuardGraph(-1, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term2);
            Term term3 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term4 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term5 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term6 = SmtUtils.not((Script)this.mScript, (Term)term5);
            Term term7 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, term2});
            Term term8 = SmtUtils.not((Script)this.mScript, (Term)term);
            Term term9 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term8, term2});
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term8, term4}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term, term4}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term7, term3}), this.mSmtTrue, true));
            reqGuardGraph2.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term9, term3}), this.mSmtTrue, true));
            reqGuardGraph.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term6, term4}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term6, term3, term2}), this.mSmtTrue, true));
            reqGuardGraph3.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term6, term4}), this.mSmtTrue));
            reqGuardGraph3.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term8, term4}), this.mSmtTrue));
            reqGuardGraph3.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term, term4}), this.mSmtTrue));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private ReqGuardGraph getTogglePatternDelayed(PatternType<?> patternType) {
        if (patternType.getScope() instanceof SrParseScopeGlobally) {
            List list = patternType.getCdds();
            Term term = this.mCddToSmt.toSmt((CDD)list.get(0));
            Term term2 = this.mCddToSmt.toSmt((CDD)list.get(1));
            Term term3 = this.mCddToSmt.toSmt((CDD)list.get(2));
            String string = patternType.getId();
            ReqGuardGraph reqGuardGraph = new ReqGuardGraph(0, string);
            ReqGuardGraph reqGuardGraph2 = new ReqGuardGraph(1, string);
            ReqGuardGraph reqGuardGraph3 = new ReqGuardGraph(2, string);
            ReqGuardGraph reqGuardGraph4 = new ReqGuardGraph(3, string);
            this.mThreeValuedAuxVarGen.setEffectLabel(reqGuardGraph, term3);
            Term term4 = this.mThreeValuedAuxVarGen.getDefineGuard(reqGuardGraph);
            Term term5 = this.mThreeValuedAuxVarGen.getNonDefineGuard(reqGuardGraph);
            Term term6 = this.mThreeValuedAuxVarGen.getUseGuard(term);
            Term term7 = this.mThreeValuedAuxVarGen.getUseGuard(term2);
            Term term8 = SmtUtils.not((Script)this.mScript, (Term)term);
            Term term9 = SmtUtils.not((Script)this.mScript, (Term)term2);
            Rational rational = (Rational)patternType.getDurations().get(0);
            TermVariable termVariable = this.mThreeValuedAuxVarGen.generateClockIdent(reqGuardGraph);
            Term term10 = SmtUtils.less((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term11 = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            Term term12 = SmtUtils.geq((Script)this.mScript, (Term)termVariable, (Term)this.getDurationTerm(rational));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term6, term8}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term9, term7}), this.mSmtTrue));
            reqGuardGraph.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, term2, term6, term7, term5}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph2, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term2, term7, term5}), this.mSmtTrue));
            reqGuardGraph2.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term9, term5}), this.mSmtTrue, termVariable));
            reqGuardGraph3.connectOutgoing(reqGuardGraph3, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term9, term5}), term10));
            reqGuardGraph3.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term9, term4, term3}), term11, true));
            reqGuardGraph4.connectOutgoing(reqGuardGraph4, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term9, term4, term3}), this.mSmtTrue, true));
            reqGuardGraph4.connectOutgoing(reqGuardGraph, new TimedLabel(SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term2, term7, term4, term3}), term12, true));
            return reqGuardGraph;
        }
        this.scopeNotImplementedWarning(patternType);
        return null;
    }

    private void scopeNotImplementedWarning(PatternType<?> patternType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Scope not implemented: ");
        stringBuilder.append(patternType.getScope().toString());
        stringBuilder.append(" [in: ");
        stringBuilder.append(patternType.getId());
        stringBuilder.append(" ]");
        this.mLogger.warn((Object)stringBuilder.toString());
    }
}

