/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph;

import de.uni_freiburg.informatik.ultimate.automata.tree.TreeRun;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.SsaInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class HcSsaTreeFlattener {
    private final TreeRun<HornClause, SsaInfo> mNestedFormulas;
    private final Map<Term, Integer> mCounters;
    private boolean mCountersAreFinalized;
    private final Term[] mFlattenedTerms;
    private final int[] mStartsOfSubtrees;

    public HcSsaTreeFlattener(TreeRun<HornClause, SsaInfo> treeRun) {
        this.mNestedFormulas = treeRun;
        this.mCounters = new HashMap<Term, Integer>();
        this.mCountersAreFinalized = false;
        Pair<List<Term>, List<Integer>> pair = this.flatten(this.mNestedFormulas, 0);
        List list = (List)pair.getFirst();
        List list2 = (List)pair.getSecond();
        this.mFlattenedTerms = list.toArray(new Term[list.size()]);
        this.mStartsOfSubtrees = new int[list2.size()];
        this.computeStartsOfSubtrees(list2);
        this.mCountersAreFinalized = true;
    }

    private void computeStartsOfSubtrees(List<Integer> list) {
        Stack<Integer> stack = new Stack<Integer>();
        int n = -1;
        int n2 = 0;
        while (n2 < list.size()) {
            int n3 = list.get(n2);
            int n4 = n3 - n;
            if (n4 != 0) {
                if (n4 > 0) {
                    var7_7 = 0;
                    while (var7_7 < n4) {
                        stack.push(n2);
                        ++var7_7;
                    }
                } else {
                    var7_7 = n4;
                    while (var7_7 < 0) {
                        stack.pop();
                        ++var7_7;
                    }
                }
            }
            this.mStartsOfSubtrees[n2] = (Integer)stack.peek();
            n = n3;
            ++n2;
        }
    }

    int getCounter(Term term) {
        if (!this.mCounters.containsKey(term)) {
            assert (!this.mCountersAreFinalized);
            int n = this.mCounters.size() + 1;
            this.mCounters.put(term, n);
        }
        return this.mCounters.get(term);
    }

    public String getName(Term term) {
        return "HCsSATerm_" + this.getCounter(term);
    }

    public Term[] getFlattenedTermList() {
        return this.mFlattenedTerms;
    }

    private Pair<List<Term>, List<Integer>> flatten(TreeRun<HornClause, SsaInfo> treeRun, int n) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < treeRun.getChildren().size()) {
            TreeRun treeRun2 = (TreeRun)treeRun.getChildren().get(n2);
            Pair<List<Term>, List<Integer>> pair = this.flatten((TreeRun<HornClause, SsaInfo>)treeRun2, n + n2);
            arrayList.addAll((Collection)pair.getFirst());
            arrayList2.addAll((Collection)pair.getSecond());
            ++n2;
        }
        if (treeRun.getRootSymbol() != null) {
            arrayList.add(((SsaInfo)treeRun.getRoot()).getSsaFormula());
            arrayList2.add(n);
            this.getCounter(((SsaInfo)treeRun.getRoot()).getSsaFormula());
        }
        return new Pair(arrayList, arrayList2);
    }

    public TreeRun<HornClause, SsaInfo> getFormulasTree() {
        return this.mNestedFormulas;
    }

    public Term[] getNamedTermList(ManagedScript managedScript, Object object) {
        Term[] termArray = new Term[this.mFlattenedTerms.length];
        int n = 0;
        while (n < this.mFlattenedTerms.length) {
            termArray[n] = managedScript.term(object, this.getName(this.mFlattenedTerms[n]), new Term[0]);
            ++n;
        }
        return termArray;
    }

    public int[] getStartsOfSubTrees() {
        return this.mStartsOfSubtrees;
    }
}

