/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.function.Function;

public class ConditionTransformingIndependenceRelation<S, T, L>
implements IIndependenceRelation<S, L> {
    private final IIndependenceRelation<T, L> mUnderlying;
    private final Function<S, T> mTransformer;
    private final Function<T, S> mBackTransformer;
    private final boolean mConditional;
    private final IndependenceStatisticsDataProvider mStatistics;

    public ConditionTransformingIndependenceRelation(IIndependenceRelation<T, L> iIndependenceRelation, Function<S, T> function) {
        this(iIndependenceRelation, function, null);
    }

    public ConditionTransformingIndependenceRelation(IIndependenceRelation<T, L> iIndependenceRelation, Function<S, T> function, Function<T, S> function2) {
        this(iIndependenceRelation, function, function2, iIndependenceRelation.isConditional());
    }

    private ConditionTransformingIndependenceRelation(IIndependenceRelation<T, L> iIndependenceRelation, Function<S, T> function, Function<T, S> function2, boolean bl) {
        this.mUnderlying = iIndependenceRelation;
        this.mTransformer = function;
        this.mBackTransformer = function2;
        this.mConditional = bl;
        this.mStatistics = new IndependenceStatisticsDataProvider(ConditionTransformingIndependenceRelation.class, iIndependenceRelation);
    }

    @Override
    public boolean isSymmetric() {
        return this.mUnderlying.isSymmetric();
    }

    @Override
    public boolean isConditional() {
        return this.mConditional;
    }

    @Override
    public IIndependenceRelation.Dependence isIndependent(S s, L l, L l2) {
        Object STATE = s == null ? null : (Object)this.mTransformer.apply(s);
        IIndependenceRelation.Dependence dependence = this.mUnderlying.isIndependent(STATE, l, l2);
        this.mStatistics.reportQuery(dependence, STATE != null);
        return dependence;
    }

    @Override
    public ISymbolicIndependenceRelation<L, S> getSymbolicRelation() {
        if (!this.mConditional || this.mBackTransformer == null) {
            return null;
        }
        ISymbolicIndependenceRelation<L, T> iSymbolicIndependenceRelation = this.mUnderlying.getSymbolicRelation();
        if (iSymbolicIndependenceRelation == null) {
            return null;
        }
        return new SymbolicConditionTransformingIndependence(iSymbolicIndependenceRelation);
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    public static <S, L> IIndependenceRelation<S, L> unconditional(IIndependenceRelation<?, L> iIndependenceRelation) {
        return new ConditionTransformingIndependenceRelation<Object, Object, L>(iIndependenceRelation, object -> null, null, false);
    }

    private class SymbolicConditionTransformingIndependence
    implements ISymbolicIndependenceRelation<L, S> {
        private final ISymbolicIndependenceRelation<L, T> mUnderlyingSymbolic;

        public SymbolicConditionTransformingIndependence(ISymbolicIndependenceRelation<L, T> iSymbolicIndependenceRelation) {
            this.mUnderlyingSymbolic = iSymbolicIndependenceRelation;
        }

        @Override
        public S getCommutativityCondition(S s, L l, L l2) {
            Object CONDITION = !this.isConditional() || s == null ? null : (Object)ConditionTransformingIndependenceRelation.this.mTransformer.apply(s);
            Object t = this.mUnderlyingSymbolic.getCommutativityCondition(CONDITION, l, l2);
            if (t == null) {
                return null;
            }
            return ConditionTransformingIndependenceRelation.this.mBackTransformer.apply(t);
        }

        @Override
        public boolean isSymmetric() {
            return this.mUnderlyingSymbolic.isSymmetric();
        }

        @Override
        public boolean isConditional() {
            return ConditionTransformingIndependenceRelation.this.mConditional && this.mUnderlyingSymbolic.isConditional();
        }
    }
}

