/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityAnalysisResultProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityProvidingIntermediateState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityProvidingState;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.AbstractInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation.Activator;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbsIntEqualityProvider
implements IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private Map<IcfgLocation, Set<IEqualityProvidingState>> mLoc2States;
    private IEqualityProvidingState mTopState;
    private IEqualityProvidingState mBotState;
    private boolean mPreprocessed;
    private final Set<IProgramConst> mAdditionalLiterals;
    private List<String> mTrackedArrays;
    private ICsvProviderProvider<Object> mAbsIntBenchmark;

    public AbsIntEqualityProvider(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mAdditionalLiterals = new HashSet<IProgramConst>();
    }

    public void announceAdditionalLiterals(Collection<IProgramConst> collection) {
        this.mAdditionalLiterals.addAll(collection);
    }

    public void setTrackedArrays(List<String> list) {
        this.mTrackedArrays = list;
    }

    public void preprocess(IIcfg<?> iIcfg) {
        IProgressMonitorService iProgressMonitorService = this.mServices.getProgressMonitorService();
        IAbstractInterpretationResult iAbstractInterpretationResult = AbstractInterpreter.runFutureEqualityDomain(iIcfg, (IProgressAwareTimer)iProgressMonitorService, (IUltimateServiceProvider)this.mServices, (boolean)true, (ILogger)this.mLogger, this.mAdditionalLiterals, this.mTrackedArrays);
        Map map = iAbstractInterpretationResult.getLoc2States();
        this.mTopState = (IEqualityProvidingState)iAbstractInterpretationResult.getUsedDomain().createTopState();
        this.mBotState = (IEqualityProvidingState)iAbstractInterpretationResult.getUsedDomain().createBottomState();
        this.mAbsIntBenchmark = iAbstractInterpretationResult.getBenchmark();
        this.mLoc2States = map;
        assert (this.mLoc2States != null) : "There was no AbsInt result";
        assert (!this.mPreprocessed);
        this.mPreprocessed = true;
    }

    public EqualityAnalysisResult getAnalysisResult(IcfgLocation icfgLocation, Set<Doubleton<Term>> set) {
        assert (this.mPreprocessed);
        Set<IEqualityProvidingState> set2 = this.mLoc2States.get(icfgLocation);
        if (set2 == null) {
            return new EqualityAnalysisResult(set);
        }
        HashSet<Doubleton<Term>> hashSet = new HashSet<Doubleton<Term>>();
        HashSet<Doubleton<Term>> hashSet2 = new HashSet<Doubleton<Term>>();
        HashSet<Doubleton<Term>> hashSet3 = new HashSet<Doubleton<Term>>();
        for (Doubleton<Term> doubleton : set) {
            if (set2.stream().allMatch(iEqualityProvidingState -> iEqualityProvidingState.areEqual((Term)doubleton.getOneElement(), (Term)doubleton.getOtherElement()))) {
                hashSet.add(doubleton);
                continue;
            }
            if (set2.stream().allMatch(iEqualityProvidingState -> iEqualityProvidingState.areUnequal((Term)doubleton.getOneElement(), (Term)doubleton.getOtherElement()))) {
                hashSet2.add(doubleton);
                continue;
            }
            hashSet3.add(doubleton);
        }
        return new EqualityAnalysisResult(hashSet, hashSet2, hashSet3);
    }

    public IEqualityProvidingState getEqualityProvidingStateForLocationSet(Set<IcfgLocation> set) {
        assert (this.mPreprocessed);
        IEqualityProvidingState iEqualityProvidingState3 = null;
        for (IcfgLocation icfgLocation : set) {
            if (!this.mLoc2States.containsKey(icfgLocation)) continue;
            IEqualityProvidingState iEqualityProvidingState4 = (IEqualityProvidingState)this.mLoc2States.get(icfgLocation).stream().reduce((iEqualityProvidingState, iEqualityProvidingState2) -> iEqualityProvidingState.join(iEqualityProvidingState2)).get();
            IEqualityProvidingState iEqualityProvidingState5 = iEqualityProvidingState3 = iEqualityProvidingState3 == null ? iEqualityProvidingState4 : iEqualityProvidingState3.join(iEqualityProvidingState4);
        }
        if (iEqualityProvidingState3 == null) {
            iEqualityProvidingState3 = this.mBotState;
        }
        assert (iEqualityProvidingState3 != null);
        return iEqualityProvidingState3;
    }

    public IEqualityProvidingIntermediateState getEqualityProvidingIntermediateState(IcfgEdge icfgEdge) {
        EqState eqState = (EqState)this.getEqualityProvidingStateForLocationSet(Collections.singleton((IcfgLocation)icfgEdge.getSource()));
        return eqState.getIntermediateStateForOutgoingEdge(icfgEdge);
    }

    public ICsvProviderProvider<Object> getAbsIntBenchmark() {
        return this.mAbsIntBenchmark;
    }
}

