/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.SimpleLoop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.Tools;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoopExtraction<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final ManagedScript mMgScript;
    private final Deque<SimpleLoop> mLoops;
    private final List<INLOC> mLoopHeads;

    public LoopExtraction(ILogger iLogger, IIcfg<INLOC> iIcfg) {
        this.mLogger = iLogger;
        this.mOriginalIcfg = iIcfg;
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        this.mMgScript = cfgSmtToolkit.getManagedScript();
        this.mLoops = new ArrayDeque<SimpleLoop>();
        this.mLoopHeads = this.getLoopHeads();
        for (IcfgLocation icfgLocation : this.mLoopHeads) {
            Deque<IcfgEdge> deque = this.getLoopPath(icfgLocation);
            if (deque.isEmpty()) continue;
            List<Map.Entry<UnmodifiableTransFormula, IcfgLocation>> list = this.findAllExits(icfgLocation, deque);
            UnmodifiableTransFormula unmodifiableTransFormula = this.pathToTransformula(deque);
            if (unmodifiableTransFormula.getAssignedVars().isEmpty()) continue;
            this.mLoops.addLast(new SimpleLoop(unmodifiableTransFormula, icfgLocation, list));
        }
    }

    private List<Map.Entry<UnmodifiableTransFormula, IcfgLocation>> findAllExits(INLOC INLOC, Deque<IcfgEdge> deque) {
        Object object;
        IcfgEdge icfgEdge2;
        ArrayList<Map.Entry<UnmodifiableTransFormula, IcfgLocation>> arrayList = new ArrayList<Map.Entry<UnmodifiableTransFormula, IcfgLocation>>();
        for (IcfgEdge icfgEdge2 : INLOC.getOutgoingEdges()) {
            if (icfgEdge2.getTransformula().equals(deque.getFirst().getTransformula())) continue;
            object = new AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation>(Tools.negateUnmodifiableTransFormula(this.mMgScript, icfgEdge2.getTransformula()), (IcfgLocation)icfgEdge2.getTarget());
            arrayList.add((Map.Entry<UnmodifiableTransFormula, IcfgLocation>)object);
        }
        icfgEdge2 = Tools.cloneDeque(deque);
        icfgEdge2.removeLast();
        ArrayDeque arrayDeque = new ArrayDeque();
        while (!icfgEdge2.isEmpty()) {
            object = (IcfgEdge)icfgEdge2.pop();
            for (IcfgEdge icfgEdge3 : ((IcfgLocation)object.getTarget()).getOutgoingEdges()) {
                if (!deque.contains(icfgEdge3)) {
                    AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation> simpleEntry;
                    if (!arrayDeque.isEmpty()) {
                        Deque<IcfgEdge> deque2 = Tools.cloneDeque(arrayDeque);
                        UnmodifiableTransFormula unmodifiableTransFormula = this.pathToTransformula(deque2);
                        UnmodifiableTransFormula unmodifiableTransFormula2 = this.instertFormula(Tools.negateUnmodifiableTransFormula(this.mMgScript, icfgEdge3.getTransformula()), unmodifiableTransFormula);
                        simpleEntry = new AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation>(unmodifiableTransFormula2, (IcfgLocation)icfgEdge3.getTarget());
                    } else {
                        simpleEntry = new AbstractMap.SimpleEntry<UnmodifiableTransFormula, IcfgLocation>(Tools.negateUnmodifiableTransFormula(this.mMgScript, icfgEdge3.getTransformula()), (IcfgLocation)icfgEdge3.getTarget());
                    }
                    arrayList.add(simpleEntry);
                    continue;
                }
                arrayDeque.add(icfgEdge3);
            }
        }
        return arrayList;
    }

    private UnmodifiableTransFormula instertFormula(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
        Term term;
        IProgramVar iProgramVar2;
        Script script = this.mMgScript.getScript();
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (IProgramVar iProgramVar2 : unmodifiableTransFormula.getInVars().keySet()) {
            if (!unmodifiableTransFormula2.getOutVars().containsKey(iProgramVar2)) continue;
            term = script.term("+", new Term[]{(Term)unmodifiableTransFormula2.getInVars().values().iterator().next(), Rational.ONE.toTerm(script.sort("Int", new Sort[0]))});
            hashMap.put((Term)unmodifiableTransFormula.getInVars().get(iProgramVar2), term);
        }
        iProgramVar2 = Substitution.apply((ManagedScript)this.mMgScript, hashMap, (Term)unmodifiableTransFormula.getFormula());
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula2.getInVars(), unmodifiableTransFormula2.getInVars(), false, unmodifiableTransFormula.getNonTheoryConsts(), true, (Collection)unmodifiableTransFormula.getBranchEncoders(), true);
        transFormulaBuilder.setFormula((Term)iProgramVar2);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        transFormulaBuilder.finishConstruction(this.mMgScript);
        term = transFormulaBuilder.finishConstruction(this.mMgScript);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"-------------------------");
            this.mLogger.debug((Object)("mainFormula : " + String.valueOf(unmodifiableTransFormula)));
            this.mLogger.debug((Object)("substituteFormula : " + String.valueOf(unmodifiableTransFormula2)));
            this.mLogger.debug((Object)("subsitute : " + String.valueOf(hashMap)));
            this.mLogger.debug((Object)("finalFormula : " + String.valueOf(term)));
            this.mLogger.debug((Object)"-------------------------");
        }
        return term;
    }

    public Deque<SimpleLoop> getLoopTransFormulas() {
        return this.mLoops;
    }

    private Deque<IcfgEdge> getLoopPath(INLOC INLOC) {
        Deque<Object> deque = new ArrayDeque<IcfgEdge>();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.addFirst(INLOC);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(INLOC);
        HashMap<Object, Deque<Object>> hashMap = new HashMap<Object, Deque<Object>>();
        hashMap.put(INLOC, new ArrayDeque());
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
                if (this.mLoopHeads.contains(icfgLocation2) && !icfgLocation2.equals(INLOC)) continue;
                if (icfgLocation2.equals(INLOC) && deque.isEmpty()) {
                    ((Deque)hashMap.get(icfgLocation)).addLast(icfgEdge);
                    deque = (Deque)hashMap.get(icfgLocation);
                    continue;
                }
                if (icfgLocation2.equals(INLOC) && arrayList.contains(icfgLocation2)) {
                    return new ArrayDeque<IcfgEdge>();
                }
                arrayList.add(icfgLocation2);
                arrayDeque.addLast(icfgLocation2);
                Deque deque2 = Tools.cloneDeque((Deque)hashMap.get(icfgLocation));
                deque2.addLast(icfgEdge);
                hashMap.put(icfgLocation2, deque2);
            }
        }
        return deque;
    }

    private UnmodifiableTransFormula pathToTransformula(Deque<IcfgEdge> deque) {
        if (deque.size() == 1) {
            return deque.getFirst().getTransformula();
        }
        UnmodifiableTransFormula unmodifiableTransFormula = this.joinTransFormula(deque.removeFirst().getTransformula(), deque.removeFirst().getTransformula());
        for (IcfgEdge icfgEdge : deque) {
            unmodifiableTransFormula = this.joinTransFormula(unmodifiableTransFormula, icfgEdge.getTransformula());
        }
        return unmodifiableTransFormula;
    }

    private UnmodifiableTransFormula joinTransFormula(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
        Map.Entry entry2;
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>(unmodifiableTransFormula.getInVars());
        for (Map.Entry entry2 : unmodifiableTransFormula2.getInVars().entrySet()) {
            if (hashMap2.containsKey(entry2.getKey())) continue;
            hashMap2.put((IProgramVar)entry2.getKey(), (TermVariable)entry2.getValue());
        }
        entry2 = new HashMap(unmodifiableTransFormula2.getOutVars());
        for (Map.Entry entry3 : unmodifiableTransFormula.getOutVars().entrySet()) {
            if (entry2.containsKey(entry3.getKey())) continue;
            entry2.put((IProgramVar)entry3.getKey(), (TermVariable)entry3.getValue());
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getOutVars().keySet()) {
            if (!unmodifiableTransFormula2.getInVars().containsKey(iProgramVar)) continue;
            hashMap.put((Term)unmodifiableTransFormula2.getInVars().get(iProgramVar), (Term)unmodifiableTransFormula.getOutVars().get(iProgramVar));
            if (!((TermVariable)unmodifiableTransFormula2.getInVars().get(iProgramVar)).equals(unmodifiableTransFormula2.getOutVars().get(iProgramVar))) continue;
            entry2.put(iProgramVar, (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVar));
        }
        HashSet hashSet = new HashSet(unmodifiableTransFormula.getNonTheoryConsts());
        hashSet.addAll(unmodifiableTransFormula2.getNonTheoryConsts());
        Iterator iterator = Substitution.apply((ManagedScript)this.mMgScript, hashMap, (Term)unmodifiableTransFormula2.getFormula());
        Term term = this.mMgScript.getScript().term("and", new Term[]{unmodifiableTransFormula.getFormula(), iterator});
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(hashMap2, (Map)((Object)entry2), false, hashSet, true, null, false);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(this.mMgScript);
    }

    private List<INLOC> getLoopHeads() {
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        ArrayList arrayList2 = new ArrayList(this.mOriginalIcfg.getInitialNodes());
        while (!arrayList2.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayList2.remove(0);
            if (hashSet.contains(icfgLocation)) {
                arrayList.add(icfgLocation);
            } else {
                icfgLocation.getOutgoingEdges().forEach(icfgEdge -> {
                    if (!arrayList2.contains(icfgEdge.getTarget())) {
                        arrayList2.add((IcfgLocation)icfgEdge.getTarget());
                    }
                });
            }
            hashSet.add(icfgLocation);
        }
        return arrayList;
    }
}

