/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanDecomposition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.RationalMatrix;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class QuadraticMatrix {
    private final int mDimension;
    private final BigInteger[][] mEntries;

    public QuadraticMatrix(BigInteger[][] bigIntegerArray) {
        int n = bigIntegerArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (n != bigIntegerArray[n2].length) {
                throw new AssertionError((Object)"Some matrix is not quadratic");
            }
            ++n2;
        }
        this.mEntries = bigIntegerArray;
        this.mDimension = n;
    }

    public static QuadraticMatrix constructIdentityMatrix(int n) {
        BigInteger[][] bigIntegerArray = new BigInteger[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                bigIntegerArray[n2][n3] = n2 == n3 ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
                ++n3;
            }
            ++n2;
        }
        QuadraticMatrix quadraticMatrix = new QuadraticMatrix(bigIntegerArray);
        return quadraticMatrix;
    }

    public static QuadraticMatrix constructZeroMatrix(int n) {
        BigInteger[][] bigIntegerArray = new BigInteger[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                bigIntegerArray[n2][n3] = BigInteger.valueOf(0L);
                ++n3;
            }
            ++n2;
        }
        QuadraticMatrix quadraticMatrix = new QuadraticMatrix(bigIntegerArray);
        return quadraticMatrix;
    }

    public static QuadraticMatrix copyMatrix(QuadraticMatrix quadraticMatrix) {
        int n = quadraticMatrix.mDimension;
        BigInteger[][] bigIntegerArray = new BigInteger[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                bigIntegerArray[n2][n3] = quadraticMatrix.mEntries[n2][n3];
                ++n3;
            }
            ++n2;
        }
        QuadraticMatrix quadraticMatrix2 = new QuadraticMatrix(bigIntegerArray);
        return quadraticMatrix2;
    }

    public static QuadraticMatrix addition(QuadraticMatrix quadraticMatrix, QuadraticMatrix quadraticMatrix2) {
        if (quadraticMatrix.mDimension != quadraticMatrix2.mDimension) {
            throw new AssertionError((Object)"Some matrices for addition are not of the same dimension.");
        }
        int n = quadraticMatrix.mDimension;
        BigInteger[][] bigIntegerArray = new BigInteger[n][n];
        QuadraticMatrix quadraticMatrix3 = new QuadraticMatrix(bigIntegerArray);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                quadraticMatrix3.mEntries[n2][n3] = quadraticMatrix.mEntries[n2][n3].add(quadraticMatrix2.mEntries[n2][n3]);
                ++n3;
            }
            ++n2;
        }
        return quadraticMatrix3;
    }

    public static QuadraticMatrix scalarMultiplication(BigInteger bigInteger, QuadraticMatrix quadraticMatrix) {
        int n = quadraticMatrix.mDimension;
        BigInteger[][] bigIntegerArray = new BigInteger[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                bigIntegerArray[n2][n3] = bigInteger.multiply(quadraticMatrix.mEntries[n2][n3]);
                ++n3;
            }
            ++n2;
        }
        QuadraticMatrix quadraticMatrix2 = new QuadraticMatrix(bigIntegerArray);
        return quadraticMatrix2;
    }

    public static QuadraticMatrix multiplication(QuadraticMatrix quadraticMatrix, QuadraticMatrix quadraticMatrix2) {
        if (quadraticMatrix.mDimension != quadraticMatrix2.mDimension) {
            throw new AssertionError((Object)"Some matrices for multiplication are not of the same dimension");
        }
        int n = quadraticMatrix.mDimension;
        QuadraticMatrix quadraticMatrix3 = QuadraticMatrix.constructZeroMatrix(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n) {
                    quadraticMatrix3.mEntries[n2][n3] = quadraticMatrix3.mEntries[n2][n3].add(quadraticMatrix.mEntries[n2][n4].multiply(quadraticMatrix2.mEntries[n4][n3]));
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return quadraticMatrix3;
    }

    public static QuadraticMatrix power(QuadraticMatrix quadraticMatrix, int n) {
        int n2 = quadraticMatrix.mDimension;
        if (n == 0) {
            return QuadraticMatrix.constructIdentityMatrix(n2);
        }
        if (n == 1) {
            return quadraticMatrix;
        }
        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.copyMatrix(quadraticMatrix);
        int n3 = 2;
        while (n3 <= n) {
            quadraticMatrix2 = QuadraticMatrix.multiplication(quadraticMatrix2, quadraticMatrix);
            ++n3;
        }
        return quadraticMatrix2;
    }

    public BigInteger computeDet() {
        int n = this.mDimension;
        if (n == 1) {
            return this.mEntries[0][0];
        }
        if (n == 1) {
            return this.mEntries[0][0].multiply(this.mEntries[1][1]).subtract(this.mEntries[0][1].multiply(this.mEntries[1][0]));
        }
        if (n == 3) {
            return this.mEntries[0][0].multiply(this.mEntries[1][1]).multiply(this.mEntries[2][2]).add(this.mEntries[0][1].multiply(this.mEntries[1][2]).multiply(this.mEntries[2][0])).add(this.mEntries[0][2].multiply(this.mEntries[1][0]).multiply(this.mEntries[2][1])).subtract(this.mEntries[2][0].multiply(this.mEntries[1][1]).multiply(this.mEntries[0][2])).subtract(this.mEntries[2][1].multiply(this.mEntries[1][2]).multiply(this.mEntries[0][0])).subtract(this.mEntries[2][2].multiply(this.mEntries[1][0]).multiply(this.mEntries[0][1]));
        }
        BigInteger bigInteger = BigInteger.valueOf(0L);
        int n2 = 0;
        while (n2 < n) {
            BigInteger[][] bigIntegerArray = new BigInteger[n - 1][n - 1];
            int n3 = 0;
            while (n3 < n - 1) {
                int n4 = 0;
                while (n4 < n2) {
                    bigIntegerArray[n3][n4] = this.mEntries[n3][n4];
                    ++n4;
                }
                n4 = n2 + 1;
                while (n4 < n) {
                    bigIntegerArray[n3][n4 - 1] = this.mEntries[n3][n4];
                    ++n4;
                }
                ++n3;
            }
            QuadraticMatrix quadraticMatrix = new QuadraticMatrix(bigIntegerArray);
            bigInteger = (n + n2 - 1) % 2 == 0 ? bigInteger.add(this.mEntries[n - 1][n2].multiply(quadraticMatrix.computeDet())) : bigInteger.subtract(this.mEntries[n - 1][n2].multiply(quadraticMatrix.computeDet()));
            ++n2;
        }
        return bigInteger;
    }

    public static RationalMatrix computeInverse(QuadraticMatrix quadraticMatrix) {
        int n = quadraticMatrix.mDimension;
        if (quadraticMatrix.computeDet().equals(BigInteger.valueOf(0L))) {
            throw new AssertionError((Object)"Matrix is not invertible");
        }
        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.constructZeroMatrix(n);
        RationalMatrix rationalMatrix = new RationalMatrix(BigInteger.valueOf(1L), quadraticMatrix2);
        int n2 = 0;
        while (n2 < n) {
            BigInteger[][] bigIntegerArray = new BigInteger[n + 1][n + 1];
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n) {
                    bigIntegerArray[n3][n4] = quadraticMatrix.mEntries[n3][n4];
                    ++n4;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                bigIntegerArray[n3][n] = n3 == n2 ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                bigIntegerArray[n][n3] = BigInteger.valueOf(0L);
                ++n3;
            }
            bigIntegerArray[n][n] = BigInteger.valueOf(1L);
            QuadraticMatrix quadraticMatrix3 = new QuadraticMatrix(bigIntegerArray);
            QuadraticMatrix quadraticMatrix4 = QuadraticMatrix.gaussElimination(quadraticMatrix3);
            Rational[] rationalArray = QuadraticMatrix.backwardSubstitution(quadraticMatrix4, 1);
            rationalMatrix.addColumnToMatrix(n2, rationalArray);
            ++n2;
        }
        return rationalMatrix;
    }

    public boolean[] computeSmallEigenvalues() {
        boolean[] blArray = new boolean[3];
        int n = 0;
        while (n < 3) {
            blArray[n] = false;
            ++n;
        }
        n = this.mDimension;
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.constructIdentityMatrix(n);
        int n2 = -1;
        while (n2 < 2) {
            if (QuadraticMatrix.addition(this, QuadraticMatrix.scalarMultiplication(BigInteger.valueOf(-n2), quadraticMatrix)).computeDet().equals(BigInteger.valueOf(0L))) {
                blArray[n2 + 1] = true;
            }
            ++n2;
        }
        return blArray;
    }

    public void swapRows(int n, int n2) {
        int n3 = this.mDimension;
        BigInteger[] bigIntegerArray = new BigInteger[n3];
        int n4 = 0;
        while (n4 < n3) {
            bigIntegerArray[n4] = this.mEntries[n][n4];
            this.mEntries[n][n4] = this.mEntries[n2][n4];
            this.mEntries[n2][n4] = bigIntegerArray[n4];
            ++n4;
        }
    }

    public static QuadraticMatrix gaussElimination(QuadraticMatrix quadraticMatrix) {
        int n;
        Object object;
        Object object2;
        int n2;
        int n3 = quadraticMatrix.mDimension;
        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.copyMatrix(quadraticMatrix);
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3 && n5 < n3) {
            n2 = n4;
            int n6 = n4;
            while (n6 < n3) {
                if (quadraticMatrix2.mEntries[n6][n5].abs().compareTo(quadraticMatrix2.mEntries[n2][n5].abs()) > 0) {
                    n2 = n6;
                }
                ++n6;
            }
            if (quadraticMatrix2.mEntries[n2][n5].equals(BigInteger.valueOf(0L))) {
                ++n5;
                continue;
            }
            quadraticMatrix2.swapRows(n4, n2);
            n6 = n4 + 1;
            while (n6 < n3) {
                object2 = BigInteger.valueOf(0L);
                object = BigInteger.valueOf(0L);
                BigInteger bigInteger = BigInteger.valueOf(0L);
                object2 = quadraticMatrix2.mEntries[n6][n5];
                object = quadraticMatrix2.mEntries[n4][n5];
                bigInteger = Rational.gcd((BigInteger)object2, (BigInteger)object);
                object2 = ((BigInteger)object2).divide(bigInteger);
                object = ((BigInteger)object).divide(bigInteger);
                quadraticMatrix2.mEntries[n6][n5] = BigInteger.valueOf(0L);
                n = n5 + 1;
                while (n < n3) {
                    quadraticMatrix2.mEntries[n6][n] = ((BigInteger)object).multiply(quadraticMatrix2.mEntries[n6][n]).subtract(((BigInteger)object2).multiply(quadraticMatrix2.mEntries[n4][n]));
                    ++n;
                }
                ++n6;
            }
            ++n4;
            ++n5;
        }
        n2 = 1;
        while (n2 < n3) {
            BigInteger[][] bigIntegerArray = new BigInteger[n3 - n2][n3 - n2];
            int n7 = 0;
            while (n7 < n3 - n2) {
                int n8 = 0;
                while (n8 < n3 - n2) {
                    bigIntegerArray[n7][n8] = quadraticMatrix2.mEntries[n7 + n2][n8 + n2];
                    ++n8;
                }
                ++n7;
            }
            object2 = new QuadraticMatrix(bigIntegerArray);
            object = QuadraticMatrix.gaussElimination((QuadraticMatrix)object2);
            int n9 = 0;
            while (n9 < n3 - n2) {
                n = 0;
                while (n < n3 - n2) {
                    quadraticMatrix2.mEntries[n9 + n2][n + n2] = ((QuadraticMatrix)object).mEntries[n9][n];
                    ++n;
                }
                ++n9;
            }
            ++n2;
        }
        return quadraticMatrix2;
    }

    public static Rational[] backwardSubstitution(QuadraticMatrix quadraticMatrix, int n) {
        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.copyMatrix(quadraticMatrix);
        int n2 = quadraticMatrix2.mDimension;
        if (!quadraticMatrix2.mEntries[quadraticMatrix2.computeRank() - 1][n2 - 1].equals(BigInteger.valueOf(1L))) {
            throw new AssertionError((Object)"LES unsolvable.");
        }
        Rational[] rationalArray = new Rational[n2 - 1];
        int n3 = n2 - 2;
        int n4 = 0;
        while (n4 < n2 - 1) {
            rationalArray[n4] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
            ++n4;
        }
        n4 = 0;
        int n5 = quadraticMatrix2.computeRank() - 2;
        while (n5 >= 0) {
            int n6 = n5;
            int n7 = n5;
            while (n7 < n2) {
                if (!quadraticMatrix2.mEntries[n5][n7].equals(BigInteger.valueOf(0L))) {
                    n6 = n7;
                    break;
                }
                ++n7;
            }
            while (n6 < n3) {
                if (++n4 == n) {
                    rationalArray[n3] = Rational.valueOf((BigInteger)BigInteger.valueOf(1L), (BigInteger)BigInteger.valueOf(1L));
                }
                --n3;
            }
            n3 = n6 - 1;
            rationalArray[n6] = Rational.valueOf((BigInteger)quadraticMatrix2.mEntries[n5][n2 - 1], (BigInteger)BigInteger.valueOf(1L));
            n7 = n6 + 1;
            while (n7 < n2 - 1) {
                Rational rational = Rational.valueOf((BigInteger)quadraticMatrix2.mEntries[n5][n7].negate().multiply(rationalArray[n7].numerator()), (BigInteger)rationalArray[n7].denominator());
                rationalArray[n6] = rationalArray[n6].add(rational);
                rationalArray[n6] = Rational.valueOf((BigInteger)rationalArray[n6].numerator(), (BigInteger)rationalArray[n6].denominator());
                ++n7;
            }
            rationalArray[n6] = Rational.valueOf((BigInteger)rationalArray[n6].numerator(), (BigInteger)rationalArray[n6].denominator().multiply(quadraticMatrix2.mEntries[n5][n6]));
            --n5;
        }
        while (n3 > -1) {
            if (++n4 == n) {
                rationalArray[n3] = Rational.valueOf((BigInteger)BigInteger.valueOf(1L), (BigInteger)BigInteger.valueOf(1L));
            }
            --n3;
        }
        return rationalArray;
    }

    public int computeRank() {
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.copyMatrix(this);
        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.gaussElimination(quadraticMatrix);
        int n = quadraticMatrix2.mDimension;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n) {
                if (!quadraticMatrix2.mEntries[n3][n4].equals(BigInteger.valueOf(0L))) break;
                if (n4 == n - 1 && quadraticMatrix2.mEntries[n3][n4].equals(BigInteger.valueOf(0L))) {
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
        return n - n2;
    }

    public int computeGeometricMultiplicity(int n) {
        int n2 = this.mDimension;
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.constructIdentityMatrix(n2);
        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.addition(this, QuadraticMatrix.scalarMultiplication(BigInteger.valueOf(-n), quadraticMatrix));
        return n2 - quadraticMatrix2.computeRank();
    }

    public int computeNumberOfBlocks(int n, int n2) {
        int n3 = this.mDimension;
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.constructIdentityMatrix(n3);
        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.addition(this, QuadraticMatrix.scalarMultiplication(BigInteger.valueOf(-n), quadraticMatrix));
        return 2 * QuadraticMatrix.power(quadraticMatrix2, n2).computeGeometricMultiplicity(0) - QuadraticMatrix.power(quadraticMatrix2, n2 + 1).computeGeometricMultiplicity(0) - QuadraticMatrix.power(quadraticMatrix2, n2 - 1).computeGeometricMultiplicity(0);
    }

    public static QuadraticMatrix createJordanBlock(int n, int n2) {
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.constructZeroMatrix(n2);
        int n3 = 0;
        while (n3 < n2) {
            quadraticMatrix.mEntries[n3][n3] = BigInteger.valueOf(n);
            if (n3 != n2 - 1) {
                quadraticMatrix.mEntries[n3][n3 + 1] = BigInteger.valueOf(1L);
            }
            ++n3;
        }
        return quadraticMatrix;
    }

    public void addJordanBlock(QuadraticMatrix quadraticMatrix, int n) {
        if (this.mDimension < quadraticMatrix.mDimension + n) {
            throw new AssertionError((Object)"Block does not fit into Jordan matrix");
        }
        int n2 = quadraticMatrix.mDimension;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n2) {
                this.mEntries[n3 + n][n4 + n] = quadraticMatrix.mEntries[n3][n4];
                ++n4;
            }
            ++n3;
        }
    }

    private NestedMap2<Integer, Integer, Integer> computeJordanBlockSizes() {
        NestedMap2 nestedMap2 = new NestedMap2();
        boolean[] blArray = this.computeSmallEigenvalues();
        int n = this.mDimension;
        int n2 = -1;
        while (n2 <= 1) {
            if (blArray[n2 + 1]) {
                int n3;
                int n4 = this.computeGeometricMultiplicity(n2);
                int[] nArray = new int[n + 1];
                int n5 = 0;
                while (n5 < n4) {
                    n3 = 1;
                    while (n3 <= n) {
                        nArray[n3] = this.computeNumberOfBlocks(n2, n3);
                        n5 += nArray[n3];
                        ++n3;
                    }
                }
                n3 = 1;
                while (n3 <= n) {
                    if (nArray[n3] != 0) {
                        nestedMap2.put((Object)n2, (Object)n3, (Object)nArray[n3]);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return nestedMap2;
    }

    public JordanDecomposition constructJordanDecomposition() {
        JordanDecomposition jordanDecomposition;
        int n = this.mDimension;
        if (n >= 11) {
            throw new UnsupportedOperationException("Vector space has " + n + " dimensions. Computation of eigenvalues may not terminate.");
        }
        QuadraticMatrix quadraticMatrix = QuadraticMatrix.constructZeroMatrix(n);
        NestedMap2<Integer, Integer, Integer> nestedMap2 = this.computeJordanBlockSizes();
        int n2 = 0;
        int n3 = -1;
        while (n3 <= 1) {
            if (nestedMap2.get((Object)n3) != null) {
                for (Object object : nestedMap2.get((Object)n3).keySet()) {
                    if (object == null) continue;
                    int n4 = 1;
                    while (n4 <= (Integer)nestedMap2.get((Object)n3, object)) {
                        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.createJordanBlock(n3, (Integer)object);
                        quadraticMatrix.addJordanBlock(quadraticMatrix2, n2);
                        n2 += ((Integer)object).intValue();
                        ++n4;
                    }
                }
            }
            ++n3;
        }
        if (n2 != n) {
            JordanDecomposition.JordanDecompositionStatus jordanDecompositionStatus = JordanDecomposition.JordanDecompositionStatus.UNSUPPORTED_EIGENVALUES;
            jordanDecomposition = new JordanDecomposition(jordanDecompositionStatus, null, null, null, null);
        } else {
            Object object;
            JordanDecomposition.JordanDecompositionStatus jordanDecompositionStatus = JordanDecomposition.JordanDecompositionStatus.SUCCESS;
            object = QuadraticMatrix.computeModalMatrix(this, quadraticMatrix);
            RationalMatrix rationalMatrix = RationalMatrix.computeInverse((RationalMatrix)object);
            assert (QuadraticMatrix.checkCorrectnessofJordanDecomposition(this, (RationalMatrix)object, quadraticMatrix, rationalMatrix));
            jordanDecomposition = new JordanDecomposition(jordanDecompositionStatus, quadraticMatrix, (RationalMatrix)object, rationalMatrix, nestedMap2);
        }
        return jordanDecomposition;
    }

    public static RationalMatrix constructLes(QuadraticMatrix quadraticMatrix, Rational[] rationalArray) {
        int n = quadraticMatrix.mDimension;
        QuadraticMatrix quadraticMatrix2 = QuadraticMatrix.constructZeroMatrix(n + 1);
        RationalMatrix rationalMatrix = new RationalMatrix(BigInteger.valueOf(1L), quadraticMatrix2);
        int n2 = 0;
        while (n2 < n) {
            Rational[] rationalArray2 = new Rational[n + 1];
            int n3 = 0;
            while (n3 < n) {
                rationalArray2[n3] = Rational.valueOf((BigInteger)quadraticMatrix.mEntries[n3][n2], (BigInteger)BigInteger.valueOf(1L));
                ++n3;
            }
            rationalArray2[n] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
            rationalMatrix.addColumnToMatrix(n2, rationalArray2);
            ++n2;
        }
        rationalMatrix.addColumnToMatrix(n, rationalArray);
        rationalMatrix.getIntMatrix().mEntries[n][n] = BigInteger.valueOf(1L);
        return rationalMatrix;
    }

    public static Rational[] matrixVectorMultiplication(QuadraticMatrix quadraticMatrix, Rational[] rationalArray) {
        if (quadraticMatrix.mDimension != rationalArray.length) {
            throw new AssertionError((Object)"Matrix dimension is not vector length.");
        }
        int n = quadraticMatrix.mDimension;
        Rational[] rationalArray2 = new Rational[n];
        int n2 = 0;
        while (n2 < n) {
            rationalArray2[n2] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
            int n3 = 0;
            while (n3 < n) {
                rationalArray2[n2] = rationalArray2[n2].add(Rational.valueOf((BigInteger)quadraticMatrix.mEntries[n2][n3].multiply(rationalArray[n3].numerator()), (BigInteger)rationalArray[n3].denominator()));
                ++n3;
            }
            ++n2;
        }
        return rationalArray2;
    }

    public static RationalMatrix computeModalMatrix(QuadraticMatrix quadraticMatrix, QuadraticMatrix quadraticMatrix2) {
        int n = quadraticMatrix.mDimension;
        QuadraticMatrix quadraticMatrix3 = QuadraticMatrix.constructZeroMatrix(n);
        RationalMatrix rationalMatrix = new RationalMatrix(BigInteger.valueOf(1L), quadraticMatrix3);
        HashMap hashMap = new HashMap();
        int n2 = n;
        Rational[] rationalArray = new Rational[n];
        int n3 = 0;
        while (n3 < n) {
            rationalArray[n3] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
            ++n3;
        }
        n3 = 1;
        while (n3 >= -1) {
            if (quadraticMatrix.computeSmallEigenvalues()[n3 + 1]) {
                Object object;
                QuadraticMatrix quadraticMatrix4 = QuadraticMatrix.addition(quadraticMatrix, QuadraticMatrix.scalarMultiplication(BigInteger.valueOf(-n3), QuadraticMatrix.constructIdentityMatrix(n)));
                int n4 = n;
                while (quadraticMatrix.computeNumberOfBlocks(n3, n4) == 0) {
                    --n4;
                }
                int n5 = 1;
                while (n5 <= n4) {
                    object = new ArrayList();
                    hashMap.put(n5, object);
                    ++n5;
                }
                while (n4 > 0) {
                    n5 = quadraticMatrix.computeNumberOfBlocks(n3, n4);
                    if (n5 == 0) {
                        --n4;
                        continue;
                    }
                    object = QuadraticMatrix.constructLes(QuadraticMatrix.power(quadraticMatrix4, n4), rationalArray);
                    ArrayList arrayList = (ArrayList)hashMap.get(n4);
                    int n6 = arrayList.size();
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    int n7 = 1;
                    while (n7 <= n) {
                        arrayList2.add(n7);
                        ++n7;
                    }
                    n7 = 0;
                    while (n7 < n5) {
                        int n8;
                        int n9;
                        Rational[][] rationalArray2 = new Rational[n6 + n5 - 1][n];
                        int n10 = 0;
                        while (n10 < n6) {
                            n9 = 0;
                            while (n9 < n) {
                                rationalArray2[n10][n9] = Rational.valueOf((BigInteger)rationalMatrix.getIntMatrix().mEntries[n9][(Integer)arrayList.get(n10)], (BigInteger)rationalMatrix.getDenominator());
                                ++n9;
                            }
                            ++n10;
                        }
                        n10 = n6;
                        while (n10 < n6 + n5 - 1) {
                            n9 = 0;
                            while (n9 < n) {
                                rationalArray2[n10][n9] = Rational.valueOf((BigInteger)BigInteger.valueOf(0L), (BigInteger)BigInteger.valueOf(1L));
                                ++n9;
                            }
                            ++n10;
                        }
                        n10 = 0;
                        n9 = 0;
                        QuadraticMatrix quadraticMatrix5 = QuadraticMatrix.power(quadraticMatrix4, n4 - 1);
                        Rational[] rationalArray3 = RationalMatrix.solveLes((RationalMatrix)object, rationalArray2, (Integer)arrayList2.get(n10));
                        while (n9 == 0) {
                            n8 = 0;
                            while (n8 < rationalArray3.length) {
                                Rational[] rationalArray4 = QuadraticMatrix.matrixVectorMultiplication(quadraticMatrix5, rationalArray3);
                                if (!rationalArray4[n8].equals((Object)Rational.ZERO)) {
                                    n9 = 1;
                                    arrayList2.remove(n10);
                                    break;
                                }
                                ++n8;
                            }
                            if (n8 != rationalArray3.length || n9 != 0) continue;
                            rationalArray3 = RationalMatrix.solveLes((RationalMatrix)object, rationalArray2, (Integer)arrayList2.get(++n10));
                        }
                        rationalMatrix.addColumnToMatrix(n2 - n7 * n4 - 1, rationalArray3);
                        ((ArrayList)hashMap.get(n4)).add(n2 - n7 * n4 - 1);
                        n8 = n4 - 1;
                        while (n8 > 0) {
                            rationalArray3 = QuadraticMatrix.matrixVectorMultiplication(quadraticMatrix4, rationalArray3);
                            rationalMatrix.addColumnToMatrix(n2 - n7 * n4 - n4 + n8 - 1, rationalArray3);
                            ((ArrayList)hashMap.get(n8)).add(n2 - n7 * n4 - n4 + n8 - 1);
                            --n8;
                        }
                        ++n7;
                    }
                    n2 -= n5 * n4;
                    --n4;
                }
            }
            --n3;
        }
        return rationalMatrix;
    }

    public static boolean checkCorrectnessofJordanDecomposition(QuadraticMatrix quadraticMatrix, RationalMatrix rationalMatrix, QuadraticMatrix quadraticMatrix2, RationalMatrix rationalMatrix2) {
        QuadraticMatrix quadraticMatrix3 = QuadraticMatrix.multiplication(QuadraticMatrix.multiplication(rationalMatrix.getIntMatrix(), quadraticMatrix2), rationalMatrix2.getIntMatrix());
        if (quadraticMatrix.getDimension() != quadraticMatrix3.getDimension()) {
            throw new AssertionError((Object)"Mistake in Jordan decomposition!");
        }
        BigInteger bigInteger = rationalMatrix.getDenominator().multiply(rationalMatrix2.getDenominator());
        int n = 0;
        while (n < quadraticMatrix.getDimension()) {
            int n2 = 0;
            while (n2 < quadraticMatrix.getDimension()) {
                if (quadraticMatrix.getEntry(n, n2).intValue() != quadraticMatrix3.getEntry(n, n2).divide(bigInteger).intValue()) {
                    throw new AssertionError((Object)"Mistake in Jordan decomposition.");
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public int getDimension() {
        return this.mDimension;
    }

    public BigInteger getEntry(int n, int n2) {
        return this.mEntries[n][n2];
    }

    public void setEntry(int n, int n2, BigInteger bigInteger) {
        this.mEntries[n][n2] = bigInteger;
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.mEntries);
    }
}

