/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class SmtTestGenerationUtils {
    private SmtTestGenerationUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static String generateStringForTestfile(Term term) {
        String string;
        HashRelation3 hashRelation3;
        void hashRelation2;
        TermVariable[] termVariableArray = term.getFreeVars();
        Set<FunctionSymbol> set = SmtUtils.extractNonTheoryFunctionSymbols(term);
        HashSet<Sort> hashSet = new HashSet<Sort>();
        Object object2 = termVariableArray;
        int n = termVariableArray.length;
        boolean n2 = false;
        while (hashRelation2 < n) {
            TermVariable termVariable2 = object2[hashRelation2];
            hashSet.add(termVariable2.getSort());
            ++hashRelation2;
        }
        for (FunctionSymbol functionSymbol2 : set) {
            hashSet.add(functionSymbol2.getReturnSort());
            Collections.addAll(hashSet, functionSymbol2.getParameterSorts());
        }
        HashMap<Sort, TermVariable[]> hashMap = new HashMap<Sort, TermVariable[]>();
        for (Sort sort : hashSet) {
            object2 = SmtSortUtils.isBoolSort(sort) ? "SmtSortUtils::getBoolSort" : (SmtSortUtils.isRealSort(sort) ? "SmtSortUtils::getRealSort" : (SmtSortUtils.isIntSort(sort) ? "SmtSortUtils::getIntSort" : (SmtSortUtils.isArraySort(sort) ? (SmtTestGenerationUtils.isIntIntArray(sort) ? "QuantifierEliminationTest::getArrayIntIntSort" : (SmtTestGenerationUtils.isIntIntIntArray(sort) ? "QuantifierEliminationTest::getArrayIntIntIntSort" : "arraySort0")) : (SmtSortUtils.isBitvecSort(sort) ? "QuantifierEliminationTest::getBitvectorSort" + SmtSortUtils.getBitvectorLength(sort) : "otherSort0"))));
            hashMap.put(sort, (TermVariable[])object2);
        }
        HashRelation hashRelation = new HashRelation();
        TermVariable[] termVariableArray2 = termVariableArray;
        int n3 = termVariableArray.length;
        int n4 = 0;
        while (n4 < n3) {
            hashRelation3 = termVariableArray2[n4];
            hashRelation.addPair((Object)hashRelation3.getSort(), (Object)hashRelation3);
            ++n4;
        }
        hashRelation3 = new HashRelation3();
        for (FunctionSymbol functionSymbol2 : set) {
            hashRelation3.addTriple((Object)functionSymbol2.getParameterSorts(), (Object)functionSymbol2.getReturnSort(), (Object)functionSymbol2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t\tfinal FunDecl[] funDecls = new FunDecl[] {");
        stringBuilder.append(System.lineSeparator());
        for (Object[] objectArray : hashRelation.entrySet()) {
            String string2 = ((HashSet)objectArray.getValue()).stream().map(termVariable -> "\"" + termVariable.getName() + "\"").collect(Collectors.joining(", "));
            String string3 = (String)hashMap.get(objectArray.getKey());
            string = String.format("\t\t\tnew FunDecl(%s, %s),", string3, string2);
            stringBuilder.append(string);
            stringBuilder.append(System.lineSeparator());
        }
        for (Object[] objectArray : hashRelation3.projectToFst()) {
            for (String string2 : hashRelation3.projectToSnd((Object)objectArray)) {
                string = (String)hashMap.get(string2);
                Set set2 = hashRelation3.projectToTrd((Object)objectArray, (Object)string2);
                String string4 = set2.stream().map(functionSymbol -> "\"" + functionSymbol.getName() + "\"").collect(Collectors.joining(", "));
                if (Arrays.equals(objectArray, new Sort[0])) {
                    String string5 = String.format("\t\t\tnew FunDecl(%s, %s),", string, string4);
                    stringBuilder.append(string5);
                    stringBuilder.append(System.lineSeparator());
                    continue;
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
        }
        stringBuilder.append("\t\t};");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(String.format("\t\tfinal String formulaAsString = \"%s\";", term.toStringDirect()));
        stringBuilder.append(System.lineSeparator());
        return stringBuilder.toString();
    }

    private static boolean isIntIntArray(Sort sort) {
        return SmtSortUtils.isArraySort(sort) && sort.getArguments().length == 2 && SmtSortUtils.isIntSort(sort.getArguments()[0]) && SmtSortUtils.isIntSort(sort.getArguments()[1]);
    }

    private static boolean isIntIntIntArray(Sort sort) {
        return SmtSortUtils.isArraySort(sort) && sort.getArguments().length == 2 && SmtSortUtils.isIntSort(sort.getArguments()[0]) && SmtTestGenerationUtils.isIntIntArray(sort.getArguments()[1]);
    }

    public static String generateQuantifierEliminationTest(String string, Term term) {
        return SmtTestGenerationUtils.generateQuantifierEliminationTest(string, term, null);
    }

    public static String generateQuantifierEliminationTest(String string, Term term, Term term2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t").append("@Test").append(System.lineSeparator());
        stringBuilder.append("\t").append("public void ").append(string).append("() {").append(System.lineSeparator());
        stringBuilder.append(SmtTestGenerationUtils.generateStringForTestfile(term));
        stringBuilder.append("\t\t").append("final String expectedResult = ");
        if (term2 != null) {
            stringBuilder.append('\"').append(term2).append('\"');
        } else {
            stringBuilder.append(term2);
        }
        stringBuilder.append(";").append(System.lineSeparator());
        stringBuilder.append("\t\t").append("QuantifierEliminationTest.runQuantifierEliminationTest(funDecls, formulaAsString, expectedResult, true, mServices, mLogger, mMgdScript, mCsvWriter);").append(System.lineSeparator());
        stringBuilder.append("\t").append("}").append(System.lineSeparator());
        stringBuilder.append(System.lineSeparator());
        return stringBuilder.toString();
    }
}

