/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Objects;

public class MultiDimensionalSort {
    private final ArrayList<Sort> mIndexSorts = new ArrayList();
    private final Sort mArrayValueSort;

    public MultiDimensionalSort(Sort sort) {
        while (sort.isArraySort()) {
            Sort[] sortArray = sort.getArguments();
            assert (sortArray.length == 2);
            this.mIndexSorts.add(sortArray[0]);
            sort = sortArray[1];
        }
        this.mArrayValueSort = sort;
    }

    public ArrayList<Sort> getIndexSorts() {
        return this.mIndexSorts;
    }

    public Sort getArrayValueSort() {
        return this.mArrayValueSort;
    }

    public int getDimension() {
        return this.mIndexSorts.size();
    }

    public static boolean areDimensionsConsistent(Term term, ArrayIndex arrayIndex, Term term2) {
        int n = new MultiDimensionalSort(term2.getSort()).getDimension();
        int n2 = new MultiDimensionalSort(term.getSort()).getDimension();
        return arrayIndex.size() == n2 - n;
    }

    public int hashCode() {
        return Objects.hash(this.mArrayValueSort, this.mIndexSorts);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalSort multiDimensionalSort = (MultiDimensionalSort)object;
        return Objects.equals(this.mArrayValueSort, multiDimensionalSort.mArrayValueSort) && Objects.equals(this.mIndexSorts, multiDimensionalSort.mIndexSorts);
    }
}

