/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;

public final class IsSemiDeterministic<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final Set<STATE> mNondeterministicSuccessorOfAccepting = new HashSet<STATE>();
    private final boolean mResult;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mOperand;

    public IsSemiDeterministic(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider instanceof NestedWordAutomatonReachableStates ? (NestedWordAutomatonReachableStates)iNwaOutgoingLetterAndTransitionProvider : new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.iterate();
        this.mResult = this.mNondeterministicSuccessorOfAccepting.isEmpty();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Operand is " + (this.mResult ? "" : "not") + "semideterministic. There are " + String.valueOf(this.mNondeterministicSuccessorOfAccepting) + "nondeterministic non-strict successors of accepting states.";
    }

    public void iterate() {
        Set<DoubleDecker<STATE>> set;
        DoubleDecker doubleDecker;
        HashSet<DoubleDecker<STATE>> hashSet = new HashSet<DoubleDecker<STATE>>();
        ArrayDeque<DoubleDecker<STATE>> arrayDeque = new ArrayDeque<DoubleDecker<STATE>>();
        Set<DoubleDecker<STATE>> set2 = this.getFinalDoubleDeckers();
        hashSet.addAll(set2);
        arrayDeque.addAll(set2);
        while (!arrayDeque.isEmpty()) {
            doubleDecker = (DoubleDecker)arrayDeque.remove();
            if (NestedWordAutomataUtils.isNondeterministic(doubleDecker.getUp(), doubleDecker.getDown(), this.mOperand)) {
                this.mNondeterministicSuccessorOfAccepting.add(doubleDecker.getUp());
            }
            set = IsSemiDeterministic.getNonCallSuccessors(doubleDecker, this.mOperand);
            for (DoubleDecker<STATE> doubleDecker2 : set) {
                if (hashSet.contains(doubleDecker2)) continue;
                arrayDeque.add(doubleDecker2);
                hashSet.add(doubleDecker2);
            }
        }
        arrayDeque.addAll(hashSet);
        while (!arrayDeque.isEmpty()) {
            doubleDecker = (DoubleDecker)arrayDeque.remove();
            if (NestedWordAutomataUtils.isNondeterministic(doubleDecker.getUp(), doubleDecker.getDown(), this.mOperand)) {
                this.mNondeterministicSuccessorOfAccepting.add(doubleDecker.getUp());
            }
            set = IsSemiDeterministic.getNonReturnSuccessors(doubleDecker, this.mOperand);
            for (DoubleDecker<STATE> doubleDecker2 : set) {
                if (hashSet.contains(doubleDecker2)) continue;
                arrayDeque.add(doubleDecker2);
                hashSet.add(doubleDecker2);
            }
        }
    }

    private Set<DoubleDecker<STATE>> getFinalDoubleDeckers() {
        HashSet<DoubleDecker<STATE>> hashSet = new HashSet<DoubleDecker<STATE>>();
        for (STATE STATE : this.mOperand.getFinalStates()) {
            for (STATE STATE2 : this.mOperand.getDownStates(STATE)) {
                hashSet.add(new DoubleDecker<STATE>(STATE2, STATE));
            }
        }
        return hashSet;
    }

    private static <LETTER, STATE> Set<DoubleDecker<STATE>> getNonCallSuccessors(DoubleDecker<STATE> doubleDecker, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates) {
        HashSet<DoubleDecker<STATE>> hashSet = new HashSet<DoubleDecker<STATE>>();
        for (OutgoingInternalTransition<LETTER, STATE> iOutgoingTransitionlet : nestedWordAutomatonReachableStates.internalSuccessors(doubleDecker.getUp())) {
            hashSet.add(new DoubleDecker<STATE>(doubleDecker.getDown(), iOutgoingTransitionlet.getSucc()));
        }
        for (SummaryReturnTransition summaryReturnTransition : nestedWordAutomatonReachableStates.summarySuccessors(doubleDecker.getUp())) {
            hashSet.add(new DoubleDecker<STATE>(doubleDecker.getDown(), summaryReturnTransition.getSucc()));
        }
        for (OutgoingReturnTransition outgoingReturnTransition : nestedWordAutomatonReachableStates.returnSuccessorsGivenHier(doubleDecker.getUp(), doubleDecker.getDown())) {
            for (STATE STATE : nestedWordAutomatonReachableStates.getDownStates(doubleDecker.getDown())) {
                hashSet.add(new DoubleDecker<STATE>(STATE, outgoingReturnTransition.getSucc()));
            }
        }
        return hashSet;
    }

    private static <LETTER, STATE> Set<DoubleDecker<STATE>> getNonReturnSuccessors(DoubleDecker<STATE> doubleDecker, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates) {
        HashSet<DoubleDecker<STATE>> hashSet = new HashSet<DoubleDecker<STATE>>();
        for (OutgoingInternalTransition<LETTER, STATE> iOutgoingTransitionlet : nestedWordAutomatonReachableStates.internalSuccessors(doubleDecker.getUp())) {
            hashSet.add(new DoubleDecker<STATE>(doubleDecker.getDown(), iOutgoingTransitionlet.getSucc()));
        }
        for (SummaryReturnTransition summaryReturnTransition : nestedWordAutomatonReachableStates.summarySuccessors(doubleDecker.getUp())) {
            hashSet.add(new DoubleDecker<STATE>(doubleDecker.getDown(), summaryReturnTransition.getSucc()));
        }
        for (OutgoingCallTransition outgoingCallTransition : nestedWordAutomatonReachableStates.callSuccessors(doubleDecker.getUp())) {
            hashSet.add(new DoubleDecker<STATE>(doubleDecker.getUp(), outgoingCallTransition.getSucc()));
        }
        return hashSet;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }
}

