/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.counting.ConjunctGuards;
import de.uni_freiburg.informatik.ultimate.automata.counting.Counter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.FinalCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Guard;
import de.uni_freiburg.informatik.ultimate.automata.counting.ICaUnionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.counting.InitialCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.TermType;
import de.uni_freiburg.informatik.ultimate.automata.counting.Transition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Union<LETTER, STATE, CRSF extends IStateFactory<STATE>>
implements IOperation<LETTER, STATE, CRSF> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final CountingAutomaton<LETTER, STATE> mFstOperand;
    private final CountingAutomaton<LETTER, STATE> mSndOperand;
    private final STATE mNewInitialState;
    private final CountingAutomaton<LETTER, STATE> mResult;
    private final ICaUnionStateFactory<STATE> mStateFactory;

    public Union(AutomataLibraryServices automataLibraryServices, ICaUnionStateFactory<STATE> iCaUnionStateFactory, CountingAutomaton<LETTER, STATE> countingAutomaton, CountingAutomaton<LETTER, STATE> countingAutomaton2) throws AutomataLibraryException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(this.getClass());
        this.mFstOperand = countingAutomaton;
        this.mSndOperand = countingAutomaton2;
        this.mStateFactory = iCaUnionStateFactory;
        this.mNewInitialState = this.mStateFactory.constructInitialState();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private CountingAutomaton<LETTER, STATE> computeResult() {
        Object object;
        Object object2;
        Set<LETTER> set = this.mFstOperand.getAlphabet();
        ArrayList<Counter> arrayList = new ArrayList<Counter>();
        for (Counter object32 : this.mFstOperand.getCounter()) {
            arrayList.add(object32.copyCounter());
        }
        for (Counter counter : this.mSndOperand.getCounter()) {
            arrayList.add(counter.copyCounter());
        }
        HashSet<STATE> hashSet = new HashSet<STATE>(this.mFstOperand.getStates());
        hashSet.addAll(this.mSndOperand.getStates());
        hashSet.add(this.mNewInitialState);
        HashMap hashMap = new HashMap();
        HashMap<STATE, FinalCondition> hashMap2 = new HashMap<STATE, FinalCondition>();
        HashMap<STATE, Object> hashMap3 = new HashMap<STATE, Object>();
        Guard guard = new Guard();
        guard.changeTermType(TermType.TRUE);
        ArrayList<Guard> arrayList2 = new ArrayList<Guard>();
        arrayList2.add(guard);
        ArrayList<ArrayList<Guard>> arrayList3 = new ArrayList<ArrayList<Guard>>();
        arrayList3.add(arrayList2);
        hashMap.put(this.mNewInitialState, new InitialCondition(arrayList3));
        this.addNewUnionInitialConditions(this.mFstOperand, hashMap);
        this.addNewUnionInitialConditions(this.mSndOperand, hashMap);
        ArrayList<ArrayList<Guard>> arrayList4 = new ArrayList<ArrayList<Guard>>();
        this.addNewUnionFinalConditions(this.mFstOperand, arrayList4, hashMap2);
        this.addNewUnionFinalConditions(this.mSndOperand, arrayList4, hashMap2);
        if (arrayList4.size() == 0) {
            object2 = new Guard();
            ((Guard)object2).changeTermType(TermType.FALSE);
            object = new ArrayList<Guard>();
            ((ArrayList)object).add(object2);
            arrayList4.add((ArrayList<Guard>)object);
        }
        hashMap2.put(this.mNewInitialState, new FinalCondition(arrayList4));
        object2 = new ArrayList();
        this.addNewUnionTransitions(this.mFstOperand, (ArrayList<Transition<LETTER, STATE>>)object2, (Map<STATE, ArrayList<Transition<LETTER, STATE>>>)hashMap3);
        this.addNewUnionTransitions(this.mSndOperand, (ArrayList<Transition<LETTER, STATE>>)object2, (Map<STATE, ArrayList<Transition<LETTER, STATE>>>)hashMap3);
        hashMap3.put(this.mNewInitialState, object2);
        object = new CountingAutomaton<LETTER, STATE>(this.mServices, set, hashSet, arrayList, hashMap, hashMap2, hashMap3);
        return object;
    }

    private void addNewUnionInitialConditions(CountingAutomaton<LETTER, STATE> countingAutomaton, Map<STATE, InitialCondition> map) {
        for (STATE STATE : countingAutomaton.getStates()) {
            Guard guard = new Guard();
            guard.changeTermType(TermType.FALSE);
            ArrayList<Guard> arrayList = new ArrayList<Guard>();
            arrayList.add(guard);
            ArrayList<ArrayList<Guard>> arrayList2 = new ArrayList<ArrayList<Guard>>();
            arrayList2.add(arrayList);
            map.put(STATE, new InitialCondition(arrayList2));
        }
    }

    private void addNewUnionFinalConditions(CountingAutomaton<LETTER, STATE> countingAutomaton, ArrayList<ArrayList<Guard>> arrayList, Map<STATE, FinalCondition> map) {
        for (STATE STATE : countingAutomaton.getStates()) {
            map.put(STATE, countingAutomaton.getFinalConditions().get(STATE).copyFinalCondition());
            if (countingAutomaton.getInitialConditions().get(STATE).getCondition().get(0).get(0).getTermType() == TermType.FALSE || countingAutomaton.getFinalConditions().get(STATE).getCondition().get(0).get(0).getTermType() == TermType.FALSE) continue;
            ConjunctGuards conjunctGuards = new ConjunctGuards(countingAutomaton.getFinalConditions().get(STATE).copyFinalCondition().getCondition(), countingAutomaton.getInitialConditions().get(STATE).copyInitialCondition().getCondition());
            arrayList.addAll(conjunctGuards.getResult());
        }
    }

    private void addNewUnionTransitions(CountingAutomaton<LETTER, STATE> countingAutomaton, ArrayList<Transition<LETTER, STATE>> arrayList, Map<STATE, ArrayList<Transition<LETTER, STATE>>> map) {
        for (STATE STATE : countingAutomaton.getStates()) {
            Transition<LETTER, STATE> transition;
            ArrayList<Transition<LETTER, STATE>> arrayList2 = new ArrayList<Transition<LETTER, STATE>>();
            for (Transition<LETTER, STATE> transition2 : countingAutomaton.getTransitions().get(STATE)) {
                transition = transition2.copyTransition();
                arrayList2.add(transition);
            }
            map.put(STATE, arrayList2);
            if (countingAutomaton.getInitialConditions().get(STATE).getCondition().get(0).get(0).getTermType() == TermType.FALSE) continue;
            for (Transition<LETTER, STATE> transition2 : countingAutomaton.getTransitions().get(STATE)) {
                transition = transition2.copyTransition();
                ConjunctGuards conjunctGuards = new ConjunctGuards(transition.getGuards(), countingAutomaton.getInitialConditions().get(STATE).copyInitialCondition().getCondition());
                Transition<LETTER, STATE> transition3 = new Transition<LETTER, STATE>(transition.getLetter(), this.mNewInitialState, transition.getSucState(), conjunctGuards.getResult(), transition.getUpdates());
                arrayList.add(transition3);
            }
        }
    }

    @Override
    public CountingAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        return true;
    }
}

