/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import java.io.PrintWriter;
import java.util.Map;

public class SmtCommandUtils {

    public static class AssertCommand
    implements ISmtCommand<Void> {
        private final Term mTerm;

        public AssertCommand(Term term) {
            this.mTerm = term;
        }

        public Term getTerm() {
            return this.mTerm;
        }

        public static String buildString(Term term) {
            return "(assert " + term.toString() + ")";
        }

        @Override
        public Void executeWithScript(Script script) {
            script.assertTerm(this.mTerm);
            return null;
        }

        @Override
        public String toString() {
            return AssertCommand.buildString(this.mTerm);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class CheckSatCommand
    implements ISmtCommand<Script.LBool> {
        public static String buildString() {
            return "(check-sat)";
        }

        @Override
        public Script.LBool executeWithScript(Script script) {
            return script.checkSat();
        }

        @Override
        public String toString() {
            return CheckSatCommand.buildString();
        }

        @Override
        public Script.LBool executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            return executor.parseCheckSatResult();
        }
    }

    public static class DeclareFunCommand
    implements ISmtCommand<Void> {
        final String mFun;
        final Sort[] mParamSorts;
        final Sort mResultSort;

        public DeclareFunCommand(String string, Sort[] sortArray, Sort sort) {
            this.mFun = string;
            this.mParamSorts = sortArray;
            this.mResultSort = sort;
        }

        public String getFun() {
            return this.mFun;
        }

        public Sort[] getParamSorts() {
            return this.mParamSorts;
        }

        public Sort getResultSort() {
            return this.mResultSort;
        }

        public static String buildString(String string, Sort[] sortArray, Sort sort) {
            PrintTerm printTerm = new PrintTerm();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(declare-fun ");
            stringBuilder.append(PrintTerm.quoteIdentifier((String)string));
            stringBuilder.append(" (");
            String string2 = "";
            Sort[] sortArray2 = sortArray;
            int n = sortArray.length;
            int n2 = 0;
            while (n2 < n) {
                Sort sort2 = sortArray2[n2];
                stringBuilder.append(string2);
                printTerm.append((Appendable)stringBuilder, sort2);
                string2 = " ";
                ++n2;
            }
            stringBuilder.append(") ");
            printTerm.append((Appendable)stringBuilder, sort);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.declareFun(this.mFun, this.mParamSorts, this.mResultSort);
            return null;
        }

        @Override
        public String toString() {
            return DeclareFunCommand.buildString(this.mFun, this.mParamSorts, this.mResultSort);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class DeclareSortCommand
    implements ISmtCommand<Void> {
        private final String mSort;
        private final int mArity;

        public DeclareSortCommand(String string, int n) {
            this.mSort = string;
            this.mArity = n;
        }

        public static String buildString(String string, int n) {
            StringBuilder stringBuilder = new StringBuilder("(declare-sort ").append(PrintTerm.quoteIdentifier((String)string));
            stringBuilder.append(" ").append(n).append(")");
            return stringBuilder.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.declareSort(this.mSort, this.mArity);
            return null;
        }

        @Override
        public String toString() {
            return DeclareSortCommand.buildString(this.mSort, this.mArity);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class DefineFunCommand
    implements ISmtCommand<Void> {
        final String mFun;
        final TermVariable[] mParams;
        final Sort mResultSort;
        final Term mDefinition;

        public DefineFunCommand(String string, TermVariable[] termVariableArray, Sort sort, Term term) {
            this.mFun = string;
            this.mParams = termVariableArray;
            this.mResultSort = sort;
            this.mDefinition = term;
        }

        public static String buildString(String string, TermVariable[] termVariableArray, Sort sort, Term term) {
            PrintTerm printTerm = new PrintTerm();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(define-fun ");
            stringBuilder.append(PrintTerm.quoteIdentifier((String)string));
            stringBuilder.append(" (");
            String string2 = "";
            TermVariable[] termVariableArray2 = termVariableArray;
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable termVariable = termVariableArray2[n2];
                stringBuilder.append(string2);
                stringBuilder.append("(").append(termVariable).append(" ");
                printTerm.append((Appendable)stringBuilder, termVariable.getSort());
                stringBuilder.append(")");
                string2 = " ";
                ++n2;
            }
            stringBuilder.append(") ");
            printTerm.append((Appendable)stringBuilder, sort);
            stringBuilder.append(" ");
            printTerm.append((Appendable)stringBuilder, term);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.defineFun(this.mFun, this.mParams, this.mResultSort, this.mDefinition);
            return null;
        }

        @Override
        public String toString() {
            return DefineFunCommand.buildString(this.mFun, this.mParams, this.mResultSort, this.mDefinition);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class DefineSortCommand
    implements ISmtCommand<Void> {
        private final String mSort;
        private final Sort[] mSortParams;
        private final Sort mDefinition;

        public DefineSortCommand(String string, Sort[] sortArray, Sort sort) {
            this.mSort = string;
            this.mSortParams = sortArray;
            this.mDefinition = sort;
        }

        public static String buildString(String string, Sort[] sortArray, Sort sort) {
            PrintTerm printTerm = new PrintTerm();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(define-sort ");
            stringBuilder.append(PrintTerm.quoteIdentifier((String)string));
            stringBuilder.append(" (");
            String string2 = "";
            Sort[] sortArray2 = sortArray;
            int n = sortArray.length;
            int n2 = 0;
            while (n2 < n) {
                Sort sort2 = sortArray2[n2];
                stringBuilder.append(string2);
                printTerm.append((Appendable)stringBuilder, sort2);
                string2 = " ";
                ++n2;
            }
            stringBuilder.append(") ");
            printTerm.append((Appendable)stringBuilder, sort);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.defineSort(this.mSort, this.mSortParams, this.mDefinition);
            return null;
        }

        @Override
        public String toString() {
            return DefineSortCommand.buildString(this.mSort, this.mSortParams, this.mDefinition);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class EchoCommand
    implements ISmtCommand<Void> {
        final QuotedObject mMsg;

        public EchoCommand(QuotedObject quotedObject) {
            this.mMsg = quotedObject;
        }

        @Override
        public Void executeWithScript(Script script) {
            script.echo(this.mMsg);
            return null;
        }

        public static String buildString(QuotedObject quotedObject) {
            return "(echo " + String.valueOf(quotedObject) + ")";
        }

        @Override
        public String toString() {
            return EchoCommand.buildString(this.mMsg);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class ExitCommand
    implements ISmtCommand<Void> {
        public static String buildString() {
            return "(exit)";
        }

        @Override
        public Void executeWithScript(Script script) {
            script.reset();
            return null;
        }

        @Override
        public String toString() {
            return ExitCommand.buildString();
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class GetUnsatCoreCommand
    implements ISmtCommand<Term[]> {
        public static String buildString() {
            return "(get-unsat-core)";
        }

        @Override
        public Term[] executeWithScript(Script script) {
            return script.getUnsatCore();
        }

        @Override
        public String toString() {
            return GetUnsatCoreCommand.buildString();
        }

        @Override
        public Term[] executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            return executor.parseGetUnsatCoreResult();
        }
    }

    public static class GetValueCommand
    implements ISmtCommand<Map<Term, Term>> {
        final Term[] mTerms;

        public GetValueCommand(Term[] termArray) {
            this.mTerms = termArray;
        }

        public static String buildString(Term[] termArray) {
            StringBuilder stringBuilder = new StringBuilder();
            PrintTerm printTerm = new PrintTerm();
            stringBuilder.append("(get-value (");
            String string = "";
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray2[n2];
                stringBuilder.append(string);
                printTerm.append((Appendable)stringBuilder, term);
                string = " ";
                ++n2;
            }
            stringBuilder.append("))");
            return stringBuilder.toString();
        }

        @Override
        public Map<Term, Term> executeWithScript(Script script) {
            return script.getValue(this.mTerms);
        }

        @Override
        public String toString() {
            return GetValueCommand.buildString(this.mTerms);
        }

        @Override
        public Map<Term, Term> executeWithExecutor(Executor executor, PrintWriter printWriter) {
            return executor.parseGetValueResult();
        }
    }

    public static interface ISmtCommand<RT> {
        public RT executeWithScript(Script var1);

        public RT executeWithExecutor(Executor var1, PrintWriter var2);

        public String toString();
    }

    public static class ResetCommand
    implements ISmtCommand<Void> {
        public static String buildString() {
            return "(reset)";
        }

        @Override
        public Void executeWithScript(Script script) {
            script.reset();
            return null;
        }

        @Override
        public String toString() {
            return ResetCommand.buildString();
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class SetInfoCommand
    implements ISmtCommand<Void> {
        private final String mInfo;
        private final Object mValue;

        public SetInfoCommand(String string, Object object) {
            this.mInfo = string;
            this.mValue = object;
        }

        public static String buildString(String string, Object object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(set-info ");
            stringBuilder.append(string);
            stringBuilder.append(' ');
            stringBuilder.append(PrintTerm.quoteObjectIfString((Object)object));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.setInfo(this.mInfo, this.mValue);
            return null;
        }

        @Override
        public String toString() {
            return SetInfoCommand.buildString(this.mInfo, this.mValue);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class SetLogicCommand
    implements ISmtCommand<Void> {
        private final String mLogic;

        public SetLogicCommand(String string) {
            this.mLogic = string;
        }

        public static String buildString(String string) {
            return "(set-logic " + string + ")";
        }

        @Override
        public Void executeWithScript(Script script) {
            script.setLogic(this.mLogic);
            return null;
        }

        @Override
        public String toString() {
            return SetLogicCommand.buildString(this.mLogic);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }

    public static class SetOptionCommand
    implements ISmtCommand<Void> {
        private final String mOpt;
        private final Object mValue;

        public SetOptionCommand(String string, Object object) {
            this.mOpt = string;
            this.mValue = object;
        }

        public static String buildString(String string, Object object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(set-option ").append(string);
            if (object != null) {
                stringBuilder.append(" ");
                if (object instanceof String) {
                    stringBuilder.append(PrintTerm.quoteIdentifier((String)((String)object)));
                } else if (object instanceof Object[]) {
                    new PrintTerm().append((Appendable)stringBuilder, (Object[])object);
                } else {
                    stringBuilder.append(object.toString());
                }
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.setOption(this.mOpt, this.mValue);
            return null;
        }

        @Override
        public String toString() {
            return SetOptionCommand.buildString(this.mOpt, this.mValue);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter printWriter) {
            String string = this.toString();
            if (printWriter != null) {
                printWriter.println(string);
            }
            executor.input(string);
            executor.parseSuccess();
            return null;
        }
    }
}

