/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.compound;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgStatementExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.compound.CompoundDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.TransFormulaAdder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CompoundDomainPostOperator
implements IAbstractPostOperator<CompoundDomainState, IcfgEdge> {
    private final boolean mCreateStateAssumptions;
    private final boolean mUseSmtSolverChecks;
    private final boolean mSimplifyAssumption;
    private final ILogger mLogger;
    private final Boogie2SMT mBoogie2Smt;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final Script mScript;
    private final CodeBlockFactory mCodeBlockFactory;
    private final RcfgStatementExtractor mStatementExtractor;
    private final TransFormulaAdder mTransformulaBuilder;
    private final IUltimateServiceProvider mServices;

    protected CompoundDomainPostOperator(IUltimateServiceProvider iUltimateServiceProvider, BoogieIcfgContainer boogieIcfgContainer) {
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mBoogie2Smt = boogieIcfgContainer.getBoogie2SMT();
        this.mScript = boogieIcfgContainer.getCfgSmtToolkit().getManagedScript().getScript();
        this.mCodeBlockFactory = boogieIcfgContainer.getCodeBlockFactory();
        this.mStatementExtractor = new RcfgStatementExtractor();
        this.mTransformulaBuilder = new TransFormulaAdder(this.mBoogie2Smt, iUltimateServiceProvider);
        this.mServices = iUltimateServiceProvider;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mCreateStateAssumptions = iPreferenceProvider.getBoolean("Create assumptions of other states before post");
        this.mUseSmtSolverChecks = iPreferenceProvider.getBoolean("Check feasibility of abstract posts with an SMT solver");
        this.mSimplifyAssumption = iPreferenceProvider.getBoolean("Simplify assumptions before abstract post");
    }

    public List<CompoundDomainState> apply(CompoundDomainState compoundDomainState, IcfgEdge icfgEdge) {
        ArrayList<CompoundDomainState> arrayList = new ArrayList<CompoundDomainState>();
        List<IAbstractState<?>> list = compoundDomainState.getAbstractStatesList();
        List<IAbstractDomain> list2 = compoundDomainState.getDomainList();
        assert (list2.size() == list.size());
        List<IcfgEdge> list3 = this.createTransitionList(icfgEdge, list);
        assert (list3.size() == list2.size());
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        while (n < list2.size()) {
            IAbstractDomain iAbstractDomain = list2.get(n);
            IAbstractState<?> iAbstractState = list.get(n);
            IcfgEdge icfgEdge2 = list3.get(n);
            Collection<IAbstractState> collection = CompoundDomainPostOperator.applyInternally(iAbstractState, iAbstractDomain.getPostOperator(), icfgEdge2);
            if (collection.isEmpty()) {
                return Collections.emptyList();
            }
            IAbstractState iAbstractState2 = DisjunctiveAbstractState.union(collection);
            if (iAbstractState2 == null || iAbstractState2.isBottom()) {
                return Collections.emptyList();
            }
            arrayList2.add(iAbstractState2);
            ++n;
        }
        assert (arrayList2.size() == list2.size());
        arrayList.add(new CompoundDomainState(this.mServices, list2, arrayList2));
        return arrayList;
    }

    private boolean checkSat(CompoundDomainState compoundDomainState) {
        Term term = compoundDomainState.getTerm(this.mScript);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Checking state term for satisfiability: " + term));
        }
        Script.LBool lBool = SmtUtils.checkSatTerm((Script)this.mScript, (Term)term);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Result of satisfiability check is: " + lBool));
        }
        return lBool != Script.LBool.UNSAT;
    }

    private List<IcfgEdge> createTransitionList(IcfgEdge icfgEdge, List<IAbstractState<?>> list) {
        ArrayList<IcfgEdge> arrayList = new ArrayList<IcfgEdge>();
        if (this.mCreateStateAssumptions) {
            if (list.size() == 1) {
                arrayList.add(icfgEdge);
            } else {
                int n = 0;
                while (n < list.size()) {
                    arrayList.add(this.createBlockWithoutState(list, n, icfgEdge));
                    ++n;
                }
            }
        } else {
            int n = 0;
            while (n < list.size()) {
                arrayList.add(icfgEdge);
                ++n;
            }
        }
        return arrayList;
    }

    private IcfgEdge createBlockWithoutState(List<IAbstractState<?>> list, int n, IcfgEdge icfgEdge) {
        Object object;
        AssumeStatement assumeStatement;
        assert (!list.isEmpty());
        Term term = null;
        int n2 = 0;
        while (n2 < list.size()) {
            if (n2 != n) {
                assumeStatement = list.get(n2);
                object = assumeStatement.getTerm(this.mScript);
                term = term == null ? object : this.mScript.term("and", new Term[]{term, object});
            }
            ++n2;
        }
        if (this.mSimplifyAssumption) {
            term = SmtUtils.simplify((ManagedScript)this.mBoogie2Smt.getManagedScript(), term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
        }
        Expression expression = this.mBoogie2Smt.getTerm2Expression().translate(term);
        assumeStatement = new AssumeStatement(expression.getLocation(), expression);
        object = new ArrayList();
        object.add(assumeStatement);
        object.addAll(this.mStatementExtractor.process(icfgEdge));
        StatementSequence statementSequence = this.mCodeBlockFactory.constructStatementSequence(null, null, (List)object);
        this.mTransformulaBuilder.addTransitionFormulas((CodeBlock)statementSequence, icfgEdge.getPrecedingProcedure(), this.mSimplificationTechnique);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("    Created new transition for domain " + n));
            this.mLogger.debug((Object)("       term:       " + term.toStringDirect()));
            this.mLogger.debug((Object)("       transition: " + String.valueOf(statementSequence)));
        }
        return statementSequence;
    }

    public List<CompoundDomainState> apply(CompoundDomainState compoundDomainState, CompoundDomainState compoundDomainState2, IcfgEdge icfgEdge) {
        ArrayList<CompoundDomainState> arrayList = new ArrayList<CompoundDomainState>();
        List<IAbstractState<?>> list = compoundDomainState.getAbstractStatesList();
        List<IAbstractState<?>> list2 = compoundDomainState2.getAbstractStatesList();
        List<IAbstractDomain> list3 = compoundDomainState.getDomainList();
        List<IAbstractDomain> list4 = compoundDomainState2.getDomainList();
        assert (list3.size() == list4.size());
        assert (list.size() == list2.size());
        assert (list3.size() == list.size());
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        while (n < list3.size()) {
            List<IAbstractState> list5 = CompoundDomainPostOperator.applyInternally(list.get(n), list2.get(n), list3.get(n).getPostOperator(), icfgEdge);
            if (list5.isEmpty()) {
                return new ArrayList<CompoundDomainState>();
            }
            IAbstractState iAbstractState = list5.get(0);
            int n2 = 1;
            while (n2 < list5.size()) {
                iAbstractState = CompoundDomainPostOperator.applyMergeInternally(iAbstractState, list5.get(n2));
                ++n2;
            }
            if (iAbstractState.isBottom()) {
                return new ArrayList<CompoundDomainState>();
            }
            arrayList2.add(iAbstractState);
            ++n;
        }
        assert (arrayList2.size() == list3.size());
        arrayList.add(new CompoundDomainState(this.mServices, list3, arrayList2));
        return arrayList;
    }

    private static Collection<IAbstractState> applyInternally(IAbstractState<?> iAbstractState, IAbstractPostOperator iAbstractPostOperator, IcfgEdge icfgEdge) {
        return iAbstractPostOperator.apply(iAbstractState, (Object)icfgEdge);
    }

    private static List<IAbstractState> applyInternally(IAbstractState<?> iAbstractState, IAbstractState<?> iAbstractState2, IAbstractPostOperator iAbstractPostOperator, IcfgEdge icfgEdge) {
        return iAbstractPostOperator.apply(iAbstractState, iAbstractState2, (Object)icfgEdge);
    }

    private static <T extends IAbstractState<T>> T applyMergeInternally(T t, T t2) {
        return (T)t.union(t2);
    }

    public IAbstractPostOperator.EvalResult evaluate(CompoundDomainState compoundDomainState, Term term, Script script) {
        List<IAbstractState<?>> list = compoundDomainState.getAbstractStatesList();
        int n = 0;
        while (n < list.size()) {
            IAbstractPostOperator iAbstractPostOperator = compoundDomainState.getDomainList().get(n).getPostOperator();
            IAbstractPostOperator.EvalResult evalResult = iAbstractPostOperator.evaluate(list.get(n), term, script);
            if (evalResult != IAbstractPostOperator.EvalResult.UNKNOWN) {
                assert (evalResult == CompoundDomainPostOperator.slowEvaluate(compoundDomainState, term, script)) : "CompoundDomain substates contradict each other during evaluate";
                return evalResult;
            }
            ++n;
        }
        return IAbstractPostOperator.EvalResult.UNKNOWN;
    }

    private static IAbstractPostOperator.EvalResult slowEvaluate(CompoundDomainState compoundDomainState, Term term, Script script) {
        IAbstractPostOperator.EvalResult evalResult = IAbstractPostOperator.EvalResult.UNKNOWN;
        List<IAbstractState<?>> list = compoundDomainState.getAbstractStatesList();
        int n = 0;
        while (n < list.size()) {
            IAbstractPostOperator iAbstractPostOperator = compoundDomainState.getDomainList().get(n).getPostOperator();
            IAbstractPostOperator.EvalResult evalResult2 = iAbstractPostOperator.evaluate(list.get(n), term, script);
            if (evalResult2 != IAbstractPostOperator.EvalResult.UNKNOWN) {
                if (evalResult == IAbstractPostOperator.EvalResult.UNKNOWN) {
                    evalResult = evalResult2;
                } else if (evalResult2 != evalResult) assert (false) : "One state said " + String.valueOf(evalResult) + " another said " + String.valueOf(evalResult2);
            }
            ++n;
        }
        return evalResult;
    }
}

