/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public abstract sealed class ASTType
extends BoogieASTNode
permits StructType, ArrayType, PrimitiveType, NamedType {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(ASTType.class);
    ILocation loc;
    IBoogieType boogieType;

    public ASTType(ILocation iLocation) {
        super(iLocation);
        this.loc = iLocation;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ASTType: " + String.valueOf((Object)this);
    }

    public ASTType(ILocation iLocation, IBoogieType iBoogieType) {
        super(iLocation);
        this.loc = iLocation;
        this.boogieType = iBoogieType;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ASTType: " + String.valueOf((Object)this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ASTType").append('[');
        stringBuffer.append(this.loc);
        stringBuffer.append(',').append(this.boogieType);
        return stringBuffer.append(']').toString();
    }

    public ILocation getLoc() {
        return this.loc;
    }

    public void setLoc(ILocation iLocation) {
        if (this.loc != null && iLocation != this.loc) {
            throw new AssertionError((Object)"Value is only writeable once");
        }
        this.loc = iLocation;
    }

    public IBoogieType getBoogieType() {
        return this.boogieType;
    }

    public void setBoogieType(IBoogieType iBoogieType) {
        this.boogieType = iBoogieType;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public abstract void accept(GeneratedBoogieAstVisitor var1);

    public abstract ASTType accept(GeneratedBoogieAstTransformer var1);
}

