/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class ArrayLHS
extends LeftHandSide {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(ArrayLHS.class);
    LeftHandSide array;
    Expression[] indices;

    public ArrayLHS(ILocation iLocation, LeftHandSide leftHandSide, Expression[] expressionArray) {
        super(iLocation);
        this.array = leftHandSide;
        this.indices = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ArrayLHS: " + String.valueOf((Object)this);
    }

    public ArrayLHS(ILocation iLocation, IBoogieType iBoogieType, LeftHandSide leftHandSide, Expression[] expressionArray) {
        super(iLocation, iBoogieType);
        this.array = leftHandSide;
        this.indices = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ArrayLHS: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ArrayLHS").append('[');
        stringBuffer.append((Object)this.array);
        stringBuffer.append(',');
        if (this.indices == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.indices.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.indices[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public LeftHandSide getArray() {
        return this.array;
    }

    public Expression[] getIndices() {
        return this.indices;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.array);
        if (this.indices != null) {
            list.addAll(Arrays.asList(this.indices));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((LeftHandSide)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.array != null) {
                this.array.accept(generatedBoogieAstVisitor);
            }
            if (this.indices != null) {
                Expression[] expressionArray = this.indices;
                int n = this.indices.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression expression = expressionArray[n2];
                    expression.accept(generatedBoogieAstVisitor);
                    ++n2;
                }
            }
        }
    }

    @Override
    public LeftHandSide accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        LeftHandSide leftHandSide = generatedBoogieAstTransformer.transform(this);
        if (leftHandSide != this) {
            return leftHandSide;
        }
        LeftHandSide leftHandSide2 = null;
        if (this.array != null) {
            leftHandSide2 = this.array.accept(generatedBoogieAstTransformer);
        }
        boolean bl = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.indices != null) {
            Expression[] expressionArray = this.indices;
            int n = this.indices.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                Expression expression2 = expression.accept(generatedBoogieAstTransformer);
                bl = bl || expression2 != expression;
                arrayList.add(expression2);
                ++n2;
            }
        }
        if (bl || this.array != leftHandSide2) {
            return new ArrayLHS(this.loc, this.type, leftHandSide2, arrayList.toArray(new Expression[0]));
        }
        return this;
    }
}

