/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Determinize;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;

public class MinimizeNfaBrzozowski<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;

    public <SF extends IDeterminizeStateFactory<STATE> & IMinimizationStateFactory<STATE>> MinimizeNfaBrzozowski(AutomataLibraryServices automataLibraryServices, SF SF, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices, SF);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        assert (super.isFiniteAutomaton()) : "The input automaton contains call or return transitions.";
        this.minimize(SF);
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    private void minimize(IDeterminizeStateFactory<STATE> iDeterminizeStateFactory) throws AutomataOperationCanceledException {
        INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton = this.mOperand;
        int n = 0;
        while (n < 2) {
            super.checkForContinuation();
            iNestedWordAutomaton = this.reverse(iNestedWordAutomaton, iDeterminizeStateFactory);
            super.checkForContinuation();
            iNestedWordAutomaton = this.determinize(iDeterminizeStateFactory, iNestedWordAutomaton);
            ++n;
        }
        this.directResultConstruction(iNestedWordAutomaton);
    }

    private INestedWordAutomaton<LETTER, STATE> reverse(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) {
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, iNestedWordAutomaton.getVpAlphabet(), iEmptyStackStateFactory);
        for (STATE STATE : iNestedWordAutomaton.getStates()) {
            nestedWordAutomaton.addState(iNestedWordAutomaton.isFinal(STATE), iNestedWordAutomaton.isInitial(STATE), STATE);
        }
        for (STATE STATE : iNestedWordAutomaton.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors(STATE)) {
                nestedWordAutomaton.addInternalTransition(outgoingInternalTransition.getSucc(), outgoingInternalTransition.getLetter(), STATE);
            }
        }
        return nestedWordAutomaton;
    }

    private INestedWordAutomaton<LETTER, STATE> determinize(IDeterminizeStateFactory<STATE> iDeterminizeStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        return new Determinize<LETTER, STATE>(this.mServices, iDeterminizeStateFactory, iNestedWordAutomaton).getResult();
    }
}

