/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiAutomizerModuleDecompositionBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.TermcompProofBenchmark;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;

public final class BuchiCegarLoopResult<L extends IIcfgTransition<?>> {
    private final Result mResult;
    private final NestedWord<L> mStem;
    private final NestedWord<L> mLoop;
    private final HashRelation<String, ILocation> mOverapproximations;
    private final ToolchainCanceledException mToolchainCancelledException;
    private final NonTerminationArgument mNonTerminationArgument;
    private final BuchiAutomizerModuleDecompositionBenchmark mMDBenchmark;
    private final TermcompProofBenchmark mTermcompProofBenchmark;

    private BuchiCegarLoopResult(Result result, NestedWord<L> nestedWord, NestedWord<L> nestedWord2, HashRelation<String, ILocation> hashRelation, ToolchainCanceledException toolchainCanceledException, NonTerminationArgument nonTerminationArgument, BuchiAutomizerModuleDecompositionBenchmark buchiAutomizerModuleDecompositionBenchmark, TermcompProofBenchmark termcompProofBenchmark) {
        this.mResult = result;
        this.mStem = nestedWord;
        this.mLoop = nestedWord2;
        this.mOverapproximations = hashRelation;
        this.mToolchainCancelledException = toolchainCanceledException;
        this.mNonTerminationArgument = nonTerminationArgument;
        this.mMDBenchmark = buchiAutomizerModuleDecompositionBenchmark;
        this.mTermcompProofBenchmark = termcompProofBenchmark;
    }

    public static <L extends IIcfgTransition<?>> BuchiCegarLoopResult<L> constructTerminatingResult(BuchiAutomizerModuleDecompositionBenchmark buchiAutomizerModuleDecompositionBenchmark, TermcompProofBenchmark termcompProofBenchmark) {
        return new BuchiCegarLoopResult<L>(Result.TERMINATING, null, null, null, null, null, buchiAutomizerModuleDecompositionBenchmark, termcompProofBenchmark);
    }

    public static <L extends IIcfgTransition<?>> BuchiCegarLoopResult<L> constructNonTerminatingResult(NestedWord<L> nestedWord, NestedWord<L> nestedWord2, NonTerminationArgument nonTerminationArgument, BuchiAutomizerModuleDecompositionBenchmark buchiAutomizerModuleDecompositionBenchmark, TermcompProofBenchmark termcompProofBenchmark) {
        return new BuchiCegarLoopResult<L>(Result.NONTERMINATING, nestedWord, nestedWord2, null, null, nonTerminationArgument, buchiAutomizerModuleDecompositionBenchmark, termcompProofBenchmark);
    }

    public static <L extends IIcfgTransition<?>> BuchiCegarLoopResult<L> constructUnknownResult(NestedWord<L> nestedWord, NestedWord<L> nestedWord2, HashRelation<String, ILocation> hashRelation, BuchiAutomizerModuleDecompositionBenchmark buchiAutomizerModuleDecompositionBenchmark, TermcompProofBenchmark termcompProofBenchmark) {
        return new BuchiCegarLoopResult<L>(Result.UNKNOWN, nestedWord, nestedWord2, hashRelation, null, null, buchiAutomizerModuleDecompositionBenchmark, termcompProofBenchmark);
    }

    public static <L extends IIcfgTransition<?>> BuchiCegarLoopResult<L> constructTimeoutResult(ToolchainCanceledException toolchainCanceledException, BuchiAutomizerModuleDecompositionBenchmark buchiAutomizerModuleDecompositionBenchmark, TermcompProofBenchmark termcompProofBenchmark) {
        return new BuchiCegarLoopResult<L>(Result.TIMEOUT, null, null, null, toolchainCanceledException, null, buchiAutomizerModuleDecompositionBenchmark, termcompProofBenchmark);
    }

    public static <L extends IIcfgTransition<?>> BuchiCegarLoopResult<L> constructInsufficientThreadsResult() {
        return new BuchiCegarLoopResult<L>(Result.INSUFFICIENT_THREADS, null, null, null, null, null, null, null);
    }

    public Result getResult() {
        return this.mResult;
    }

    public NestedWord<L> getStem() {
        if (this.mResult != Result.NONTERMINATING && this.mResult != Result.UNKNOWN) {
            throw new UnsupportedOperationException("Result " + String.valueOf((Object)this.mResult) + " does not provide a counterexample.");
        }
        return this.mStem;
    }

    public NestedWord<L> getLoop() {
        if (this.mResult != Result.NONTERMINATING && this.mResult != Result.UNKNOWN) {
            throw new UnsupportedOperationException("Result " + String.valueOf((Object)this.mResult) + " does not provide a counterexample.");
        }
        return this.mLoop;
    }

    public HashRelation<String, ILocation> getOverapproximations() {
        if (this.mResult != Result.NONTERMINATING && this.mResult != Result.UNKNOWN) {
            throw new UnsupportedOperationException("Result " + String.valueOf((Object)this.mResult) + " does not provide overapproximations.");
        }
        return this.mOverapproximations;
    }

    public ToolchainCanceledException getToolchainCancelledException() {
        if (this.mResult != Result.TIMEOUT) {
            throw new UnsupportedOperationException("Result " + String.valueOf((Object)this.mResult) + " does not provide a TCE.");
        }
        return this.mToolchainCancelledException;
    }

    public NonTerminationArgument getNonTerminationArgument() {
        if (this.mResult != Result.NONTERMINATING) {
            throw new UnsupportedOperationException("Result " + String.valueOf((Object)this.mResult) + " does not provide a non-termination argument.");
        }
        return this.mNonTerminationArgument;
    }

    public BuchiAutomizerModuleDecompositionBenchmark getMDBenchmark() {
        return this.mMDBenchmark;
    }

    public TermcompProofBenchmark getTermcompProofBenchmark() {
        return this.mTermcompProofBenchmark;
    }

    public static enum Result {
        TERMINATING,
        TIMEOUT,
        UNKNOWN,
        NONTERMINATING,
        INSUFFICIENT_THREADS;

    }
}

