/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.AtomicBlockAnalyzer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.AtomicBlockInfo;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CfgBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class LargeBlockEncoding {
    public static final boolean PRESERVE_LOOP_HEADS_AND_LOCATIONS_OF_INTEREST = true;
    private final IUltimateServiceProvider mServices;
    private final BoogieIcfgContainer mIcfg;
    private final CodeBlockFactory mCbf;
    private final InternalLbeMode mInternalLbeMode;
    final boolean mSimplifyCodeBlocks;
    private final ILogger mLogger;
    private final Set<BoogieIcfgLocation> mEntryNodes;
    private final AtomicBlockAnalyzer mAtomicAnalysis;
    private final HashDeque<BoogieIcfgLocation> mSequentialQueue = new HashDeque();
    private final HashDeque<BoogieIcfgLocation> mComplexSequentialQueue = new HashDeque();
    private final LinkedHashMap<BoogieIcfgLocation, List<List<CodeBlock>>> mParallelQueue = new LinkedHashMap<K, V>();
    private int mStraightlineSequentialCompositions;
    private int mOneToNSequentialCompositions;
    private int mComplexSequentialCompositions;
    private int mParallelCompositions;

    /*
     * Unable to fully structure code
     */
    public LargeBlockEncoding(IUltimateServiceProvider var1_1, BoogieIcfgContainer var2_2, CodeBlockFactory var3_3, InternalLbeMode var4_4) {
        super();
        var5_5 = System.nanoTime();
        this.mServices = var1_1;
        this.mIcfg = var2_2;
        this.mCbf = var3_3;
        this.mInternalLbeMode = var4_4;
        this.mLogger = var1_1.getLoggingService().getLogger(LargeBlockEncoding.class);
        this.mSimplifyCodeBlocks = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Simplify code blocks");
        this.mEntryNodes = new HashSet<BoogieIcfgLocation>(this.mIcfg.getProcedureEntryNodes().values());
        this.mAtomicAnalysis = new AtomicBlockAnalyzer(this.mIcfg);
        this.mLogger.info("Applying CFG Large Block Encoding to ICFG that has %d procedures, %d locations, %d edges, %d initial locations, %d loop locations, and %d error locations.", new Object[]{var2_2.getProcedureEntryNodes().size(), IcfgUtils.getNumberOfLocations((IIcfg)var2_2), IcfgUtils.getNumberOfEdges((IIcfg)var2_2), var2_2.getInitialNodes().size(), var2_2.getLoopLocations().size(), IcfgUtils.getErrorLocations((IIcfg)var2_2).size()});
        IcfgUtils.getAllLocations((IIcfg)this.mIcfg).forEach((Consumer<BoogieIcfgLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation ), (Lde/uni_freiburg/informatik/ultimate/plugins/generator/rcfgbuilder/cfg/BoogieIcfgLocation;)V)((LargeBlockEncoding)this));
        while (!(this.mSequentialQueue.isEmpty() && this.mParallelQueue.isEmpty() && this.mComplexSequentialQueue.isEmpty())) {
            if (this.mServices.getProgressMonitorService().continueProcessing()) ** GOTO lbl22
            throw new ToolchainCanceledException(this.getClass(), "performing CFG large-block encoding");
lbl-1000:
            // 1 sources

            {
                var7_6 = (BoogieIcfgLocation)this.mComplexSequentialQueue.pollFirst();
                this.composeSequential((BoogieIcfgLocation)var7_6);
                this.mLogger.debug("Complex sequential composition at %s", new Object[]{var7_6});
lbl22:
                // 2 sources

                ** while (this.mSequentialQueue.isEmpty() && this.mParallelQueue.isEmpty() && !this.mComplexSequentialQueue.isEmpty())
            }
lbl23:
            // 2 sources

            while (this.mSequentialQueue.isEmpty() && !this.mParallelQueue.isEmpty()) {
                var7_6 = this.mParallelQueue.firstEntry();
                var8_8 = (BoogieIcfgLocation)var7_6.getKey();
                this.mParallelQueue.remove((Object)var8_8);
                for (List var9_9 : (List)var7_6.getValue()) {
                    this.composeParallel(var8_8, var9_9);
                    this.mLogger.debug("parallel composition of %d edges at %s", new Object[]{var8_8, var9_9.size()});
                }
            }
            while (!this.mSequentialQueue.isEmpty()) {
                var7_6 = (BoogieIcfgLocation)this.mSequentialQueue.pollFirst();
                this.composeSequential((BoogieIcfgLocation)var7_6);
                this.mLogger.debug("sequential composition at %s", new Object[]{var7_6});
            }
            this.mComplexSequentialQueue.clear();
            this.mParallelQueue.clear();
            this.mSequentialQueue.clear();
            IcfgUtils.getAllLocations((IIcfg)this.mIcfg).forEach((Consumer<BoogieIcfgLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$1(de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation ), (Lde/uni_freiburg/informatik/ultimate/plugins/generator/rcfgbuilder/cfg/BoogieIcfgLocation;)V)((LargeBlockEncoding)this));
        }
        var7_7 = System.nanoTime() - var5_5;
        this.mLogger.info("LargeBlockEncoding completed in %d ms, with %d straightline sequential compositions, %d parallel compositions, %d 1:n/n:1 sequential compositions and %d complex sequential compositions.", new Object[]{var7_7 / 1000L / 1000L, this.mStraightlineSequentialCompositions, this.mParallelCompositions, this.mOneToNSequentialCompositions, this.mComplexSequentialCompositions});
    }

    private void considerCompositionCandidate(BoogieIcfgLocation boogieIcfgLocation, boolean bl) {
        if (this.mIcfg.getLoopLocations().contains((Object)boogieIcfgLocation) || this.mIcfg.getLocationsOfInterest().contains((Object)boogieIcfgLocation)) {
            return;
        }
        this.mLogger.debug((Object)("Considering composition at " + String.valueOf((Object)boogieIcfgLocation)));
        SequentialCompositionType sequentialCompositionType = this.classifySequentialCompositionNode(boogieIcfgLocation);
        if (sequentialCompositionType == SequentialCompositionType.STRAIGHTLINE) {
            this.mSequentialQueue.offerLast((Object)boogieIcfgLocation);
            this.mLogger.debug((Object)"decided on straightline sequential composition");
            return;
        }
        List<List<CodeBlock>> list = this.computeOutgoingCandidatesForParallelComposition(boogieIcfgLocation);
        if (!list.isEmpty()) {
            this.mParallelQueue.put(boogieIcfgLocation, list);
            this.mLogger.debug((Object)"decided on parallel composition");
        } else if (sequentialCompositionType == SequentialCompositionType.COMPLEX && bl) {
            boolean bl2;
            boolean bl3 = bl2 = boogieIcfgLocation.getIncomingEdges().size() == 1 && boogieIcfgLocation.getOutgoingNodes().stream().anyMatch(icfgLocation -> icfgLocation.getOutgoingEdges().isEmpty()) && boogieIcfgLocation.getOutgoingNodes().stream().distinct().count() > 1L;
            if (bl2) {
                this.mComplexSequentialQueue.offerFirst((Object)boogieIcfgLocation);
                this.mLogger.debug((Object)"decided on (unavoidable) complex sequential composition");
            } else {
                this.mComplexSequentialQueue.offerLast((Object)boogieIcfgLocation);
                this.mLogger.debug((Object)"decided on complex sequential composition");
            }
        } else {
            this.mLogger.debug((Object)"decided on NO composition");
        }
    }

    private void composeSequential(BoogieIcfgLocation boogieIcfgLocation) {
        Object object;
        Object object22;
        Object object32;
        assert (!boogieIcfgLocation.getIncomingEdges().isEmpty());
        assert (!boogieIcfgLocation.getOutgoingEdges().isEmpty());
        ArrayList arrayList = new ArrayList(boogieIcfgLocation.getIncomingEdges());
        ArrayList arrayList2 = new ArrayList(boogieIcfgLocation.getOutgoingEdges());
        ArrayList<SequentialComposition> arrayList3 = new ArrayList<SequentialComposition>();
        if (arrayList.size() == 1 && arrayList2.size() == 1) {
            ++this.mStraightlineSequentialCompositions;
        } else if (arrayList.size() > 1 && arrayList2.size() > 1) {
            ++this.mComplexSequentialCompositions;
            this.mLogger.warn("Complex %d:%d sequential composition. Such compositions can cause exponential blowup and should not occur in structured programs.", new Object[]{arrayList.size(), arrayList2.size()});
        } else {
            ++this.mOneToNSequentialCompositions;
        }
        for (Object object32 : arrayList) {
            for (Object object22 : arrayList2) {
                BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)object32.getSource();
                BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)object22.getTarget();
                List<CodeBlock> list = Arrays.asList((CodeBlock)((Object)object32), (CodeBlock)((Object)object22));
                SequentialComposition sequentialComposition = this.mCbf.constructSequentialComposition(boogieIcfgLocation2, boogieIcfgLocation3, this.mSimplifyCodeBlocks, false, list, CfgBuilder.SIMPLIFICATION_TECHNIQUE);
                ModelUtils.copyAnnotationsFiltered((IElement)object32, (IElement)sequentialComposition, iAnnotations -> !(iAnnotations instanceof AtomicBlockInfo));
                ModelUtils.copyAnnotationsFiltered((IElement)object22, (IElement)sequentialComposition, iAnnotations -> !(iAnnotations instanceof AtomicBlockInfo));
                AtomicBlockInfo.mergeSequential(object32, object22, sequentialComposition);
                arrayList3.add(sequentialComposition);
            }
        }
        for (Object object32 : arrayList) {
            object32.disconnectSource();
            object32.disconnectTarget();
        }
        for (Object object32 : arrayList2) {
            object32.disconnectSource();
            object32.disconnectTarget();
        }
        object32 = new HashSet();
        arrayList3.forEach(arg_0 -> LargeBlockEncoding.lambda$5((Set)object32, arg_0));
        arrayList3.forEach(arg_0 -> LargeBlockEncoding.lambda$6((Set)object32, arg_0));
        object22 = object32.iterator();
        while (object22.hasNext()) {
            object = (BoogieIcfgLocation)((Object)object22.next());
            this.considerCompositionCandidate((BoogieIcfgLocation)((Object)object), false);
        }
        object = this.mIcfg.getProgramPoints().get(boogieIcfgLocation.getProcedure());
        object.remove(boogieIcfgLocation.getDebugIdentifier());
        this.mAtomicAnalysis.removeLocation(boogieIcfgLocation);
    }

    private void composeParallel(BoogieIcfgLocation boogieIcfgLocation, List<CodeBlock> list) {
        OptionalInt optionalInt;
        ++this.mParallelCompositions;
        BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)list.get(0).getTarget();
        if (list.stream().anyMatch(AtomicBlockInfo::hasAnnotation)) {
            int[] object2 = list.stream().mapToInt(AtomicBlockInfo::getAnnotatedDelta).distinct().toArray();
            assert (object2.length == 1) : "cannot perform parallel compositions of edges with different atomic block deltas";
            optionalInt = OptionalInt.of(object2[0]);
        } else {
            optionalInt = OptionalInt.empty();
        }
        for (CodeBlock codeBlock : list) {
            AtomicBlockInfo.removeAnnotation(codeBlock);
        }
        ParallelComposition parallelComposition = this.mCbf.constructParallelComposition(boogieIcfgLocation, boogieIcfgLocation2, Collections.unmodifiableList(list), CfgBuilder.SIMPLIFICATION_TECHNIQUE);
        if (optionalInt.isPresent()) {
            AtomicBlockInfo.addAnnotation(parallelComposition, optionalInt.orElseThrow());
        }
        this.considerCompositionCandidate(boogieIcfgLocation, false);
        this.considerCompositionCandidate(boogieIcfgLocation2, false);
    }

    private SequentialCompositionType classifySequentialCompositionNode(BoogieIcfgLocation boogieIcfgLocation) {
        boolean bl;
        if (boogieIcfgLocation.getIncomingEdges().isEmpty() || boogieIcfgLocation.getOutgoingEdges().isEmpty() || this.mEntryNodes.contains((Object)boogieIcfgLocation)) {
            return SequentialCompositionType.NONE;
        }
        if (DataStructureUtils.haveNonEmptyIntersection(new HashSet(boogieIcfgLocation.getIncomingEdges()), new HashSet(boogieIcfgLocation.getOutgoingEdges()))) {
            return SequentialCompositionType.NONE;
        }
        boolean bl2 = bl = boogieIcfgLocation.getIncomingEdges().stream().allMatch(this::isComposableEdge) && boogieIcfgLocation.getOutgoingEdges().stream().allMatch(this::isComposableEdge);
        if (!bl) {
            return SequentialCompositionType.NONE;
        }
        if (this.mInternalLbeMode == InternalLbeMode.ALL_EXCEPT_ATOMIC_BOUNDARIES && this.mAtomicAnalysis.isAtomicBoundary(boogieIcfgLocation)) {
            return SequentialCompositionType.NONE;
        }
        boolean bl3 = boogieIcfgLocation.getIncomingEdges().size() == 1 && boogieIcfgLocation.getOutgoingEdges().size() == 1;
        boolean bl4 = this.mAtomicAnalysis.isInsideAtomicBlock(boogieIcfgLocation);
        switch (this.mInternalLbeMode) {
            case ALL_EXCEPT_ATOMIC_BOUNDARIES: 
            case ALL: {
                if (bl3) {
                    return SequentialCompositionType.STRAIGHTLINE;
                }
                if (bl4) {
                    return SequentialCompositionType.COMPLEX;
                }
                return SequentialCompositionType.NONE;
            }
            case ATOMIC_BLOCK_AND_INBETWEEN_SEQUENCE_POINTS: {
                throw new UnsupportedOperationException();
            }
            case ONLY_ATOMIC_BLOCK: {
                if (!bl4) {
                    return SequentialCompositionType.NONE;
                }
                if (bl3) {
                    return SequentialCompositionType.STRAIGHTLINE;
                }
                return SequentialCompositionType.COMPLEX;
            }
        }
        throw new AssertionError((Object)("unknown value " + String.valueOf((Object)this.mInternalLbeMode)));
    }

    private boolean isComposableEdge(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof RootEdge || icfgEdge instanceof Call || icfgEdge instanceof Return) {
            return false;
        }
        if (icfgEdge instanceof IIcfgForkTransitionThreadCurrent || icfgEdge instanceof IIcfgForkTransitionThreadOther || icfgEdge instanceof IIcfgJoinTransitionThreadCurrent || icfgEdge instanceof IIcfgJoinTransitionThreadOther) {
            return false;
        }
        assert (icfgEdge instanceof StatementSequence || icfgEdge instanceof SequentialComposition || icfgEdge instanceof ParallelComposition || icfgEdge instanceof Summary || icfgEdge instanceof GotoEdge) : "unexpected type of edge: " + icfgEdge.getClass().getSimpleName();
        return true;
    }

    private List<List<CodeBlock>> computeOutgoingCandidatesForParallelComposition(BoogieIcfgLocation boogieIcfgLocation) {
        return boogieIcfgLocation.getOutgoingEdges().stream().map(CodeBlock.class::cast).filter(this::isParallelComposableEdge).collect(Collectors.groupingBy(codeBlock -> new Pair((Object)((BoogieIcfgLocation)codeBlock.getTarget()), (Object)AtomicBlockInfo.getAnnotatedDelta(codeBlock)))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getValue).toList();
    }

    private boolean isParallelComposableEdge(CodeBlock codeBlock) {
        if (codeBlock instanceof Return || codeBlock instanceof Summary) {
            return false;
        }
        BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)codeBlock.getSource();
        BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)codeBlock.getTarget();
        return switch (this.mInternalLbeMode) {
            case InternalLbeMode.ALL -> true;
            case InternalLbeMode.ALL_EXCEPT_ATOMIC_BOUNDARIES -> {
                boolean var5_6;
                boolean var4_4 = IcfgUtils.isConcurrent((IIcfg)this.mIcfg) && !this.mAtomicAnalysis.isAtomicBegin(boogieIcfgLocation) || this.mAtomicAnalysis.isInsideAtomicBlock(boogieIcfgLocation);
                boolean v1 = var5_6 = IcfgUtils.isConcurrent((IIcfg)this.mIcfg) && !this.mAtomicAnalysis.isAtomicEnd(boogieIcfgLocation2) || this.mAtomicAnalysis.isInsideAtomicBlock(boogieIcfgLocation2);
                if (var4_4 && var5_6) {
                    yield true;
                }
                yield false;
            }
            case InternalLbeMode.ATOMIC_BLOCK_AND_INBETWEEN_SEQUENCE_POINTS -> throw new UnsupportedOperationException();
            case InternalLbeMode.ONLY_ATOMIC_BLOCK -> {
                boolean var5_7;
                boolean var4_5 = this.mAtomicAnalysis.isInsideAtomicBlock(boogieIcfgLocation) || this.mAtomicAnalysis.isAtomicBegin(boogieIcfgLocation);
                boolean v2 = var5_7 = this.mAtomicAnalysis.isInsideAtomicBlock(boogieIcfgLocation2) || this.mAtomicAnalysis.isAtomicEnd(boogieIcfgLocation2);
                if (var4_5 && var5_7) {
                    yield true;
                }
                yield false;
            }
            default -> throw new MatchException(null, null);
        };
    }

    private /* synthetic */ void lambda$0(BoogieIcfgLocation boogieIcfgLocation) {
        this.considerCompositionCandidate(boogieIcfgLocation, true);
    }

    private /* synthetic */ void lambda$1(BoogieIcfgLocation boogieIcfgLocation) {
        this.considerCompositionCandidate(boogieIcfgLocation, true);
    }

    private static /* synthetic */ void lambda$5(Set set, IcfgEdge icfgEdge) {
        boolean bl = set.add((BoogieIcfgLocation)icfgEdge.getSource());
    }

    private static /* synthetic */ void lambda$6(Set set, IcfgEdge icfgEdge) {
        boolean bl = set.add((BoogieIcfgLocation)icfgEdge.getTarget());
    }

    public static enum InternalLbeMode {
        ONLY_ATOMIC_BLOCK,
        ATOMIC_BLOCK_AND_INBETWEEN_SEQUENCE_POINTS,
        ALL_EXCEPT_ATOMIC_BOUNDARIES,
        ALL;

    }

    private static enum SequentialCompositionType {
        NONE,
        STRAIGHTLINE,
        COMPLEX;

    }
}

