/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class GlobalGhostDeclaration
extends CodeStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(GlobalGhostDeclaration.class);
    ACSLType type;
    String identifier;
    Expression expr;

    public GlobalGhostDeclaration(ACSLType aCSLType, String string, Expression expression) {
        this.type = aCSLType;
        this.identifier = string;
        this.expr = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid GlobalGhostDeclaration: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GlobalGhostDeclaration").append('[');
        stringBuffer.append(this.type);
        stringBuffer.append(',').append(this.identifier);
        stringBuffer.append(',').append(this.expr);
        return stringBuffer.append(']').toString();
    }

    public ACSLType getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Expression getExpr() {
        return this.expr;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.type);
        list.add(this.expr);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((CodeStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
            if (this.expr != null) {
                this.expr.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public CodeStatement accept(ACSLTransformer aCSLTransformer) {
        CodeStatement codeStatement = aCSLTransformer.transform(this);
        if (codeStatement != this) {
            return codeStatement;
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        Expression expression = null;
        if (this.expr != null) {
            expression = this.expr.accept(aCSLTransformer);
        }
        if (this.type != aCSLType || this.expr != expression) {
            return new GlobalGhostDeclaration(aCSLType, this.identifier, expression);
        }
        return this;
    }
}

