/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences;

import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.IInlineSelector;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphEdgeLabel;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNode;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.IEdgeFilter;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences.EnableWhen;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences.PreferenceItem;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.preferences.UserListType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class PreferencesInlineSelector
implements IInlineSelector {
    private final boolean mInlineUnimplemented;
    private final EnableWhen mInlineImplemented;
    private final boolean mIgnoreCallForAll;
    private final boolean mIgnoreRecursive;
    private final boolean mIgnoreWithFreeRequires;
    private final boolean mIgnorePolymorphic;
    private final EnableWhen mIgnoreMultipleCalled;
    private final Collection<String> mUserList;
    private final UserListType mUserListType;
    private boolean mProgramIsConcurrent;
    private final IEdgeFilter<CallGraphNode, CallGraphEdgeLabel> mGeneralSettingsFilter;
    private final IEdgeFilter<CallGraphNode, CallGraphEdgeLabel> mUserListFilter;
    private Map<String, CallGraphEdgeLabel> mLastInlinedCall;

    public PreferencesInlineSelector(IUltimateServiceProvider iUltimateServiceProvider) {
        IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mInlineUnimplemented = iPreferenceProvider.getBoolean(PreferenceItem.INLINE_UNIMPLEMENTED.getName());
        this.mInlineImplemented = (EnableWhen)iPreferenceProvider.getEnum(PreferenceItem.INLINE_IMPLEMENTED.getName(), EnableWhen.class);
        this.mIgnoreCallForAll = iPreferenceProvider.getBoolean(PreferenceItem.IGNORE_CALL_FORALL.getName());
        this.mUserList = new HashSet<String>(PreferenceItem.USER_LIST.getStringValueTokens(iUltimateServiceProvider));
        this.mUserListType = (UserListType)iPreferenceProvider.getEnum(PreferenceItem.USER_LIST_TYPE.getName(), UserListType.class);
        this.mIgnoreRecursive = iPreferenceProvider.getBoolean(PreferenceItem.IGNORE_RECURSIVE.getName());
        this.mIgnoreWithFreeRequires = iPreferenceProvider.getBoolean(PreferenceItem.IGNORE_WITH_FREE_REQUIRES.getName());
        this.mIgnorePolymorphic = iPreferenceProvider.getBoolean(PreferenceItem.IGNORE_MULTIPLE_CALLED.getName());
        this.mIgnoreMultipleCalled = (EnableWhen)iPreferenceProvider.getEnum(PreferenceItem.IGNORE_MULTIPLE_CALLED.getName(), EnableWhen.class);
        this.mGeneralSettingsFilter = new GeneralSettingsFilter();
        this.mUserListFilter = new UserListFilter();
    }

    @Override
    public void setInlineFlags(Map<String, CallGraphNode> map, boolean bl) {
        this.mProgramIsConcurrent = bl;
        this.mLastInlinedCall = new HashMap<String, CallGraphEdgeLabel>();
        ArrayList<IEdgeFilter<CallGraphNode, CallGraphEdgeLabel>> arrayList = new ArrayList<IEdgeFilter<CallGraphNode, CallGraphEdgeLabel>>(2);
        if (!this.mUserListType.isOnly()) {
            arrayList.add(this.mGeneralSettingsFilter);
        }
        if (this.mUserListType != UserListType.DISABLED) {
            arrayList.add(this.mUserListFilter);
        }
        for (IEdgeFilter iEdgeFilter : arrayList) {
            for (CallGraphNode callGraphNode : map.values()) {
                Iterator iterator = callGraphNode.getOutgoingEdgeLabels().iterator();
                Iterator iterator2 = callGraphNode.getOutgoingNodes().iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    CallGraphEdgeLabel callGraphEdgeLabel = (CallGraphEdgeLabel)iterator.next();
                    CallGraphNode callGraphNode2 = (CallGraphNode)((Object)iterator2.next());
                    callGraphEdgeLabel.setInlineFlag(iEdgeFilter.accept(callGraphNode, callGraphEdgeLabel, callGraphNode2));
                }
                assert (iterator.hasNext() == iterator2.hasNext());
            }
        }
    }

    private final class GeneralSettingsFilter
    implements IEdgeFilter<CallGraphNode, CallGraphEdgeLabel> {
        private GeneralSettingsFilter() {
        }

        @Override
        public boolean accept(CallGraphNode callGraphNode, CallGraphEdgeLabel callGraphEdgeLabel, CallGraphNode callGraphNode2) {
            if (PreferencesInlineSelector.this.mIgnoreWithFreeRequires && this.hasFreeRequiresSpecification(callGraphNode2)) {
                return false;
            }
            if (PreferencesInlineSelector.this.mIgnorePolymorphic && (callGraphNode.isPolymorphic() || callGraphNode2.isPolymorphic())) {
                return false;
            }
            if (PreferencesInlineSelector.this.mIgnoreRecursive && callGraphEdgeLabel.getEdgeType().isRecursive()) {
                return false;
            }
            if (PreferencesInlineSelector.this.mIgnoreCallForAll && callGraphEdgeLabel.getEdgeType() == CallGraphEdgeLabel.EdgeType.CALL_FORALL) {
                return false;
            }
            if (callGraphEdgeLabel.getEdgeType() == CallGraphEdgeLabel.EdgeType.FORK) {
                return false;
            }
            return this.acceptNormalCall(callGraphEdgeLabel, callGraphNode2);
        }

        private boolean acceptNormalCall(CallGraphEdgeLabel callGraphEdgeLabel, CallGraphNode callGraphNode) {
            boolean bl;
            boolean bl2 = callGraphNode.isImplemented();
            boolean bl3 = bl = !bl2 && PreferencesInlineSelector.this.mInlineUnimplemented || bl2 && PreferencesInlineSelector.this.mInlineImplemented.isEnabled(PreferencesInlineSelector.this.mProgramIsConcurrent);
            if (!bl || !PreferencesInlineSelector.this.mIgnoreMultipleCalled.isEnabled(PreferencesInlineSelector.this.mProgramIsConcurrent)) {
                return bl;
            }
            CallGraphEdgeLabel callGraphEdgeLabel2 = PreferencesInlineSelector.this.mLastInlinedCall.put(callGraphNode.getId(), callGraphEdgeLabel);
            if (callGraphEdgeLabel2 != null) {
                callGraphEdgeLabel2.setInlineFlag(false);
                return false;
            }
            return true;
        }

        private boolean hasFreeRequiresSpecification(CallGraphNode callGraphNode) {
            Specification[] specificationArray = callGraphNode.getProcedureWithSpecification().getSpecification();
            int n = specificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Specification specification = specificationArray[n2];
                if (specification instanceof RequiresSpecification && specification.isFree()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private final class UserListFilter
    implements IEdgeFilter<CallGraphNode, CallGraphEdgeLabel> {
        private UserListFilter() {
        }

        @Override
        public boolean accept(CallGraphNode callGraphNode, CallGraphEdgeLabel callGraphEdgeLabel, CallGraphNode callGraphNode2) {
            boolean bl = callGraphEdgeLabel.getInlineFlag();
            boolean bl2 = PreferencesInlineSelector.this.mUserList.contains(callGraphNode2.getId());
            return switch (PreferencesInlineSelector.this.mUserListType) {
                case UserListType.BLACKLIST_ONLY -> {
                    if (bl2) {
                        yield false;
                    }
                    yield true;
                }
                case UserListType.BLACKLIST_RESTRICT -> {
                    if (bl && !bl2) {
                        yield true;
                    }
                    yield false;
                }
                case UserListType.DISABLED -> bl;
                case UserListType.WHITELIST_EXTEND -> {
                    if (!bl && !bl2) {
                        yield false;
                    }
                    yield true;
                }
                case UserListType.WHITELIST_ONLY -> bl2;
                case UserListType.WHITELIST_RESTRICT -> {
                    if (bl && bl2) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new MatchException(null, null);
            };
        }
    }
}

