/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.NAryEvaluator;
import java.util.ArrayList;
import java.util.Collection;

public class UnaryExpressionEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends IAbstractState<STATE>>
extends NAryEvaluator<VALUE, STATE> {
    private final EvaluatorLogger mLogger;
    private UnaryExpression.Operator mOperator;
    private final VALUE mTopValue;

    public UnaryExpressionEvaluator(EvaluatorLogger evaluatorLogger, int n, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory) {
        super(n, iNonrelationalValueFactory, evaluatorLogger);
        this.mLogger = evaluatorLogger;
        this.mTopValue = iNonrelationalValueFactory.createTopValue();
    }

    @Override
    public Collection<IEvaluationResult<VALUE>> evaluate(STATE STATE) {
        assert (STATE != null);
        ArrayList arrayList = new ArrayList();
        Collection collection = this.getSubEvaluator(0).evaluate(STATE, this.getCurrentEvaluationRecursion() + 1);
        for (IEvaluationResult iEvaluationResult : collection) {
            BooleanValue booleanValue;
            NonrelationalEvaluationResult nonrelationalEvaluationResult = new NonrelationalEvaluationResult(switch (this.mOperator) {
                case UnaryExpression.Operator.ARITHNEGATIVE -> {
                    booleanValue = BooleanValue.INVALID;
                    yield ((INonrelationalValue)iEvaluationResult.getValue()).negate();
                }
                case UnaryExpression.Operator.LOGICNEG -> {
                    booleanValue = iEvaluationResult.getBooleanValue().neg();
                    yield this.mTopValue;
                }
                default -> {
                    this.mLogger.warnUnknownOperator(this.mOperator);
                    booleanValue = BooleanValue.TOP;
                    yield this.mTopValue;
                }
            }, booleanValue);
            this.mLogger.logEvaluation(this.mOperator, nonrelationalEvaluationResult, iEvaluationResult);
            arrayList.add(nonrelationalEvaluationResult);
        }
        assert (!arrayList.isEmpty());
        return NonrelationalUtils.mergeIfNecessary(arrayList, 2);
    }

    @Override
    public Collection<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult, STATE STATE) {
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)iEvaluationResult.getValue();
        BooleanValue booleanValue = iEvaluationResult.getBooleanValue();
        switch (this.mOperator) {
            case ARITHNEGATIVE: {
                iNonrelationalValue = ((INonrelationalValue)iEvaluationResult.getValue()).negate();
                break;
            }
            case LOGICNEG: {
                booleanValue = iEvaluationResult.getBooleanValue().neg();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operator " + this.mOperator + " not supported.");
            }
        }
        NonrelationalEvaluationResult<INonrelationalValue> nonrelationalEvaluationResult = new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue, booleanValue);
        this.mLogger.logInverseEvaluation(this.mOperator, nonrelationalEvaluationResult, iEvaluationResult);
        return this.getSubEvaluator(0).inverseEvaluate(nonrelationalEvaluationResult, STATE, this.getCurrentInverseEvaluationRecursion() + 1);
    }

    @Override
    public boolean hasFreeOperands() {
        return this.getNumberOfSubEvaluators() == 0;
    }

    @Override
    public boolean containsBool() {
        return this.getSubEvaluator(0).containsBool();
    }

    @Override
    public void setOperator(Object object) {
        assert (object != null);
        assert (object instanceof UnaryExpression.Operator);
        this.mOperator = (UnaryExpression.Operator)object;
    }

    @Override
    public int getArity() {
        return 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.mOperator) {
            case LOGICNEG: {
                stringBuilder.append('!');
                break;
            }
            case OLD: {
                stringBuilder.append("old(");
                break;
            }
            case ARITHNEGATIVE: {
                stringBuilder.append('-');
            }
        }
        stringBuilder.append(this.getSubEvaluator(0));
        if (this.mOperator == UnaryExpression.Operator.OLD) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public EvaluatorUtils.EvaluatorType getType() {
        return this.getSubEvaluator(0).getType();
    }
}

