/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TermTransferrerBooleanCore
extends TermTransferrer {
    private final Term mAuxiliaryTerm;
    private static final String FRESH_TERM_PREFIX = "FBV_";
    private int mFreshTermCounter = 0;
    private final ConstructionCache<Term, Term> mConstructionCache;
    private final Map<Term, Term> mBacktransferMapping = new HashMap<Term, Term>();

    public TermTransferrerBooleanCore(Script script, Script script2) {
        super(script, script2);
        this.mAuxiliaryTerm = this.constructAuxiliaryTerm();
        this.mConstructionCache = new ConstructionCache(this::constructTerm);
    }

    public Map<Term, Term> getBacktransferMapping() {
        return this.mBacktransferMapping;
    }

    private Term constructAuxiliaryTerm() {
        String string = ((Object)((Object)this)).getClass().getCanonicalName() + "_AUX";
        this.mNewScript.declareFun(string, new Sort[0], SmtSortUtils.getBoolSort((Script)this.mNewScript));
        return this.mNewScript.term(string, new Term[0]);
    }

    private Term constructTerm(Term term) {
        String string = FRESH_TERM_PREFIX + this.mFreshTermCounter;
        ++this.mFreshTermCounter;
        this.mNewScript.declareFun(string, new Sort[0], SmtSortUtils.getBoolSort((Script)this.mNewScript));
        Term term2 = this.mNewScript.term(string, new Term[0]);
        this.mBacktransferMapping.put(term2, term);
        return term2;
    }

    @Override
    protected void convert(Term term) {
        if (!SmtSortUtils.isBoolSort(term.getSort())) {
            this.setResult(this.mAuxiliaryTerm);
        } else if (term instanceof QuantifiedFormula) {
            Term term2 = (Term)this.mConstructionCache.getOrConstruct((Object)term);
            this.setResult(term2);
        } else {
            super.convert(term);
        }
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        if (Arrays.asList(termArray).contains(this.mAuxiliaryTerm)) {
            Term term = (Term)this.mConstructionCache.getOrConstruct((Object)applicationTerm);
            this.setResult(term);
        } else {
            super.convertApplicationTerm(applicationTerm, termArray);
        }
    }
}

