/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.AddSymbols;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.DNF;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.MatchInOutVars;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RemoveNegation;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteBooleans;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteDivision;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteEquality;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteIte;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteStrictInequalities;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteTrueFalse;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteUserDefinedTypes;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.SimplifyPreprocessor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import java.util.HashMap;
import java.util.Map;

public class CachedTransFormulaLinearizer {
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final SmtFunctionsAndAxioms mSmtSymbols;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final CfgSmtToolkit mCsToolkit;
    private final Map<UnmodifiableTransFormula, LinearTransition> mCache;

    public CachedTransFormulaLinearizer(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, SmtFunctionsAndAxioms smtFunctionsAndAxioms, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mCsToolkit = cfgSmtToolkit;
        this.mReplacementVarFactory = new ReplacementVarFactory(cfgSmtToolkit, false);
        this.mSmtSymbols = smtFunctionsAndAxioms;
        this.mCache = new HashMap<UnmodifiableTransFormula, LinearTransition>();
    }

    public LinearTransition linearize(UnmodifiableTransFormula unmodifiableTransFormula) {
        LinearTransition linearTransition = this.mCache.get(unmodifiableTransFormula);
        if (linearTransition == null) {
            linearTransition = this.makeLinear(unmodifiableTransFormula);
            this.mCache.put(unmodifiableTransFormula, linearTransition);
        }
        return linearTransition;
    }

    private LinearTransition makeLinear(UnmodifiableTransFormula unmodifiableTransFormula) {
        TransitionPreprocessor transitionPreprocessor;
        ModifiableTransFormula modifiableTransFormula = ModifiableTransFormulaUtils.buildTransFormula((TransFormula)unmodifiableTransFormula, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mCsToolkit.getManagedScript());
        TransitionPreprocessor[] transitionPreprocessorArray = this.getPreprocessors();
        int n = transitionPreprocessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            transitionPreprocessor = transitionPreprocessorArray[n2];
            try {
                modifiableTransFormula = transitionPreprocessor.process(this.mCsToolkit.getManagedScript(), modifiableTransFormula);
            }
            catch (TermException termException) {
                throw new RuntimeException(termException);
            }
            ++n2;
        }
        try {
            transitionPreprocessor = LinearTransition.fromTransFormulaLR((ModifiableTransFormula)modifiableTransFormula, (InequalityConverter.NlaHandling)InequalityConverter.NlaHandling.EXCEPTION);
        }
        catch (TermException termException) {
            throw new RuntimeException(termException);
        }
        return transitionPreprocessor;
    }

    private TransitionPreprocessor[] getPreprocessors() {
        return new TransitionPreprocessor[]{new MatchInOutVars(), new AddSymbols(this.mReplacementVarFactory, this.mSmtSymbols), new RewriteDivision(this.mReplacementVarFactory), new RewriteBooleans(this.mReplacementVarFactory, this.mCsToolkit.getManagedScript()), new RewriteIte(), new RewriteUserDefinedTypes(this.mReplacementVarFactory, this.mCsToolkit.getManagedScript()), new RewriteEquality(), new SimplifyPreprocessor(this.mServices, this.mSimplificationTechnique), new DNF(this.mServices), new SimplifyPreprocessor(this.mServices, this.mSimplificationTechnique), new RewriteTrueFalse(), new RemoveNegation(), new RewriteStrictInequalities()};
    }
}

