/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OldVarsAssignmentCache {
    protected final ManagedScript mMgdScript;
    private final ModifiableGlobalsTable mModifiableGlobalsTable;
    private final Map<String, UnmodifiableTransFormula> mProc2OldVarsAssignment;
    private final Map<String, UnmodifiableTransFormula> mProc2GlobalVarsAssignment;

    public OldVarsAssignmentCache(ManagedScript managedScript, ModifiableGlobalsTable modifiableGlobalsTable) {
        this.mMgdScript = managedScript;
        this.mModifiableGlobalsTable = modifiableGlobalsTable;
        this.mProc2OldVarsAssignment = new HashMap<String, UnmodifiableTransFormula>();
        this.mProc2GlobalVarsAssignment = new HashMap<String, UnmodifiableTransFormula>();
    }

    public UnmodifiableTransFormula getOldVarsAssignment(String string) {
        UnmodifiableTransFormula unmodifiableTransFormula = this.mProc2OldVarsAssignment.get(string);
        if (unmodifiableTransFormula == null) {
            unmodifiableTransFormula = this.constructOldVarsAssignment(string);
            this.mProc2OldVarsAssignment.put(string, unmodifiableTransFormula);
        }
        return this.mProc2OldVarsAssignment.get(string);
    }

    public UnmodifiableTransFormula getGlobalVarsAssignment(String string) {
        UnmodifiableTransFormula unmodifiableTransFormula = this.mProc2GlobalVarsAssignment.get(string);
        if (unmodifiableTransFormula == null) {
            unmodifiableTransFormula = this.constructGlobalVarsAssignment(string);
            this.mProc2GlobalVarsAssignment.put(string, unmodifiableTransFormula);
        }
        return this.mProc2GlobalVarsAssignment.get(string);
    }

    private UnmodifiableTransFormula constructOldVarsAssignment(String string) {
        Set<IProgramNonOldVar> set = this.mModifiableGlobalsTable.getModifiedBoogieVars(string);
        if (set == null) {
            set = Collections.emptySet();
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, true, null, true, null, true);
        Term term = this.mMgdScript.getScript().term("true", new Term[0]);
        for (IProgramNonOldVar iProgramNonOldVar : set) {
            IProgramOldVar iProgramOldVar = iProgramNonOldVar.getOldVar();
            Sort sort = iProgramNonOldVar.getDefaultConstant().getSort();
            String string2 = String.valueOf(iProgramNonOldVar) + "_In";
            TermVariable termVariable = this.mMgdScript.getScript().variable(string2, sort);
            String string3 = "old(" + String.valueOf(iProgramNonOldVar) + ")_Out";
            TermVariable termVariable2 = this.mMgdScript.getScript().variable(string3, sort);
            transFormulaBuilder.addInVar(iProgramNonOldVar, termVariable);
            transFormulaBuilder.addOutVar(iProgramNonOldVar, termVariable);
            transFormulaBuilder.addOutVar(iProgramOldVar, termVariable2);
            Term term2 = SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)termVariable2, (Term)termVariable);
            term = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{term, term2});
        }
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return transFormulaBuilder.finishConstruction(this.mMgdScript);
    }

    private UnmodifiableTransFormula constructGlobalVarsAssignment(String string) {
        Set<IProgramNonOldVar> set = this.mModifiableGlobalsTable.getModifiedBoogieVars(string);
        if (set == null) {
            set = Collections.emptySet();
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, true, null, true, null, true);
        Term term = this.mMgdScript.getScript().term("true", new Term[0]);
        for (IProgramNonOldVar iProgramNonOldVar : set) {
            IProgramOldVar iProgramOldVar = iProgramNonOldVar.getOldVar();
            Sort sort = iProgramNonOldVar.getDefaultConstant().getSort();
            String string2 = "old(" + String.valueOf(iProgramNonOldVar) + ")_In";
            TermVariable termVariable = this.mMgdScript.getScript().variable(string2, sort);
            String string3 = String.valueOf(iProgramNonOldVar) + "_Out";
            TermVariable termVariable2 = this.mMgdScript.getScript().variable(string3, sort);
            transFormulaBuilder.addInVar(iProgramOldVar, termVariable);
            transFormulaBuilder.addOutVar(iProgramOldVar, termVariable);
            transFormulaBuilder.addOutVar(iProgramNonOldVar, termVariable2);
            Term term2 = SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)termVariable2, (Term)termVariable);
            term = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{term, term2});
        }
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return transFormulaBuilder.finishConstruction(this.mMgdScript);
    }
}

