/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class SymbolicMemory {
    protected final ManagedScript mScript;
    protected final Map<IProgramVar, TermVariable> mInVars;
    protected final Map<IProgramVar, TermVariable> mOutVars;
    protected final Map<TermVariable, Term> mVariableTerms;
    protected boolean mOverapproximation;

    protected SymbolicMemory(ManagedScript managedScript) {
        this.mScript = managedScript;
        this.mInVars = new HashMap<IProgramVar, TermVariable>();
        this.mOutVars = new HashMap<IProgramVar, TermVariable>();
        this.mVariableTerms = new HashMap<TermVariable, Term>();
    }

    public SymbolicMemory(ManagedScript managedScript, TransFormula transFormula, boolean bl) {
        this.mScript = managedScript;
        this.mInVars = transFormula.getInVars();
        this.mOutVars = transFormula.getOutVars();
        this.mVariableTerms = new HashMap<TermVariable, Term>();
        this.mOverapproximation = bl;
        Term term = transFormula.getFormula();
        if (!(term instanceof ApplicationTerm)) {
            return;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if ("and".equals(applicationTerm.getFunction().getName())) {
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term[] termArray2;
                Term term2 = termArray[n2];
                if (term2 instanceof ApplicationTerm && "=".equals(((ApplicationTerm)term2).getFunction().getName()) && (termArray2 = ((ApplicationTerm)term2).getParameters())[0] instanceof TermVariable && !this.mInVars.containsValue(termArray2[0]) && !this.mVariableTerms.containsKey(termArray2[0])) {
                    this.mVariableTerms.put((TermVariable)termArray2[0], termArray2[1]);
                }
                ++n2;
            }
        }
    }

    public Term replaceTermVars(Term term, Map<IProgramVar, TermVariable> map) {
        if (this.mVariableTerms.containsKey(term)) {
            Term term2 = this.mVariableTerms.get(term);
            return term2 == null ? term : this.replaceTermVars(term2, map);
        }
        if (map != null && map.containsValue(term)) {
            for (Map.Entry object : map.entrySet()) {
                if (object.getValue() != term || !this.mOutVars.containsKey(object.getKey())) continue;
                return this.replaceTermVars((Term)this.mOutVars.get(object.getKey()), map);
            }
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            Term[] termArray = (Term[])applicationTerm.getParameters().clone();
            int n = 0;
            while (n < termArray.length) {
                termArray[n] = this.replaceTermVars(termArray[n], map);
                ++n;
            }
            if ("=".equals(applicationTerm.getFunction().getName()) && termArray.length == 2 && termArray[0].equals(termArray[1])) {
                return this.mScript.getScript().term("true", new Term[0]);
            }
            return this.mScript.getScript().term(applicationTerm.getFunction().getName(), termArray);
        }
        return term;
    }

    public Term toTerm() {
        Term term = this.mScript.getScript().term("true", new Term[0]);
        for (Map.Entry<TermVariable, Term> entry : this.mVariableTerms.entrySet()) {
            term = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term, this.mScript.getScript().term("=", new Term[]{(Term)entry.getKey(), entry.getValue()})});
        }
        return term;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public Map<TermVariable, Term> getVariableTerms() {
        return this.mVariableTerms;
    }

    public Term getVariableTerm(IProgramVar iProgramVar) {
        if (!this.mOutVars.containsKey(iProgramVar)) {
            return null;
        }
        return this.getVariableTerm(this.mOutVars.get(iProgramVar));
    }

    public Term getVariableTerm(TermVariable termVariable) {
        return this.mVariableTerms.get(termVariable);
    }

    public boolean isOverapproximation() {
        return this.mOverapproximation;
    }

    public String toString() {
        return this.mVariableTerms.toString();
    }
}

