/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.chctoboogie;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcPreMetaInfoProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClauseAST;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.ITerm2ExpressionSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Term2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.plugins.chctoboogie.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.chctoboogie.GenerateBoogieAst;
import de.uni_freiburg.informatik.ultimate.plugins.chctoboogie.GenerateBoogieAstHelper;
import de.uni_freiburg.informatik.ultimate.plugins.chctoboogie.GenerateGotoBoogieAst;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.List;

public class ChcToBoogieObserver
implements IUnmanagedObserver {
    private static final String GOTO_VAR_NAME = "gotoSwitch";
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private Unit mBoogieUnit;
    private Term2Expression mTerm2Expression;
    private final String mNameOfMainEntryPointProc;
    private ManagedScript mManagedScript;
    private TypeSortTranslator mTypeSortTanslator;
    private HcSymbolTable mHcSymbolTable;
    private final ILocation mLocation;
    private final IPreferenceProvider mPrefs;

    public ChcToBoogieObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mNameOfMainEntryPointProc = "Ultimate.START";
        this.mLocation = new BoogieLocation(this.getClass().getName(), 0, 0, 0, 0);
        this.mPrefs = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public void finish() throws Throwable {
    }

    public boolean performedChanges() {
        return false;
    }

    public IElement getModel() {
        return this.mBoogieUnit;
    }

    public boolean process(IElement iElement) throws Exception {
        if (!(iElement instanceof HornClauseAST)) {
            return true;
        }
        HornAnnot hornAnnot = HornAnnot.getAnnotation((IElement)iElement);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Printing the following HornClause set:");
            this.mLogger.debug((Object)hornAnnot);
        }
        if (!hornAnnot.hasCheckSat()) {
            this.generateDummyBoogieAst();
            return true;
        }
        List list = hornAnnot.getHornClauses();
        this.mManagedScript = hornAnnot.getScript();
        this.mHcSymbolTable = hornAnnot.getSymbolTable();
        HashRelation hashRelation = new HashRelation();
        hashRelation.addPair((Object)this.mManagedScript.getScript().sort("Int", new Sort[0]), (Object)BoogieType.TYPE_INT);
        hashRelation.addPair((Object)this.mManagedScript.getScript().sort("Real", new Sort[0]), (Object)BoogieType.TYPE_REAL);
        hashRelation.addPair((Object)this.mManagedScript.getScript().sort("Bool", new Sort[0]), (Object)BoogieType.TYPE_BOOL);
        this.mTypeSortTanslator = new TypeSortTranslator(hashRelation, this.mManagedScript.getScript(), this.mServices);
        this.mTerm2Expression = new Term2Expression(this.mTypeSortTanslator, (ITerm2ExpressionSymbolTable)this.mHcSymbolTable, this.mManagedScript);
        hashRelation = new ChcPreMetaInfoProvider(list, this.mHcSymbolTable);
        GenerateBoogieAstHelper generateBoogieAstHelper = new GenerateBoogieAstHelper(this.mLocation, this.mHcSymbolTable, this.mTerm2Expression, this.mTypeSortTanslator, this.mNameOfMainEntryPointProc);
        if (this.mPrefs.getBoolean("Use one large procedure with gotos to replace tail recursive calls")) {
            this.mHcSymbolTable.setGotoProcMode(true);
            this.mBoogieUnit = new GenerateGotoBoogieAst((ChcPreMetaInfoProvider)hashRelation, generateBoogieAstHelper, GOTO_VAR_NAME).getResult();
        } else {
            this.mHcSymbolTable.setGotoProcMode(false);
            this.mBoogieUnit = new GenerateBoogieAst((HashRelation<HcPredicateSymbol, HornClause>)hashRelation.getHornClausesSorted(), generateBoogieAstHelper).getResult();
        }
        return true;
    }

    private void generateDummyBoogieAst() {
        Body body = new Body(this.mLocation, new VariableDeclaration[0], new Statement[0]);
        Procedure procedure = new Procedure(this.mLocation, new Attribute[0], this.mNameOfMainEntryPointProc, new String[0], new VarList[0], new VarList[0], new Specification[0], body);
        this.mBoogieUnit = new Unit(this.mLocation, new Declaration[]{procedure});
    }
}

