/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class Literal {
    private final Term mAtom;
    private final Polarity mPolarity;

    public Literal(Term term) {
        if (!SmtSortUtils.isBoolSort(term.getSort())) {
            throw new IllegalArgumentException("only applicable to sort Bool");
        }
        Term term2 = null;
        int n = 0;
        do {
            if ((term2 = Literal.getParameterOfNotTerm(term)) == null) continue;
            term = term2;
            ++n;
        } while (term2 != null);
        this.mPolarity = n % 2 == 0 ? Polarity.POSITIVE : Polarity.NEGATIVE;
        this.mAtom = term;
    }

    public Term getAtom() {
        return this.mAtom;
    }

    public Polarity getPolarity() {
        return this.mPolarity;
    }

    public Term toTerm(Script script) {
        if (this.mPolarity == Polarity.POSITIVE) {
            return this.mAtom;
        }
        return script.term("not", new Term[]{this.mAtom});
    }

    public static Term getParameterOfNotTerm(Term term) {
        ApplicationTerm applicationTerm;
        if (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getFunction().getName().equals("not")) {
            assert (applicationTerm.getParameters().length == 1);
            return applicationTerm.getParameters()[0];
        }
        return null;
    }

    public static enum Polarity {
        POSITIVE,
        NEGATIVE;

    }
}

