/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.Diet;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPStatistics;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceEdgeLabel;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.util.VMUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcAuxData;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IElementRemovalTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IEqualityReportingTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class WeqCongruenceClosure<NODE extends IEqNodeIdentifier<NODE>>
implements IEqualityReportingTarget<NODE>,
IElementRemovalTarget<NODE> {
    private CongruenceClosure<NODE> mCongruenceClosure;
    private WeakEquivalenceGraph<NODE> mWeakEquivalenceGraphThin;
    private WeakEquivalenceGraph<NODE> mWeakEquivalenceGraphCcFat;
    private boolean mIsWeqFatEdgeLabel;
    private boolean mIsFrozen = false;
    private boolean mIsClosed = true;
    private final ILogger mLogger;
    private final WeqCcManager<NODE> mManager;
    Diet mDiet;

    public WeqCongruenceClosure(WeqCcManager<NODE> weqCcManager) {
        assert (weqCcManager != null);
        this.mLogger = weqCcManager.getLogger();
        this.mManager = weqCcManager;
        this.mCongruenceClosure = weqCcManager.getEmptyCc(true);
        this.mWeakEquivalenceGraphThin = new WeakEquivalenceGraph<NODE>(this, weqCcManager, weqCcManager.getEmptyCc(false));
        this.mDiet = Diet.THIN;
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    public WeqCongruenceClosure(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("use other constructor!");
        }
        this.mCongruenceClosure = null;
        this.mManager = null;
        this.mLogger = null;
        this.mIsFrozen = true;
    }

    public WeqCongruenceClosure(CongruenceClosure<NODE> congruenceClosure, WeakEquivalenceGraph<NODE> weakEquivalenceGraph, WeqCcManager<NODE> weqCcManager) {
        assert (!congruenceClosure.isFrozen());
        this.mLogger = weqCcManager.getLogger();
        this.mCongruenceClosure = weqCcManager.copyCcNoRemInfo(congruenceClosure);
        assert (weqCcManager != null);
        if (congruenceClosure.isInconsistent(false)) {
            throw new IllegalArgumentException("use other constructor!");
        }
        this.mManager = weqCcManager;
        this.mWeakEquivalenceGraphThin = new WeakEquivalenceGraph<NODE>(this, weakEquivalenceGraph);
        this.mDiet = Diet.THIN;
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    public WeqCongruenceClosure(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        this.mLogger = weqCongruenceClosure.getLogger();
        this.mManager = weqCongruenceClosure.mManager;
        this.mCongruenceClosure = this.mManager.copyCc(weqCongruenceClosure.mCongruenceClosure, true);
        assert (!this.mCongruenceClosure.isFrozen());
        assert (weqCongruenceClosure.mManager != null);
        if (weqCongruenceClosure.mDiet != Diet.TRANSITORY_THIN_TO_CCFAT && weqCongruenceClosure.mDiet != Diet.THIN) {
            throw new AssertionError();
        }
        this.mIsWeqFatEdgeLabel = weqCongruenceClosure.mIsWeqFatEdgeLabel;
        this.mDiet = weqCongruenceClosure.mDiet;
        this.mWeakEquivalenceGraphThin = new WeakEquivalenceGraph<NODE>(this, weqCongruenceClosure.mWeakEquivalenceGraphThin);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
        assert (!this.mIsFrozen);
    }

    public boolean addElement(NODE NODE, boolean bl) {
        assert (!this.isFrozen());
        this.addElementRec(NODE);
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (bl || this.sanityCheck());
        this.mIsClosed = false;
        this.reportAllConstraintsFromWeqGraph(bl);
        assert (bl || this.sanityCheck());
        return true;
    }

    public boolean isFrozen() {
        assert (this.isInconsistent(false) || this.mIsFrozen == this.mCongruenceClosure.isFrozen());
        return this.mIsFrozen;
    }

    public void freezeOmitPropagations() {
        if (this.mCongruenceClosure != null) {
            this.mManager.getCcManager().freezeIfNecessary(this.mCongruenceClosure);
        }
        if (!this.isInconsistent(false)) {
            this.getWeakEquivalenceGraph().freezeIfNecessary();
        }
        this.mIsFrozen = true;
    }

    public void freezeAndClose() {
        this.mManager.bmStart(WeqCcManager.WeqCcBmNames.FREEZE_AND_CLOSE);
        assert (!this.mIsFrozen);
        this.extAndTriangleClosure(false);
        this.freezeOmitPropagations();
        this.mManager.bmEnd(WeqCcManager.WeqCcBmNames.FREEZE_AND_CLOSE);
    }

    public boolean isInconsistent() {
        return this.isInconsistent(this.mManager.getSettings().closeBeforeIsInconsistentCheck());
    }

    public boolean isInconsistent(boolean bl) {
        if (bl) {
            this.mManager.closeIfNecessary(this);
        }
        return this.mCongruenceClosure == null || this.mCongruenceClosure.isInconsistent();
    }

    public void reportWeakEquivalence(NODE NODE, NODE NODE2, NODE NODE3, boolean bl) {
        assert (!this.isFrozen());
        assert (NODE.hasSameTypeAs(NODE2));
        this.mManager.addNode(NODE3, this, true, true);
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (this.sanityCheck());
        this.reportWeakEquivalence(NODE, NODE2, this.mManager.getEdgeLabelForIndex(this.getWeakEquivalenceGraph(), NODE3), bl);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    private void reportWeakEquivalence(NODE NODE, NODE NODE2, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, boolean bl) {
        assert (!this.isFrozen());
        if (this.isInconsistent(false)) {
            return;
        }
        this.reportWeakEquivalenceDoOnlyRoweqPropagations(NODE, NODE2, weakEquivalenceEdgeLabel, bl);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    boolean executeFloydWarshallAndReportResultToWeqCc(boolean bl) {
        if (this.isInconsistent(false)) {
            return false;
        }
        WeqCongruenceClosure weqCongruenceClosure = null;
        if (VMUtils.areAssertionsEnabled() && this.mManager.mDebug) {
            this.mManager.getClass();
        }
        boolean bl2 = false;
        Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> map = this.getCcWeakEquivalenceGraph().propagateViaTriangleRule();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : map.entrySet()) {
            bl2 |= this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)entry.getKey().getOneElement(), (IEqNodeIdentifier)entry.getKey().getOtherElement(), entry.getValue(), bl);
            if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (bl || this.sanityCheck());
        }
        assert (this.mManager.checkEquivalence(weqCongruenceClosure, this));
        assert (bl || this.sanityCheck());
        return bl2;
    }

    private boolean reportWeakEquivalenceDoOnlyRoweqPropagations(NODE NODE, NODE NODE2, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, boolean bl) {
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel2;
        assert (!this.isFrozen());
        assert (!this.mManager.getSettings().isDeactivateWeakEquivalences());
        assert (!NODE.dependsOnUntrackedArray());
        assert (!NODE2.dependsOnUntrackedArray());
        if (this.isInconsistent(false)) {
            return false;
        }
        if (weakEquivalenceEdgeLabel.isTautological()) {
            return false;
        }
        boolean bl2 = false;
        bl2 |= !this.mCongruenceClosure.hasElement(NODE);
        bl2 |= !this.mCongruenceClosure.hasElement(NODE2);
        this.mManager.addNode(NODE, this, true, bl);
        this.mManager.addNode(NODE2, this, true, bl);
        IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE);
        IEqNodeIdentifier iEqNodeIdentifier3 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE2);
        if (iEqNodeIdentifier2 == iEqNodeIdentifier3) {
            return bl2;
        }
        boolean bl3 = this.getCcWeakEquivalenceGraph().reportWeakEquivalence(iEqNodeIdentifier2, iEqNodeIdentifier3, weakEquivalenceEdgeLabel, bl);
        if (!bl3) {
            return bl2;
        }
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel3 = this.getCcWeakEquivalenceGraph().getEdgeLabel(iEqNodeIdentifier2, iEqNodeIdentifier3);
        if (weakEquivalenceEdgeLabel3 == null) {
            throw new AssertionError((Object)"TODO : check this case, this does not happen, right? (and the comment above is nonsense..)");
        }
        if (this.isInconsistent(false)) {
            return true;
        }
        iEqNodeIdentifier2 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE);
        iEqNodeIdentifier3 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE2);
        CongruenceClosure.constantAndMixFunctionTreatmentOnAddEquality((ICongruenceClosureElement)iEqNodeIdentifier2, (ICongruenceClosureElement)iEqNodeIdentifier3, (Set)this.mCongruenceClosure.getEquivalenceClass(NODE), (Set)this.mCongruenceClosure.getEquivalenceClass(NODE2), (CcAuxData)this.mCongruenceClosure.getAuxData(), iEqNodeIdentifier -> {
            WeqCongruenceClosure<IEqNodeIdentifier> weqCongruenceClosure = this.mManager.addNode((IEqNodeIdentifier)iEqNodeIdentifier, this, true, true);
        }, (IEqualityReportingTarget)this);
        iEqNodeIdentifier2 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE);
        iEqNodeIdentifier3 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE2);
        Collection collection = this.mCongruenceClosure.getAuxData().getAfCcPars((ICongruenceClosureElement)iEqNodeIdentifier2);
        Collection collection2 = this.mCongruenceClosure.getAuxData().getAfCcPars((ICongruenceClosureElement)iEqNodeIdentifier3);
        for (Object object : collection) {
            if (!this.mCongruenceClosure.hasElements((ICongruenceClosureElement[])new IEqNodeIdentifier[]{object, (IEqNodeIdentifier)object.getArgument(), (IEqNodeIdentifier)object.getAppliedFunction()})) continue;
            for (Object object2 : collection2) {
                if (this.isInconsistent(false)) {
                    return true;
                }
                if (!this.mCongruenceClosure.hasElements((ICongruenceClosureElement[])new IEqNodeIdentifier[]{object2, (IEqNodeIdentifier)object2.getArgument(), (IEqNodeIdentifier)object2.getAppliedFunction()}) || this.mCongruenceClosure.getEqualityStatus((ICongruenceClosureElement)((IEqNodeIdentifier)object.getArgument()), (ICongruenceClosureElement)((IEqNodeIdentifier)object2.getArgument())) != EqualityStatus.EQUAL) continue;
                weakEquivalenceEdgeLabel2 = this.getCcWeakEquivalenceGraph().projectEdgeLabelToPoint(weakEquivalenceEdgeLabel3, (IEqNodeIdentifier)object.getArgument(), this.mManager.getAllWeqVarsNodeForFunction(NODE));
                this.reportWeakEquivalenceDoOnlyRoweqPropagations(object, object2, weakEquivalenceEdgeLabel2, bl);
            }
        }
        iEqNodeIdentifier2 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE);
        iEqNodeIdentifier3 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE2);
        collection = this.mCongruenceClosure.getAuxData().getCcChildren((ICongruenceClosureElement)iEqNodeIdentifier2).getSetOfPairs();
        collection2 = this.mCongruenceClosure.getAuxData().getCcChildren((ICongruenceClosureElement)iEqNodeIdentifier3).getSetOfPairs();
        for (Object object : collection) {
            if (((IEqNodeIdentifier)object.getKey()).dependsOnUntrackedArray()) continue;
            for (Object object2 : collection2) {
                if (this.isInconsistent(false)) {
                    return true;
                }
                if (((IEqNodeIdentifier)object2.getKey()).dependsOnUntrackedArray() || this.mCongruenceClosure.getEqualityStatus((ICongruenceClosureElement)((IEqNodeIdentifier)object.getValue()), (ICongruenceClosureElement)((IEqNodeIdentifier)object2.getValue())) != EqualityStatus.EQUAL) continue;
                weakEquivalenceEdgeLabel2 = this.getCcWeakEquivalenceGraph().shiftLabelAndAddException(weakEquivalenceEdgeLabel3, (IEqNodeIdentifier)object.getValue(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)object.getKey()));
                this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)object.getKey(), (IEqNodeIdentifier)object2.getKey(), weakEquivalenceEdgeLabel2, bl);
            }
        }
        return true;
    }

    private void constArrayWeqProp(NODE NODE, NODE NODE2, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel) {
        IEqNodeIdentifier iEqNodeIdentifier2;
        IEqNodeIdentifier iEqNodeIdentifier3;
        IEqNodeIdentifier iEqNodeIdentifier4;
        IEqNodeIdentifier iEqNodeIdentifier5 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE);
        IEqNodeIdentifier iEqNodeIdentifier6 = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE2);
        if (iEqNodeIdentifier5.isConstantFunction()) {
            assert (!iEqNodeIdentifier6.isConstantFunction()) : "?";
            iEqNodeIdentifier4 = iEqNodeIdentifier5;
            iEqNodeIdentifier3 = iEqNodeIdentifier6;
        } else if (iEqNodeIdentifier6.isConstantFunction()) {
            assert (!iEqNodeIdentifier5.isConstantFunction()) : "?";
            iEqNodeIdentifier4 = iEqNodeIdentifier6;
            iEqNodeIdentifier3 = iEqNodeIdentifier5;
        } else {
            iEqNodeIdentifier4 = null;
            iEqNodeIdentifier3 = null;
        }
        Collection collection = null;
        Set<SetConstraint<IEqNodeIdentifier>> set = null;
        if (iEqNodeIdentifier3 != null && !(collection = this.mCongruenceClosure.getFuncAppsWithFunc((ICongruenceClosureElement)iEqNodeIdentifier3)).isEmpty()) {
            iEqNodeIdentifier2 = (IEqNodeIdentifier)collection.iterator().next();
            IEqNodeIdentifier iEqNodeIdentifier7 = (IEqNodeIdentifier)this.mManager.getEqNodeAndFunctionFactory().getFuncAppElement(iEqNodeIdentifier3, (ICongruenceClosureElement)this.mManager.getWeqVariableNodeForDimension(0, ((IEqNodeIdentifier)iEqNodeIdentifier2.getArgument()).getSort()), true);
            set = weakEquivalenceEdgeLabel.getContainsConstraintForElement(iEqNodeIdentifier7);
            assert (set == null || !this.mManager.getCcManager().getSetConstraintManager().isInconsistent(set)) : "uncaught inconsistent case";
        }
        if (iEqNodeIdentifier4 != null && !collection.isEmpty() && set != null) {
            iEqNodeIdentifier2 = (IEqNodeIdentifier)iEqNodeIdentifier4.getConstantFunctionValue();
            assert (iEqNodeIdentifier2.isLiteral());
            for (IEqNodeIdentifier iEqNodeIdentifier7 : collection) {
                if (this.mCongruenceClosure.getEquivalenceClass((ICongruenceClosureElement)iEqNodeIdentifier7).stream().anyMatch(iEqNodeIdentifier -> iEqNodeIdentifier.isLiteral())) continue;
                Set set2 = this.mManager.getCcManager().getSetConstraintManager().join(set, Collections.singleton(this.mManager.getCcManager().getSetConstraintManager().buildSetConstraint(Collections.singleton(iEqNodeIdentifier2))));
                this.mCongruenceClosure.reportContainsConstraint((ICongruenceClosureElement)iEqNodeIdentifier7, (Collection)set2);
            }
        }
    }

    public boolean reportEquality(NODE NODE, NODE NODE2, boolean bl) {
        assert (!this.isFrozen());
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (bl || this.sanityCheck());
        boolean bl2 = this.reportEqualityRec(NODE, NODE2);
        this.mIsClosed = false;
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || bl || this.sanityCheck());
        return bl2;
    }

    public boolean reportEqualityRec(NODE NODE, NODE NODE2) {
        assert (!this.isFrozen());
        assert (NODE.hasSameTypeAs(NODE2));
        if (this.isInconsistent(false)) {
            throw new IllegalStateException();
        }
        boolean bl = false;
        bl |= !this.mCongruenceClosure.hasElement(NODE);
        bl |= !this.mCongruenceClosure.hasElement(NODE2);
        this.mManager.addNode(NODE, this, true, true);
        this.mManager.addNode(NODE2, this, true, true);
        assert (this.mCongruenceClosure.assertAtMostOneLiteralPerEquivalenceClass());
        if (this.mCongruenceClosure.getEqualityStatus(NODE, NODE2) == EqualityStatus.EQUAL) {
            return bl;
        }
        if (this.mCongruenceClosure.getEqualityStatus(NODE, NODE2) == EqualityStatus.NOT_EQUAL) {
            this.mCongruenceClosure.reportEqualityToElementTVER(NODE, NODE2);
            if (!this.mCongruenceClosure.isElementTverInconsistent()) {
                this.mCongruenceClosure.reportDisequalityToElementTver(NODE, NODE2);
            }
            assert (this.mCongruenceClosure.isElementTverInconsistent());
            return true;
        }
        NODE NODE3 = this.getRepresentativeElement(NODE);
        NODE NODE4 = this.getRepresentativeElement(NODE2);
        CcAuxData ccAuxData = new CcAuxData(this.mCongruenceClosure, this.mCongruenceClosure.getAuxData(), true);
        this.getWeakEquivalenceGraph().collapseEdgeAtMerge(NODE3, NODE4);
        Pair pair = this.mCongruenceClosure.doMergeAndComputePropagations(NODE, NODE2);
        if (pair == null) {
            return true;
        }
        NODE NODE5 = this.getRepresentativeElement(NODE);
        this.getWeakEquivalenceGraph().updateForNewRep(NODE3, NODE4, NODE5);
        if (this.isInconsistent(false)) {
            return true;
        }
        CongruenceClosure.doFwccAndBwccPropagationsFromMerge((Pair)pair, (IEqualityReportingTarget)this);
        if (this.isInconsistent(false)) {
            return true;
        }
        if (!(this.mManager.getSettings().isDeactivateWeakEquivalences() || NODE.dependsOnUntrackedArray() || NODE2.dependsOnUntrackedArray())) {
            this.doRoweqPropagationsOnMerge(NODE, NODE2, NODE3, NODE4, ccAuxData, true);
        }
        if (this.isInconsistent(false)) {
            return true;
        }
        if (this.mManager.getSettings().isAlwaysReportChangeToGpa()) {
            this.reportGpaChangeToWeqGraphAndPropagateArrayEqualities(congruenceClosure -> congruenceClosure.reportEqualityRec((ICongruenceClosureElement)NODE, (ICongruenceClosureElement)NODE2));
        }
        return true;
    }

    public NODE getRepresentativeElement(NODE NODE) {
        return (NODE)((IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(NODE));
    }

    private void doRoweqPropagationsOnMerge(NODE NODE, NODE NODE2, NODE NODE3, NODE NODE4, CcAuxData<NODE> ccAuxData, boolean bl) {
        CongruenceClosure<Object> congruenceClosure;
        IEqNodeIdentifier iEqNodeIdentifier;
        Object object;
        Object object2;
        if (this.isInconsistent(false)) {
            return;
        }
        for (Object object3 : ccAuxData.getCcChildren(NODE3)) {
            IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)object3.getKey();
            IEqNodeIdentifier iEqNodeIdentifier3 = (IEqNodeIdentifier)object3.getValue();
            if (iEqNodeIdentifier2 == null || iEqNodeIdentifier3 == null || iEqNodeIdentifier2.dependsOnUntrackedArray() || iEqNodeIdentifier3.dependsOnUntrackedArray()) continue;
            for (Object object4 : ccAuxData.getCcChildren(NODE4)) {
                object2 = (IEqNodeIdentifier)object4.getKey();
                object = (IEqNodeIdentifier)object4.getValue();
                if (object2 == null || object == null) continue;
                assert (this.mCongruenceClosure.hasElements((ICongruenceClosureElement[])new IEqNodeIdentifier[]{iEqNodeIdentifier2, iEqNodeIdentifier3, object2, object}));
                if (this.getEqualityStatus(iEqNodeIdentifier3, object) != EqualityStatus.EQUAL) continue;
                iEqNodeIdentifier = this.mManager.getAllWeqVarsNodeForFunction(iEqNodeIdentifier2).get(0);
                congruenceClosure = this.mManager.getSingleDisequalityCc(iEqNodeIdentifier, iEqNodeIdentifier3, true);
                this.reportWeakEquivalenceDoOnlyRoweqPropagations(iEqNodeIdentifier2, object2, this.mManager.getSingletonEdgeLabel(this.getWeakEquivalenceGraph(), congruenceClosure), bl);
            }
        }
        for (Object object3 : ccAuxData.getArgCcPars(NODE3)) {
            for (IEqNodeIdentifier iEqNodeIdentifier2 : ccAuxData.getArgCcPars(NODE4)) {
                Object object4;
                if (!object3.getSort().equals(iEqNodeIdentifier2.getSort())) continue;
                object4 = this.getCcWeakEquivalenceGraph().getEdgeLabel((IEqNodeIdentifier)object3.getAppliedFunction(), (IEqNodeIdentifier)iEqNodeIdentifier2.getAppliedFunction());
                WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel = this.getCcWeakEquivalenceGraph().projectEdgeLabelToPoint((WeakEquivalenceEdgeLabel<IEqNodeIdentifier>)object4, (IEqNodeIdentifier)object3.getArgument(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)object3.getAppliedFunction()));
                if (!object3.dependsOnUntrackedArray() && !iEqNodeIdentifier2.dependsOnUntrackedArray()) {
                    this.reportWeakEquivalenceDoOnlyRoweqPropagations(object3, iEqNodeIdentifier2, weakEquivalenceEdgeLabel, bl);
                }
                object2 = this.getCcWeakEquivalenceGraph().getEdgeLabel((IEqNodeIdentifier)object3, iEqNodeIdentifier2);
                object = this.getCcWeakEquivalenceGraph().shiftLabelAndAddException((WeakEquivalenceEdgeLabel<IEqNodeIdentifier>)object2, (IEqNodeIdentifier)NODE, this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)object3.getAppliedFunction()));
                if (!((IEqNodeIdentifier)object3.getAppliedFunction()).dependsOnUntrackedArray() && !((IEqNodeIdentifier)iEqNodeIdentifier2.getAppliedFunction()).dependsOnUntrackedArray()) {
                    this.reportWeakEquivalenceDoOnlyRoweqPropagations((NODE)((IEqNodeIdentifier)object3.getAppliedFunction()), (NODE)((IEqNodeIdentifier)iEqNodeIdentifier2.getAppliedFunction()), (WeakEquivalenceEdgeLabel<NODE>)object, bl);
                }
                if (this.getEqualityStatus(object3, iEqNodeIdentifier2) != EqualityStatus.EQUAL || ((IEqNodeIdentifier)object3.getAppliedFunction()).dependsOnUntrackedArray() || ((IEqNodeIdentifier)iEqNodeIdentifier2.getAppliedFunction()).dependsOnUntrackedArray()) continue;
                iEqNodeIdentifier = this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)object3.getAppliedFunction()).get(0);
                assert (this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)object3.getAppliedFunction()).equals(this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)iEqNodeIdentifier2.getAppliedFunction())));
                assert (this.getEqualityStatus((IEqNodeIdentifier)iEqNodeIdentifier2.getArgument(), (IEqNodeIdentifier)object3.getArgument()) == EqualityStatus.EQUAL) : " propagation is only allowed if i = j";
                congruenceClosure = this.mManager.getSingleDisequalityCc(iEqNodeIdentifier, (IEqNodeIdentifier)object3.getArgument(), true);
                this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)object3.getAppliedFunction(), (IEqNodeIdentifier)iEqNodeIdentifier2.getAppliedFunction(), this.mManager.getSingletonEdgeLabel(this.getWeakEquivalenceGraph(), congruenceClosure), bl);
            }
        }
        this.otherRoweqPropOnMerge(NODE3, ccAuxData, bl);
        this.otherRoweqPropOnMerge(NODE4, ccAuxData, bl);
    }

    public EqualityStatus getEqualityStatus(NODE NODE, NODE NODE2) {
        return this.mCongruenceClosure.getEqualityStatus(NODE, NODE2);
    }

    private boolean otherRoweqPropOnMerge(NODE NODE, CcAuxData<NODE> ccAuxData, boolean bl) {
        boolean bl2 = false;
        for (Map.Entry entry : ccAuxData.getCcChildren(NODE)) {
            for (Map.Entry<NODE, WeakEquivalenceEdgeLabel<NODE>> entry2 : this.getCcWeakEquivalenceGraph().getAdjacentWeqEdges(NODE).entrySet()) {
                IEqNodeIdentifier cfr_ignored_0 = (IEqNodeIdentifier)entry2.getKey();
                WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel = entry2.getValue();
                if (!ccAuxData.getArgCcPars((ICongruenceClosureElement)((IEqNodeIdentifier)entry.getValue())).contains(entry2.getKey())) continue;
                for (Map.Entry entry3 : ccAuxData.getCcChildren((ICongruenceClosureElement)((IEqNodeIdentifier)entry2.getKey()))) {
                    WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel2 = this.getCcWeakEquivalenceGraph().shiftLabelAndAddException(weakEquivalenceEdgeLabel, (IEqNodeIdentifier)entry.getValue(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)entry.getKey()));
                    bl2 |= this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)entry.getKey(), (IEqNodeIdentifier)entry3.getKey(), weakEquivalenceEdgeLabel2, bl);
                }
            }
        }
        return bl2;
    }

    boolean reportAllConstraintsFromWeqGraph(boolean bl) {
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (bl || this.sanityCheck());
        if (this.isInconsistent(false)) {
            assert (this.sanityCheck());
            return false;
        }
        boolean bl2 = false;
        while (this.getWeakEquivalenceGraph().hasConstraintsToReport()) {
            WeakEquivalenceGraph.ConstraintFromWeqGraph constraintFromWeqGraph = this.getWeakEquivalenceGraph().pollStoredConstraintAndRemoveRelatedWeqEdge();
            if (constraintFromWeqGraph.isIsArrayEquality()) {
                bl2 |= this.reportEquality((IEqNodeIdentifier)constraintFromWeqGraph.getEquality().getFirst(), (IEqNodeIdentifier)constraintFromWeqGraph.getEquality().getSecond(), bl);
            } else if (constraintFromWeqGraph.isSetConstraint()) {
                bl2 = true;
                this.reportContainsConstraint((NODE)((IEqNodeIdentifier)constraintFromWeqGraph.getSetConstraint().getFirst()), (Collection<SetConstraint<NODE>>)Collections.singleton((SetConstraint)constraintFromWeqGraph.getSetConstraint().getSecond()));
            } else if (!constraintFromWeqGraph.isDummyConstraint()) {
                throw new AssertionError();
            }
            if (this.isInconsistent(false)) {
                assert (this.sanityCheck());
                assert (bl2);
                return true;
            }
            if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (bl || this.sanityCheck());
        }
        assert (bl || this.sanityCheck());
        assert (this.weqGraphFreeOfArrayEqualities());
        return bl2;
    }

    public boolean reportDisequality(NODE NODE, NODE NODE2) {
        assert (!this.isFrozen());
        boolean bl = this.reportDisequalityRec(NODE, NODE2);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
        return bl;
    }

    public boolean reportDisequalityRec(NODE NODE, NODE NODE2) {
        boolean bl = false;
        if (!(bl |= this.mCongruenceClosure.reportDisequalityRec(NODE, NODE2))) {
            return false;
        }
        if (this.isInconsistent(false)) {
            return true;
        }
        if (this.mManager.getSettings().isAlwaysReportChangeToGpa()) {
            this.reportGpaChangeToWeqGraphAndPropagateArrayEqualities(congruenceClosure -> congruenceClosure.reportDisequalityRec((ICongruenceClosureElement)NODE, (ICongruenceClosureElement)NODE2));
            assert (this.weqGraphFreeOfArrayEqualities());
        }
        if (this.isInconsistent(false)) {
            return true;
        }
        return true;
    }

    public void reportContainsConstraint(NODE NODE, Set<NODE> set) {
        this.mCongruenceClosure.reportContainsConstraint(NODE, set);
        if (this.mManager.getSettings().isAlwaysReportChangeToGpa()) {
            throw new AssertionError((Object)"not implemented");
        }
    }

    public void reportContainsConstraint(NODE NODE, Collection<SetConstraint<NODE>> collection) {
        this.mCongruenceClosure.reportContainsConstraint(NODE, collection);
        if (this.mManager.getSettings().isAlwaysReportChangeToGpa()) {
            throw new AssertionError((Object)"not implemented");
        }
    }

    @Deprecated
    private boolean reportGpaChangeToWeqGraphAndPropagateArrayEqualities(Predicate<CongruenceClosure<NODE>> predicate) {
        assert (this.sanityCheck());
        if (this.isInconsistent(false)) {
            return false;
        }
        boolean bl = false;
        bl |= this.getCcWeakEquivalenceGraph().reportChangeInGroundPartialArrangement(predicate);
        this.reportAllConstraintsFromWeqGraph(false);
        assert (this.sanityCheck());
        return bl;
    }

    public boolean isTautological() {
        if (this.mCongruenceClosure == null) {
            return false;
        }
        return this.mCongruenceClosure.isTautological() && this.getWeakEquivalenceGraph().isEmpty();
    }

    public boolean isStrongerThan(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        assert (this.isClosed() && weqCongruenceClosure.isClosed()) : "caller ensures this, right?";
        assert (this.getAllElements().equals(weqCongruenceClosure.getAllElements()));
        if (this.isInconsistent()) {
            return true;
        }
        if (weqCongruenceClosure.isTautological()) {
            return true;
        }
        if (this.isTautological()) {
            return false;
        }
        if (weqCongruenceClosure.isInconsistent()) {
            return false;
        }
        if (!this.mManager.isStrongerThan(this.mCongruenceClosure, weqCongruenceClosure.mCongruenceClosure)) {
            return false;
        }
        return this.mManager.isStrongerThan(this.getWeakEquivalenceGraph(), weqCongruenceClosure.getWeakEquivalenceGraph());
    }

    public void fatten() {
        assert (!this.isFrozen());
        if (this.isInconsistent(false)) {
            return;
        }
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                this.mDiet = Diet.TRANSITORY_THIN_TO_CCFAT;
                break;
            }
            case CCFAT: {
                this.mDiet = Diet.TRANSITORY_CCREFATTEN;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.mWeakEquivalenceGraphCcFat = this.getWeakEquivalenceGraph().ccFattenEdgeLabels();
        this.mWeakEquivalenceGraphThin = null;
        this.mDiet = Diet.CCFAT;
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    public void extAndTriangleClosure(boolean bl) {
        if (this.mIsClosed) {
            return;
        }
        this.mManager.bmStart(WeqCcManager.WeqCcBmNames.EXT_AND_TRIANGLE_CLOSURE);
        WeqCongruenceClosure weqCongruenceClosure = null;
        if (VMUtils.areAssertionsEnabled() && this.mManager.mDebug) {
            this.mManager.getClass();
        }
        int n = 0;
        while (n++ < 10) {
            if (this.mManager.isDebugMode()) {
                this.mManager.getLogger().debug((Object)("ext and triangle closure, loop iteration #" + n));
            }
            boolean bl2 = true;
            while (bl2) {
                if (this.isInconsistent(false)) {
                    assert (this.mManager.checkEquivalence(weqCongruenceClosure, this));
                    this.mIsClosed = true;
                    this.mManager.bmEnd(WeqCcManager.WeqCcBmNames.EXT_AND_TRIANGLE_CLOSURE);
                    return;
                }
                assert (bl || this.sanityCheck());
                this.fatten();
                bl2 = this.reportAllConstraintsFromWeqGraph(bl);
            }
            this.thin();
            assert (this.sanityCheck());
            this.executeFloydWarshallAndReportResultToWeqCc(bl);
            if (!this.getWeakEquivalenceGraph().hasConstraintsToReport()) {
                assert (this.mManager.checkEquivalence(weqCongruenceClosure, this));
                this.mIsClosed = true;
                this.mManager.bmEnd(WeqCcManager.WeqCcBmNames.EXT_AND_TRIANGLE_CLOSURE);
                return;
            }
            this.reportAllConstraintsFromWeqGraph(bl);
        }
    }

    public Set<NODE> removeElementAndDependents(NODE NODE, Set<NODE> set, Map<NODE, NODE> map) {
        Object object2;
        for (Object object2 : set) {
            this.getWeakEquivalenceGraph().replaceVertex((IEqNodeIdentifier)object2, (IEqNodeIdentifier)map.get(object2));
        }
        object2 = this.getWeakEquivalenceGraph().projectAwaySimpleElementInEdgeLabels(NODE);
        assert (object2.isEmpty()) : "we don't allow introduction of new nodes at labels if weare not in the meet-with-WeqGpa case";
        this.mCongruenceClosure.removeElements(set, map);
        return object2;
    }

    public Set<NODE> getNodesToIntroduceBeforeRemoval(NODE NODE, Set<NODE> set, Map<NODE, NODE> map) {
        Set set2 = this.mCongruenceClosure.getNodesToIntroduceBeforeRemoval(NODE, set, map);
        if (!set2.isEmpty()) {
            assert (set2.size() == 1);
            assert (DataStructureUtils.intersection((Set)this.mCongruenceClosure.getElementCurrentlyBeingRemoved().getRemovedElements(), (Set)set2).isEmpty());
            return set2;
        }
        boolean bl = set.contains(NODE.getAppliedFunction());
        if (!bl) {
            return Collections.emptySet();
        }
        assert (NODE.isFunctionApplication());
        HashSet<IEqNodeIdentifier> hashSet = new HashSet<IEqNodeIdentifier>();
        boolean bl2 = set.contains(NODE.getArgument());
        IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)this.mCongruenceClosure.getOtherEquivalenceClassMember((ICongruenceClosureElement)((IEqNodeIdentifier)NODE.getArgument()), set);
        if (bl2 && iEqNodeIdentifier == null) {
            return Collections.emptySet();
        }
        IEqNodeIdentifier iEqNodeIdentifier2 = bl2 ? iEqNodeIdentifier : (IEqNodeIdentifier)NODE.getArgument();
        for (Map.Entry<IEqNodeIdentifier, WeakEquivalenceEdgeLabel<IEqNodeIdentifier>> entry : this.getCcWeakEquivalenceGraph().getAdjacentWeqEdges((IEqNodeIdentifier)NODE.getAppliedFunction()).entrySet()) {
            IEqNodeIdentifier iEqNodeIdentifier3;
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel;
            assert (!entry.getKey().equals(NODE.getAppliedFunction()));
            if (set.contains(entry.getKey()) || (weakEquivalenceEdgeLabel = this.getCcWeakEquivalenceGraph().projectEdgeLabelToPoint(entry.getValue(), (IEqNodeIdentifier)NODE.getArgument(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)NODE.getAppliedFunction()))).isTautological()) continue;
            if (weakEquivalenceEdgeLabel.isInconsistent()) {
                iEqNodeIdentifier3 = (IEqNodeIdentifier)this.mManager.getEqNodeAndFunctionFactory().getOrConstructFuncAppElement(entry.getKey(), iEqNodeIdentifier2);
                assert (!this.mCongruenceClosure.getElementCurrentlyBeingRemoved().getRemovedElements().contains(iEqNodeIdentifier3));
                map.put(NODE, iEqNodeIdentifier3);
                if (!this.mCongruenceClosure.hasElement((ICongruenceClosureElement)iEqNodeIdentifier3)) {
                    assert (this.assertNodeToAddIsEquivalentToOriginal(iEqNodeIdentifier3, NODE));
                    return Collections.singleton(iEqNodeIdentifier3);
                }
                return Collections.emptySet();
            }
            if (weakEquivalenceEdgeLabel.isTautological()) continue;
            iEqNodeIdentifier3 = (IEqNodeIdentifier)this.mManager.getEqNodeAndFunctionFactory().getOrConstructFuncAppElement(entry.getKey(), iEqNodeIdentifier2);
            if (this.mManager.getSettings().isIntroduceAtMostOneNodeForEachRemovedNode()) {
                assert (!this.mCongruenceClosure.getElementCurrentlyBeingRemoved().getRemovedElements().contains(iEqNodeIdentifier3));
                if (!this.hasElement((NODE)iEqNodeIdentifier3)) {
                    return Collections.singleton(iEqNodeIdentifier3);
                }
                return Collections.emptySet();
            }
            assert (!this.mCongruenceClosure.getElementCurrentlyBeingRemoved().getRemovedElements().contains(iEqNodeIdentifier3));
            if (this.hasElement((NODE)iEqNodeIdentifier3)) continue;
            hashSet.add(iEqNodeIdentifier3);
        }
        return hashSet;
    }

    private boolean assertNodeToAddIsEquivalentToOriginal(NODE NODE, NODE NODE2) {
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mManager.copyWeqCc(this, true);
        this.mManager.addNode(NODE, weqCongruenceClosure, true, true);
        if (weqCongruenceClosure.getEqualityStatus(NODE, NODE2) != EqualityStatus.EQUAL) {
            assert (false);
            return false;
        }
        return true;
    }

    public boolean hasElement(NODE NODE) {
        return this.mCongruenceClosure.hasElement(NODE);
    }

    public boolean isConstrained(NODE NODE) {
        if (this.mCongruenceClosure.isConstrained(NODE)) {
            return true;
        }
        return this.getWeakEquivalenceGraph().isConstrained(NODE);
    }

    private void registerNewElement(NODE NODE) {
        Object object;
        Object object2;
        if (this.isInconsistent(false)) {
            return;
        }
        if (!NODE.isFunctionApplication()) {
            return;
        }
        boolean bl = false;
        if (this.mManager.getSettings().isDeactivateWeakEquivalences() || NODE.dependsOnUntrackedArray()) {
            return;
        }
        CongruenceClosure.constantFunctionTreatmentOnAddElement(NODE, this.getWeakEquivalenceGraph().getAdjacentWeqEdges((IEqNodeIdentifier)NODE.getAppliedFunction()).keySet(), (IEqualityReportingTarget)this);
        CongruenceClosure.mixFunctionTreatmentOnAddElement(NODE, (iEqNodeIdentifier, set) -> {
            WeqCongruenceClosure<IEqNodeIdentifier> weqCongruenceClosure = this.mManager.reportContainsConstraint((IEqNodeIdentifier)iEqNodeIdentifier, (Set<IEqNodeIdentifier>)set, (WeqCongruenceClosure<IEqNodeIdentifier>)this, true);
        }, iEqNodeIdentifier -> {
            WeqCongruenceClosure<IEqNodeIdentifier> weqCongruenceClosure = this.mManager.addNode((IEqNodeIdentifier)iEqNodeIdentifier, this, true, true);
        }, this.getWeakEquivalenceGraph().getAdjacentWeqEdges((IEqNodeIdentifier)NODE.getAppliedFunction()).keySet());
        for (IEqNodeIdentifier object3 : this.mCongruenceClosure.getArgCcPars((ICongruenceClosureElement)this.getRepresentativeElement((IEqNodeIdentifier)NODE.getArgument()))) {
            if (!object3.hasSameTypeAs((ICongruenceClosureElement)NODE)) continue;
            assert (this.hasElements(new IEqNodeIdentifier[]{object3, (IEqNodeIdentifier)object3.getAppliedFunction(), (IEqNodeIdentifier)object3.getArgument()}));
            if (this.getEqualityStatus((IEqNodeIdentifier)NODE.getAppliedFunction(), (IEqNodeIdentifier)object3.getAppliedFunction()) == EqualityStatus.EQUAL) continue;
            object2 = this.getCcWeakEquivalenceGraph().getEdgeLabel((IEqNodeIdentifier)object3.getAppliedFunction(), (IEqNodeIdentifier)NODE.getAppliedFunction());
            object = this.getCcWeakEquivalenceGraph().projectEdgeLabelToPoint((WeakEquivalenceEdgeLabel<IEqNodeIdentifier>)object2, (IEqNodeIdentifier)object3.getArgument(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)object3.getAppliedFunction()));
            if (!object3.dependsOnUntrackedArray()) {
                bl |= this.reportWeakEquivalenceDoOnlyRoweqPropagations(NODE, (NODE)object3, (WeakEquivalenceEdgeLabel<NODE>)object, true);
            }
            if (!this.isInconsistent(false)) continue;
            return;
        }
        for (Map.Entry entry : this.getWeakEquivalenceGraph().getAdjacentWeqEdges((IEqNodeIdentifier)NODE.getAppliedFunction()).entrySet()) {
            object2 = (IEqNodeIdentifier)entry.getKey();
            if (!object2.isConstantFunction() || !((IEqNodeIdentifier)object2.getConstantFunctionValue()).isLiteral()) continue;
            object = (IEqNodeIdentifier)object2.getConstantFunctionValue();
            assert (((IEqNodeIdentifier)object2.getConstantFunctionValue()).isLiteral());
            IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)NODE.replaceArgument(this.mManager.getWeqVariableNodeForDimension(0, ((IEqNodeIdentifier)NODE.getArgument()).getSort()));
            WeakEquivalenceEdgeLabel weakEquivalenceEdgeLabel = (WeakEquivalenceEdgeLabel)entry.getValue();
            Set<SetConstraint<IEqNodeIdentifier>> set2 = weakEquivalenceEdgeLabel.getContainsConstraintForElement(iEqNodeIdentifier2);
            if (set2 == null) continue;
            Set set3 = this.mManager.getCcManager().getSetConstraintManager().join(set2, Collections.singleton(this.mManager.getCcManager().getSetConstraintManager().buildSetConstraint(Collections.singleton(object))));
            this.mCongruenceClosure.reportContainsConstraint(NODE, (Collection)set3);
            bl = true;
        }
        this.mIsClosed = false;
    }

    public boolean hasElements(NODE ... NODEArray) {
        return this.mCongruenceClosure.hasElements(NODEArray);
    }

    public void transformElementsAndFunctions(Function<NODE, NODE> function) {
        Object object;
        assert (!this.isFrozen());
        if (this.mCongruenceClosure.isFrozen()) {
            object = this.mManager.getCcManager().unfreeze(this.mCongruenceClosure);
            object.transformElementsAndFunctions(function);
            this.updateCongruenceClosure((CongruenceClosure<NODE>)object);
        } else {
            this.mCongruenceClosure.transformElementsAndFunctions(function);
        }
        if (this.getWeakEquivalenceGraph().isFrozen()) {
            object = this.mManager.unfreeze(this.getWeakEquivalenceGraph());
            ((WeakEquivalenceGraph)object).transformElementsAndFunctions(function);
            this.updateWeqGraph((WeakEquivalenceGraph<NODE>)object);
        } else {
            this.getWeakEquivalenceGraph().transformElementsAndFunctions(function);
        }
        assert (this.sanityCheck());
    }

    private void updateWeqGraph(WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                this.mWeakEquivalenceGraphThin = weakEquivalenceGraph;
                break;
            }
            case CCFAT: 
            case TRANSITORY_CCREFATTEN: {
                this.mWeakEquivalenceGraphCcFat = weakEquivalenceGraph;
            }
        }
    }

    private void updateCongruenceClosure(CongruenceClosure<NODE> congruenceClosure) {
        assert (!this.isFrozen());
        this.mCongruenceClosure = congruenceClosure;
    }

    public boolean assertSimpleElementIsFullyRemoved(NODE NODE) {
        for (IEqNodeIdentifier iEqNodeIdentifier : this.getAllElements()) {
            if (!iEqNodeIdentifier.isDependentNonFunctionApplication() || !iEqNodeIdentifier.getSupportingNodes().contains(NODE)) continue;
            assert (false);
            return false;
        }
        return this.mCongruenceClosure.assertSimpleElementIsFullyRemoved(NODE);
    }

    public Set<NODE> getAllElements() {
        return this.mCongruenceClosure.getAllElements();
    }

    public boolean assertSingleElementIsFullyRemoved(NODE NODE) {
        if (!this.getWeakEquivalenceGraph().assertElementIsFullyRemoved(NODE)) {
            assert (false);
            return false;
        }
        return this.mCongruenceClosure.assertSingleElementIsFullyRemoved(NODE);
    }

    WeqCongruenceClosure<NODE> join(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        assert (this.isClosed() && weqCongruenceClosure.isClosed());
        assert (!(this.isInconsistent(false) || weqCongruenceClosure.isInconsistent(false) || this.isTautological() || weqCongruenceClosure.isTautological())) : "catch this case in WeqCcManager";
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.mManager.getWeqCongruenceClosure(this.mManager.join(this.mCongruenceClosure, weqCongruenceClosure.mCongruenceClosure, true), this.mManager.join(this.getWeakEquivalenceGraph(), weqCongruenceClosure.getWeakEquivalenceGraph(), true), true);
        return weqCongruenceClosure2;
    }

    WeqCongruenceClosure<NODE> widen(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        assert (this.isClosed() && weqCongruenceClosure.isClosed());
        assert (!(this.isInconsistent(false) || weqCongruenceClosure.isInconsistent(false) || this.isTautological() || weqCongruenceClosure.isTautological())) : "catch this case in WeqCcManager";
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.mManager.getWeqCongruenceClosure(this.mManager.widen(this.mCongruenceClosure, weqCongruenceClosure.mCongruenceClosure, true), this.mManager.join(this.getWeakEquivalenceGraph(), weqCongruenceClosure.getWeakEquivalenceGraph(), true), true);
        return weqCongruenceClosure2;
    }

    WeqCongruenceClosure<NODE> meet(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        assert (!this.getWeakEquivalenceGraph().hasConstraintsToReport());
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.meetRec(weqCongruenceClosure);
        this.mIsClosed = false;
        weqCongruenceClosure2.reportAllConstraintsFromWeqGraph(false);
        assert (weqCongruenceClosure2.sanityCheck());
        return weqCongruenceClosure2;
    }

    private WeqCongruenceClosure<NODE> meetRec(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        WeqCongruenceClosure<IEqNodeIdentifier> weqCongruenceClosure2 = this.meetWeqWithCc(weqCongruenceClosure.mCongruenceClosure);
        this.reportAllConstraintsFromWeqGraph(false);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained1() || weqCongruenceClosure2.sanityCheck());
        if (weqCongruenceClosure2.isInconsistent(false)) {
            return weqCongruenceClosure2;
        }
        assert (weqCongruenceClosure2.mCongruenceClosure.assertAtMostOneLiteralPerEquivalenceClass());
        assert (!this.getWeakEquivalenceGraph().hasConstraintsToReport());
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) {
            assert (weqCongruenceClosure2.sanityCheck());
            assert (weqCongruenceClosure.getWeakEquivalenceGraph().sanityCheck());
            assert (weqCongruenceClosure.sanityCheck());
        }
        if (this.mManager.getSettings().isDeactivateWeakEquivalences()) {
            return weqCongruenceClosure2;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : weqCongruenceClosure.getCcWeakEquivalenceGraph().getEdges().entrySet()) {
            weqCongruenceClosure2.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)entry.getKey().getOneElement(), (IEqNodeIdentifier)entry.getKey().getOtherElement(), entry.getValue(), true);
            assert (weqCongruenceClosure2.sanityCheck());
            if (!weqCongruenceClosure2.isInconsistent(false)) continue;
            return weqCongruenceClosure2;
        }
        return weqCongruenceClosure2;
    }

    public void freezeIfNecessary() {
        if (!this.isFrozen()) {
            this.freezeOmitPropagations();
        }
    }

    private WeqCongruenceClosure<NODE> meetWeqWithCc(CongruenceClosure<NODE> congruenceClosure) {
        assert (!this.isInconsistent(false) && !congruenceClosure.isInconsistent(false));
        WeqCongruenceClosure<Object> weqCongruenceClosure = this.mManager.addAllElements(this, congruenceClosure.getAllElements(), null, true);
        for (Map.Entry entry : congruenceClosure.getSupportingElementEqualities().entrySet()) {
            if (weqCongruenceClosure.isInconsistent(false)) {
                return this;
            }
            weqCongruenceClosure = this.mManager.reportEquality(weqCongruenceClosure, (IEqNodeIdentifier)entry.getKey(), (IEqNodeIdentifier)entry.getValue(), true);
        }
        for (Map.Entry entry : congruenceClosure.getElementDisequalities()) {
            if (weqCongruenceClosure.isInconsistent(false)) {
                return this;
            }
            weqCongruenceClosure = this.mManager.reportDisequality(weqCongruenceClosure, (IEqNodeIdentifier)entry.getKey(), (IEqNodeIdentifier)entry.getValue(), true);
        }
        for (Map.Entry entry : congruenceClosure.getLiteralSetConstraints().getConstraints().entrySet()) {
            if (weqCongruenceClosure.isInconsistent(false)) {
                return this;
            }
            weqCongruenceClosure = this.mManager.reportContainsConstraint((Object)((IEqNodeIdentifier)entry.getKey()), ((SetConstraintConjunction)entry.getValue()).getSetConstraints(), weqCongruenceClosure, true);
        }
        assert (weqCongruenceClosure.sanityCheck());
        return weqCongruenceClosure;
    }

    public boolean sanityCheck() {
        if (this.isInconsistent(false)) {
            return true;
        }
        if (this.mIsFrozen != this.mCongruenceClosure.isFrozen()) {
            assert (false);
            return false;
        }
        boolean bl = this.mCongruenceClosure.sanityCheck();
        if (this.getWeakEquivalenceGraph() != null) {
            bl &= this.getWeakEquivalenceGraph().sanityCheck();
        }
        if (!this.isInconsistent(false)) {
            for (IEqNodeIdentifier iEqNodeIdentifier : this.getAllElements()) {
                if (!CongruenceClosure.dependsOnAny((ICongruenceClosureElement)iEqNodeIdentifier, this.mManager.getAllWeqPrimedNodes())) continue;
                assert (false);
                return false;
            }
        }
        return bl;
    }

    public String toString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent(false)) {
            return "False";
        }
        if (this.getAllElements().size() < this.mManager.getSettings().getMaxNoElementsForVerboseToString()) {
            return this.toLogString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Partial arrangement:\n");
        stringBuilder.append(this.mCongruenceClosure.toString());
        stringBuilder.append("\n");
        if (this.getWeakEquivalenceGraph() != null) {
            stringBuilder.append("Weak equivalences:\n");
            stringBuilder.append(this.getWeakEquivalenceGraph().toString());
        } else {
            stringBuilder.append("weak equivalence graph is null\n");
        }
        return stringBuilder.toString();
    }

    public String toLogString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent(false)) {
            return "False";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Partial arrangement:\n");
        stringBuilder.append(this.mCongruenceClosure.toLogString());
        stringBuilder.append("\n");
        if (this.getWeakEquivalenceGraph() != null && !this.getWeakEquivalenceGraph().isEmpty()) {
            stringBuilder.append("Weak equivalences:\n");
            stringBuilder.append(this.getWeakEquivalenceGraph().toLogString());
        } else if (this.getWeakEquivalenceGraph() != null && this.getWeakEquivalenceGraph().isEmpty()) {
            stringBuilder.append("weak equivalence graph is empty\n");
        } else {
            stringBuilder.append("weak equivalence graph is null\n");
        }
        return stringBuilder.toString();
    }

    public boolean weqGraphFreeOfArrayEqualities() {
        if (this.getWeakEquivalenceGraph().hasConstraintsToReport()) {
            assert (false);
            return false;
        }
        return true;
    }

    public Integer getStatistics(VPStatistics vPStatistics) {
        switch (vPStatistics) {
            case MAX_WEQGRAPH_SIZE: {
                return this.getWeakEquivalenceGraph().getNumberOfEdgesStatistic();
            }
            case MAX_SIZEOF_WEQEDGELABEL: {
                return this.getWeakEquivalenceGraph().getMaxSizeOfEdgeLabelStatistic();
            }
            case NO_SUPPORTING_DISEQUALITIES: {
                HashRelation hashRelation = new HashRelation();
                for (Map.Entry entry : this.mCongruenceClosure.getElementDisequalities()) {
                    if (hashRelation.containsPair((Object)((IEqNodeIdentifier)entry.getValue()), (Object)((IEqNodeIdentifier)entry.getKey()))) continue;
                    hashRelation.addPair((Object)((IEqNodeIdentifier)entry.getKey()), (Object)((IEqNodeIdentifier)entry.getValue()));
                }
                return hashRelation.size();
            }
            case NO_SUPPORTING_EQUALITIES: {
                return this.mCongruenceClosure.getSupportingElementEqualities().size();
            }
        }
        return VPStatistics.getNonApplicableValue(vPStatistics);
    }

    public Set<NODE> collectElementsToRemove(NODE NODE) {
        return this.mCongruenceClosure.collectElementsToRemove(NODE);
    }

    public NODE getOtherEquivalenceClassMember(NODE NODE, Set<NODE> set) {
        return (NODE)((IEqNodeIdentifier)this.mCongruenceClosure.getOtherEquivalenceClassMember(NODE, set));
    }

    public boolean addElementRec(NODE NODE) {
        boolean bl = !this.mCongruenceClosure.hasElement(NODE);
        this.mManager.addNode(NODE, this.mCongruenceClosure, this, true, true);
        if (!bl) {
            return false;
        }
        this.registerNewElement(NODE);
        return true;
    }

    public IRemovalInfo<NODE> getElementCurrentlyBeingRemoved() {
        return this.mCongruenceClosure.getElementCurrentlyBeingRemoved();
    }

    public boolean isRepresentative(NODE NODE) {
        return this.mCongruenceClosure.isRepresentative(NODE);
    }

    public CongruenceClosure<NODE> getCongruenceClosure() {
        return this.mCongruenceClosure;
    }

    public void setElementCurrentlyBeingRemoved(IRemovalInfo<NODE> iRemovalInfo) {
        this.mCongruenceClosure.setElementCurrentlyBeingRemoved(iRemovalInfo);
    }

    public boolean isDebugMode() {
        return this.mLogger != null;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public WeakEquivalenceGraph<NODE> getCcWeakEquivalenceGraph() {
        assert (this.assertDietSanity());
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                return this.mWeakEquivalenceGraphThin;
            }
            case CCFAT: 
            case TRANSITORY_CCREFATTEN: {
                return this.mWeakEquivalenceGraphCcFat;
            }
        }
        throw new AssertionError();
    }

    public WeakEquivalenceGraph<NODE> getWeakEquivalenceGraph() {
        assert (this.assertDietSanity());
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                return this.mWeakEquivalenceGraphThin;
            }
            case CCFAT: 
            case TRANSITORY_CCREFATTEN: {
                return this.mWeakEquivalenceGraphCcFat;
            }
        }
        throw new AssertionError();
    }

    private boolean assertDietSanity() {
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                if (this.mWeakEquivalenceGraphThin == null) {
                    assert (false);
                    return false;
                }
                if (this.mWeakEquivalenceGraphCcFat == null) break;
                assert (false);
                return false;
            }
            case CCFAT: 
            case TRANSITORY_CCREFATTEN: {
                if (this.mWeakEquivalenceGraphThin != null) {
                    assert (false);
                    return false;
                }
                if (this.mWeakEquivalenceGraphCcFat != null) break;
                assert (false);
                return false;
            }
        }
        return true;
    }

    public boolean sanityCheckOnlyCc() {
        return this.mCongruenceClosure.sanityCheck();
    }

    public boolean sanityCheckOnlyCc(IRemovalInfo<NODE> iRemovalInfo) {
        return this.mCongruenceClosure.sanityCheck(iRemovalInfo);
    }

    public void thin() {
        assert (!this.mIsFrozen);
        assert (this.mDiet != Diet.THIN);
        assert (this.assertDietSanity());
        if (this.mWeakEquivalenceGraphCcFat == null) {
            throw new AssertionError();
        }
        this.mWeakEquivalenceGraphThin = this.mWeakEquivalenceGraphCcFat.thinLabels(this);
        this.mWeakEquivalenceGraphCcFat = null;
        this.mDiet = Diet.THIN;
    }

    public Diet getDiet() {
        return this.mDiet;
    }

    public void setDiet(Diet diet) {
        this.mDiet = diet;
    }

    public void setIsEdgeLabelDisjunct() {
        this.mIsWeqFatEdgeLabel = true;
    }

    public WeqCcManager<NODE> getManager() {
        return this.mManager;
    }

    public Set<NODE> getAllLiterals() {
        return this.mCongruenceClosure.getAllLiterals();
    }

    public Set<SetConstraint<NODE>> getContainsConstraintForElement(NODE NODE) {
        return this.mCongruenceClosure.getContainsConstraintForElement(NODE);
    }

    public boolean isWeqFatEdgeLabel() {
        return this.mIsWeqFatEdgeLabel;
    }

    public boolean isClosed() {
        return this.mIsClosed;
    }

    public boolean isConstrainedDirectly(NODE NODE) {
        throw new UnsupportedOperationException("we are not using weq fattening anymore, right? (otherwise: implement similarly as in CongruenceClosure..)");
    }
}

