/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class TimeMemoryTracker {
    long mStartTime;
    long mElapsedTimeNs;
    long mStartMemorySizeBytes;
    long mStopMemorySizeBytes;
    long mStartMemoryFreeSizeBytes;
    long mStopMemoryFreeSizeBytes;
    long mStartPeakMemorySizeBytes;
    long mPeakMemorySizeBytes;
    final String mTitle;
    private final long mMaxMemorySizeBytes;
    private final List<MemoryPoolMXBean> mMemoryPoolBeans;

    public TimeMemoryTracker(String string) {
        this(string, Runtime.getRuntime().maxMemory());
    }

    public TimeMemoryTracker(String string, long l) {
        this.mMaxMemorySizeBytes = l;
        this.mTitle = string;
        this.mMemoryPoolBeans = ManagementFactory.getMemoryPoolMXBeans();
        this.reset();
    }

    public void start() {
        this.mStartMemorySizeBytes = Runtime.getRuntime().totalMemory();
        this.mStartMemoryFreeSizeBytes = Runtime.getRuntime().freeMemory();
        long l = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : this.mMemoryPoolBeans) {
            memoryPoolMXBean.resetPeakUsage();
            if (!Benchmark.isHeap(memoryPoolMXBean.getName())) continue;
            l += memoryPoolMXBean.getPeakUsage().getUsed();
        }
        this.mStartPeakMemorySizeBytes = l;
        this.mStartTime = System.nanoTime();
    }

    public void stop(long l) {
        this.mElapsedTimeNs = l - this.mStartTime + this.mElapsedTimeNs;
        this.mStopMemorySizeBytes = Runtime.getRuntime().totalMemory();
        this.mStopMemoryFreeSizeBytes = Runtime.getRuntime().freeMemory();
        long l2 = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : this.mMemoryPoolBeans) {
            if (!Benchmark.isHeap(memoryPoolMXBean.getName())) continue;
            l2 += memoryPoolMXBean.getPeakUsage().getUsed();
        }
        this.mPeakMemorySizeBytes = Math.max(this.mPeakMemorySizeBytes, Math.max(l2, this.mStartPeakMemorySizeBytes));
    }

    public void reset() {
        this.mStartTime = -1L;
        this.mElapsedTimeNs = 0L;
        this.mStartMemorySizeBytes = 0L;
        this.mStartMemoryFreeSizeBytes = 0L;
        this.mStopMemorySizeBytes = 0L;
        this.mStopMemoryFreeSizeBytes = 0L;
        this.mStartPeakMemorySizeBytes = 0L;
        this.mPeakMemorySizeBytes = 0L;
    }

    public String toString() {
        return this.toString(TimeUnit.MILLISECONDS, 2);
    }

    private String toString(TimeUnit timeUnit, int n) {
        if (this.mStartTime == -1L) {
            return String.format("%s was not measured", this.mTitle);
        }
        long l = this.mStopMemorySizeBytes - this.mStartMemorySizeBytes;
        long l2 = this.mStartMemoryFreeSizeBytes - this.mStopMemoryFreeSizeBytes;
        String string = l2 < 0L ? "-" : "";
        l2 = Math.abs(l2);
        long l3 = this.getPeakMemoryDelta();
        String string2 = l3 < 0L ? "-" : "";
        l3 = Math.abs(l3);
        StringBuilder stringBuilder = new StringBuilder();
        long l4 = this.mElapsedTimeNs;
        stringBuilder.append(String.format("%s took %." + n + "f%s.", this.mTitle, CoreUtil.convertTimeUnit(l4, TimeUnit.NANOSECONDS, timeUnit), CoreUtil.getTimeUnitSymbol(timeUnit)));
        if (l != 0L) {
            String string3 = l < 0L ? "-" : "";
            l = Math.abs(l);
            stringBuilder.append(String.format(" Allocated memory was %s in the beginning and %s in the end (delta: %s%s).", CoreUtil.humanReadableByteCount(this.mStartMemorySizeBytes, true), CoreUtil.humanReadableByteCount(this.mStopMemorySizeBytes, true), string3, CoreUtil.humanReadableByteCount(l, true)));
        } else {
            stringBuilder.append(String.format(" Allocated memory is still %s.", CoreUtil.humanReadableByteCount(this.mStartMemorySizeBytes, true)));
        }
        if (l2 != 0L) {
            stringBuilder.append(String.format(" Free memory was %s in the beginning and %s in the end (delta: %s%s).", CoreUtil.humanReadableByteCount(this.mStartMemoryFreeSizeBytes, true), CoreUtil.humanReadableByteCount(this.mStopMemoryFreeSizeBytes, true), string, CoreUtil.humanReadableByteCount(l2, true)));
        } else {
            stringBuilder.append(String.format(" Free memory is still %s.", CoreUtil.humanReadableByteCount(this.mStartMemoryFreeSizeBytes, true)));
        }
        if (l3 != 0L) {
            stringBuilder.append(String.format(" Peak memory consumption was %s%s.", string2, CoreUtil.humanReadableByteCount(l3, true)));
        } else {
            stringBuilder.append(" There was no memory consumed.");
        }
        stringBuilder.append(String.format(" Max. memory is %s.", CoreUtil.humanReadableByteCount(this.mMaxMemorySizeBytes, true)));
        return stringBuilder.toString();
    }

    public long getPeakMemoryDelta() {
        return this.mPeakMemorySizeBytes - this.mStartPeakMemorySizeBytes;
    }
}

