/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;

public class EnumOption<E extends Enum<E>>
extends Option {
    private E mValue;
    private E mDefaultValue;
    private final Class<E> mClass;

    public EnumOption(E e, boolean bl, Class<E> clazz, String string) {
        super(bl, string);
        this.mDefaultValue = e;
        this.mValue = this.mDefaultValue;
        this.mClass = clazz;
    }

    EnumOption(EnumOption<E> enumOption) {
        super(enumOption.isOnlineModifiable(), enumOption.getDescription());
        this.mValue = enumOption.mValue;
        this.mDefaultValue = enumOption.mDefaultValue;
        this.mClass = enumOption.mClass;
    }

    @Override
    public Option copy() {
        return new EnumOption<E>(this);
    }

    @Override
    public void set(Object object) {
        if (object instanceof String) {
            this.mValue = Enum.valueOf(this.mClass, ((String)object).toUpperCase());
        } else if (this.mClass.isInstance(object)) {
            this.mValue = (Enum)object;
        } else {
            this.throwException(object);
        }
    }

    private final void throwException(Object object) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("Illegal value: ").append(object);
        stringBuilder.append(". Only ");
        String string = "";
        Enum[] enumArray = (Enum[])this.mClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum enum_ = enumArray[n2];
            stringBuilder.append(string).append(enum_.name());
            string = ", ";
            ++n2;
        }
        stringBuilder.append(" allowed!");
        throw new SMTLIBException(stringBuilder.toString());
    }

    public final E getValue() {
        return this.mValue;
    }

    @Override
    public Object get() {
        return ((Enum)this.mValue).name();
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return ((Enum)this.mDefaultValue).name();
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

