/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ResultWithSideEffects;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ExpressionResultBuilder {
    private final List<Statement> mStatements = new ArrayList<Statement>();
    private final List<Declaration> mDeclarations = new ArrayList<Declaration>();
    private final List<Overapprox> mOverappr = new ArrayList<Overapprox>();
    private final Set<AuxVarInfo> mAuxVars = new LinkedHashSet<AuxVarInfo>();
    private final List<ExpressionResult> mNeighbourUnionFields = new ArrayList<ExpressionResult>();
    private LRValue mLrVal;

    public ExpressionResultBuilder() {
    }

    public ExpressionResultBuilder(ExpressionResultBuilder expressionResultBuilder) {
        this.mStatements.addAll(expressionResultBuilder.getStatements());
        this.mDeclarations.addAll(expressionResultBuilder.getDeclarations());
        this.mOverappr.addAll(expressionResultBuilder.getOverappr());
        this.mAuxVars.addAll(expressionResultBuilder.getAuxVars());
        this.mNeighbourUnionFields.addAll(expressionResultBuilder.getNeighbourUnionFields());
        this.mLrVal = expressionResultBuilder.getLrValue();
    }

    public ExpressionResultBuilder(ExpressionResult expressionResult) {
        this.mStatements.addAll(expressionResult.getStatements());
        this.mDeclarations.addAll(expressionResult.getDeclarations());
        this.mOverappr.addAll(expressionResult.getOverapprs());
        this.mAuxVars.addAll(expressionResult.getAuxVars());
        this.mNeighbourUnionFields.addAll(expressionResult.getNeighbourUnionFields());
        this.mLrVal = expressionResult.getLrValue();
    }

    public boolean isEmpty() {
        return this.mStatements.isEmpty() && this.mDeclarations.isEmpty() && this.mOverappr.isEmpty() && this.mAuxVars.isEmpty() && this.mNeighbourUnionFields.isEmpty() && this.mLrVal == null;
    }

    public ExpressionResultBuilder setLrValue(LRValue lRValue) {
        if (this.mLrVal != null) {
            throw new IllegalStateException("LRValue has already been set");
        }
        this.mLrVal = lRValue;
        return this;
    }

    public ExpressionResultBuilder addStatement(Statement statement) {
        this.mStatements.add(statement);
        return this;
    }

    public <T extends Statement> ExpressionResultBuilder addStatements(Collection<T> collection) {
        this.mStatements.addAll(collection);
        return this;
    }

    public ExpressionResultBuilder addStatementAndAnnotateOverapprox(Statement statement) {
        for (Overapprox overapprox : this.mOverappr) {
            overapprox.annotate((IElement)statement);
        }
        this.mOverappr.clear();
        this.mStatements.add(statement);
        return this;
    }

    public <T extends Statement> ExpressionResultBuilder addStatementsAndAnnotateOverapprox(Collection<T> collection) {
        for (Statement statement : collection) {
            this.addStatementAndAnnotateOverapprox(statement);
        }
        return this;
    }

    public ExpressionResultBuilder addDeclaration(Declaration declaration) {
        this.mDeclarations.add(declaration);
        return this;
    }

    public <T extends Declaration> ExpressionResultBuilder addDeclarations(Collection<T> collection) {
        this.mDeclarations.addAll(collection);
        return this;
    }

    public ExpressionResultBuilder addOverapprox(Overapprox overapprox) {
        this.mOverappr.add(overapprox);
        return this;
    }

    public ExpressionResultBuilder addOverapprox(Collection<Overapprox> collection) {
        this.mOverappr.addAll(collection);
        return this;
    }

    public ExpressionResultBuilder addAuxVarWithDeclaration(AuxVarInfo auxVarInfo) {
        this.mAuxVars.add(auxVarInfo);
        this.mDeclarations.add((Declaration)auxVarInfo.getVarDec());
        return this;
    }

    public ExpressionResultBuilder addAuxVars(Collection<AuxVarInfo> collection) {
        this.mAuxVars.addAll(collection);
        return this;
    }

    public ExpressionResultBuilder addNeighbourUnionField(ExpressionResult expressionResult) {
        this.mNeighbourUnionFields.add(expressionResult);
        return this;
    }

    public ExpressionResultBuilder addNeighbourUnionFields(Collection<ExpressionResult> collection) {
        this.mNeighbourUnionFields.addAll(collection);
        return this;
    }

    public ExpressionResultBuilder addAllExceptLrValueAndHavocAux(ExpressionResult expressionResult) {
        this.addAllExceptLrValue(expressionResult);
        this.havocAuxVars();
        return this;
    }

    public ExpressionResultBuilder addAllExceptLrValue(ExpressionResult expressionResult) {
        this.addStatements(expressionResult.getStatements());
        this.addAllExceptLrValueAndStatements(expressionResult);
        return this;
    }

    public ExpressionResultBuilder addAllExceptLrValueAndOverapproximation(ExpressionResult expressionResult) {
        this.addStatements(expressionResult.getStatements());
        this.addDeclarations(expressionResult.getDeclarations());
        this.addAuxVars(expressionResult.getAuxVars());
        if (expressionResult.getNeighbourUnionFields() != null && !expressionResult.getNeighbourUnionFields().isEmpty()) {
            this.addNeighbourUnionFields(expressionResult.getNeighbourUnionFields());
        }
        return this;
    }

    public ExpressionResultBuilder addAllExceptLrValue(ExpressionResult ... expressionResultArray) {
        ExpressionResult[] expressionResultArray2 = expressionResultArray;
        int n = expressionResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionResult expressionResult = expressionResultArray2[n2];
            this.addAllExceptLrValue(expressionResult);
            ++n2;
        }
        return this;
    }

    public ExpressionResultBuilder addAllExceptLrValue(Collection<ExpressionResult> collection) {
        for (ExpressionResult expressionResult : collection) {
            this.addAllExceptLrValue(expressionResult);
        }
        return this;
    }

    public ExpressionResultBuilder addAllExceptLrValueAndStatements(ExpressionResult expressionResult) {
        this.addDeclarations(expressionResult.getDeclarations());
        this.addOverapprox(expressionResult.getOverapprs());
        this.addAuxVars(expressionResult.getAuxVars());
        if (expressionResult.getNeighbourUnionFields() != null && !expressionResult.getNeighbourUnionFields().isEmpty()) {
            this.addNeighbourUnionFields(expressionResult.getNeighbourUnionFields());
        }
        return this;
    }

    public ExpressionResultBuilder addAllSideEffects(ResultWithSideEffects resultWithSideEffects) {
        this.addStatements(resultWithSideEffects.getStatements());
        this.addDeclarations(resultWithSideEffects.getDeclarations());
        this.addAuxVars(resultWithSideEffects.getAuxVars());
        this.addOverapprox(resultWithSideEffects.getOverapprs());
        return this;
    }

    public ExpressionResult build() {
        return new ExpressionResult(this.mStatements, this.mLrVal, this.mDeclarations, this.mAuxVars, this.mOverappr, this.mNeighbourUnionFields);
    }

    public LRValue getLrValue() {
        return this.mLrVal;
    }

    public List<Statement> getStatements() {
        return Collections.unmodifiableList(this.mStatements);
    }

    public List<Declaration> getDeclarations() {
        return Collections.unmodifiableList(this.mDeclarations);
    }

    public List<Overapprox> getOverappr() {
        return Collections.unmodifiableList(this.mOverappr);
    }

    public Set<AuxVarInfo> getAuxVars() {
        return Collections.unmodifiableSet(this.mAuxVars);
    }

    public List<ExpressionResult> getNeighbourUnionFields() {
        return Collections.unmodifiableList(this.mNeighbourUnionFields);
    }

    public ExpressionResultBuilder resetLrValue(LRValue lRValue) {
        if (this.mLrVal == null) {
            throw new IllegalStateException("use setLrVal instead");
        }
        this.mLrVal = lRValue;
        return this;
    }

    public ExpressionResultBuilder setOrResetLrValue(LRValue lRValue) {
        if (this.mLrVal == null) {
            this.setLrValue(lRValue);
        } else {
            this.resetLrValue(lRValue);
        }
        return this;
    }

    public ExpressionResultBuilder resetStatements(List<Statement> list) {
        assert (list != this.mStatements) : "Someone hijacked our list";
        this.mStatements.clear();
        this.mStatements.addAll(list);
        return this;
    }

    public ExpressionResultBuilder addAllIncludingLrValue(ExpressionResult expressionResult) {
        return this.addAllExceptLrValue(expressionResult).setLrValue(expressionResult.getLrValue());
    }

    public String toString() {
        return this.build().toString();
    }

    public void havocAuxVars() {
        this.addStatements(CTranslationUtil.createHavocsForAuxVars(this.getAuxVars()));
        this.clearAuxVars();
    }

    public void clearAuxVars() {
        this.mAuxVars.clear();
    }
}

