/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import java.util.List;
import java.util.function.Predicate;

public final class PolyIdentifier
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(PolyIdentifier.class);
    String identifier;
    String[] labelList;
    String[] varList;

    public PolyIdentifier(String string) {
        this.identifier = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid PolyIdentifier: " + String.valueOf(this);
    }

    public PolyIdentifier(String string, String[] stringArray, String[] stringArray2) {
        this.identifier = string;
        this.labelList = stringArray;
        this.varList = stringArray2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid PolyIdentifier: " + String.valueOf(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolyIdentifier").append('[');
        stringBuffer.append(this.identifier);
        stringBuffer.append(',');
        if (this.labelList == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.labelList.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.labelList[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.varList == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.varList.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.varList[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getLabelList() {
        return this.labelList;
    }

    public String[] getVarList() {
        return this.varList;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        aCSLVisitor.visit(this);
    }

    @Override
    public PolyIdentifier accept(ACSLTransformer aCSLTransformer) {
        PolyIdentifier polyIdentifier = aCSLTransformer.transform(this);
        if (polyIdentifier != this) {
            return polyIdentifier;
        }
        return this;
    }
}

